(*=========================================================================*)
(* UNITE    : _unitpyr.pas                                                 *)
(*                                                                         *)
(* date     : 12.08.93                                                     *)
(* compiler : turbo pascal 5.5                                             *)
(*                                                                         *)
(*=========================================================================*)
(*   cette unit contient des routines utilises dans le programme de      *)
(*   construction de pyramides animes.                                    *)
(*=========================================================================*)

UNIT _unitpyr;

(*=========================================================================*)
(*  INTERFACE                                                              *)
(*=========================================================================*)

Interface

Uses _declpyr;

Const _modecurseur: 0..1=1;
      _Home=#173;
      _End=#171;
      _Up=#161;
      _Dn=#160;
      _Right=#159;
      _Left=#158;
      _CR= ^M;

Type _choixrub=record
                 nom:string[30];
                 num:integer;
                 col,lign:byte;
               end;

     _liste=array[1..40,1..2]of _choixrub;


Function _readkey:char;
Function _moniteurcoul:boolean;
Procedure _erreur(colonne,ligne:byte);
Procedure _ok(colonne,ligne:byte);
Function _int_range(Min,Max,nombre:integer):boolean;
Function _real_range(Min,Max,nombre:real):boolean;
Function _minuscule(car:char):boolean;
Function _chiffre(car:char):boolean;
Function _supprim_esp(str:_workstr):_workstr;
Procedure _str_to_num(str:_workstr;var real_nombre:real;var code:integer);
Procedure _str_to_int(str:_workstr;var int_nombre,code:integer);
Procedure _lirentier(var E,detect:integer;colonne,ligne:byte);
Procedure _lirecar(var res:char;var detect:integer;X1,X2,ligne:byte;
                  chx1,chx2:char);
Procedure _lireel(var R:real;var donne:boolean;var detect:integer;colonne,
                 ligne:byte;min,max:real);
Procedure _infocurseur;
Procedure _curseurinvis;
Procedure _curseurvisibl;
Procedure _go(colonne,ligne:byte);
Procedure _horizontal(colonne,ligne,longueur,caractere:byte);
Procedure _vertical(colonne,ligne,longueur,caractere:byte);
Procedure _lignvides(lignes:byte);
Procedure _attendre;
Procedure _attends_touche;
Function _reponsparON(colonne,ligne,coul:byte;question:_workstr;
                      entree,default:boolean):boolean;
Procedure _barre_select(liste:_liste;chxgra:boolean;coulfond,coulplan,
                       coulindic,ligne,colonne:byte;var lign,col:byte);
Procedure _invers_oui;
Procedure _invers_non;
Procedure _ecrit(colonne,ligne: byte; str:_workstr);
Procedure _ecrit_invers(colonne,ligne:byte;str: _workstr);
Procedure _ecrit_coul(colonne,ligne,couleur:byte;str:_workstr);
Procedure _ecrit_centr(debut,fin,ligne:byte;str:_workstr;invers:boolean);
Procedure _clean(colonne,ligne,longueur:byte);
Procedure _clean25;
Procedure _setcolor(C1,C2:byte;clear:boolean);
Procedure _settempcolor(C1,C2:byte;clear:boolean);
Procedure _getoldcolor(clear:boolean);


(*=========================================================================*)
(*  IMPLEMENTATION                                                         *)
(*=========================================================================*)

Implementation

Uses crt,DOS;

Var _curdeb,_curfin:byte;    (* position de dbut et de fin du curseur *)
    _regs:registers;

(*-------------------------------------------------------------------------*)
(*  _readkey                                                               *)
(*-------------------------------------------------------------------------*)
FUNCTION _readkey:char;
Var car:char;
Procedure touchesfonction(ccar:char);
begin
  case ccar of
    #71: car:=_Home;
    #79: car:=_End;
    #72: car:=_Up;
    #80: car:=_Dn;
    #77: car:=_Right;
    #75: car:=_Left;
  end;(*case*)
end;
Begin
  car:=readkey;
  if (car <> #0) then begin end
  else touchesfonction(readkey);
  if car= ^M then car:=_CR;
  _readkey:=car;
End;

(*-------------------------------------------------------------------------*)
(*  _moniteurcoul                                                          *)
(*                     Retourne TRUE si un moniteur couleur est install   *)
(*-------------------------------------------------------------------------*)
FUNCTION _moniteurcoul:boolean;
Begin
  intr($11,_regs);   (* software-interrupt *)
  if _regs.ax and $30=$30 then _moniteurcoul:=true
  else _moniteurcoul:=false;
End;

(*-------------------------------------------------------------------------*)
(*  _erreur                                                                *)
(*                     Affiche ERREUR si le choix d'une option ou d'un     *)
(*                     nombre est incorrect                                *)
(*-------------------------------------------------------------------------*)
PROCEDURE _erreur(colonne,ligne:byte);
Begin
  _settempcolor(lightred,black,false);
  _horizontal(colonne,ligne,70,0);
  write('ERREUR');
  _getoldcolor(false);
  _go(colonne,ligne)
End;

(*-------------------------------------------------------------------------*)
(*  _ok                                                                    *)
(*                     Efface le message d'erreur si le choix est correct  *)
(*-------------------------------------------------------------------------*)
PROCEDURE _ok(colonne,ligne:byte);
Begin
  _go(colonne,ligne);
  _horizontal(colonne,ligne,9,0)
End;

(*-------------------------------------------------------------------------*)
(*  _int_range                                                             *)
(*-------------------------------------------------------------------------*)
FUNCTION _int_range(Min,Max,nombre:integer):boolean;
Begin
  if (nombre >= Min) and (nombre <=Max) then _int_range:=true
  else _int_range:=false;
End;

(*-------------------------------------------------------------------------*)
(*  _real_range                                                            *)
(*-------------------------------------------------------------------------*)
FUNCTION _real_range(Min,Max,nombre:real):boolean;
Begin
  if (nombre >=Min) and (nombre <=Max) then _real_range:=true
  else _real_range:=false;
End;

(*-------------------------------------------------------------------------*)
(*  _minuscule                                                             *)
(*-------------------------------------------------------------------------*)
FUNCTION _minuscule(car:char):boolean;
Begin
  if car in ['a'..'z'] then _minuscule:=true
  else _minuscule:=false;
End;

(*-------------------------------------------------------------------------*)
(*  _chiffre                                                               *)
(*-------------------------------------------------------------------------*)
FUNCTION _chiffre(car:char):boolean;
Begin
  if car in ['0'..'9'] then _chiffre:=true
  else _chiffre:=false;
End;

(*-------------------------------------------------------------------------*)
(*  _supprim_esp                                                           *)
(*                     Elimine tous les espaces d'une chaine               *)
(*-------------------------------------------------------------------------*)
FUNCTION _supprim_esp(str:_workstr):_workstr;
Var helpstr:_workstr;
    i:byte;
Begin
  if (length(str) > 79) or (length(str) = 0) then
  begin
    helpstr:='';
    _Error:=10;
  end
  else
  begin
    helpstr:='';  (* crer une chaine vide *)
    for i:=1 to length(str) do
      if (copy(str,i,1)) <> '' then helpstr:=helpstr + copy(str,i,1);
    _Error:=0;
  end;
  _supprim_esp:=helpstr;
End;

(*-------------------------------------------------------------------------*)
(*  _str_to_num                                                            *)
(*                     Convertit une chaine en une valeur numrique. Le    *)
(*                     rsultat est un rel. Les espaces sont supprims.   *)
(*                     Une ventuelle "," est transforme en un "."        *)
(*-------------------------------------------------------------------------*)
PROCEDURE _str_to_num(str:_workstr;var real_nombre:real;var code:integer);
Var z:byte;    (* compteur *)
Begin
  str:=_supprim_esp(str);  (* suppression d'ventuels espaces *)
  if length(str) > 0 then
  begin
    for z:=1 to length(str) do
      if str[z]=',' then str[z]:='.';
    val(str,real_nombre,code);
    if code<>0 then code:=1; (* conversion impossible *)
  end
  else
  begin
    real_nombre:=0;
    code:=0
  end
End;

(*-------------------------------------------------------------------------*)
(*  _str_to_int                                                            *)
(*                     Convertit une chaine en un entier                   *)
(*-------------------------------------------------------------------------*)
PROCEDURE _str_to_int(str:_workstr;var int_nombre,code:integer);
Var res :real;  (* transformation en rel *)
    i : byte;  (* compteur *)
    ok :boolean;  (* conversion ok *)
Begin
  str:=_supprim_esp(str);
  ok:=true;  (* entier accept *)
  for i:=1 to length(str) do
    if (str[i]='.') or (str[i]=',') then ok:=false; (* n'est pas un entier *)
  if ok then
  begin
    _str_to_num(str,res,code);
    if code=0 then (* conversion russie *)
    begin
      if _real_range(-32768.0,32767.0,res) then
      begin
        int_nombre:=trunc(res);
        code:=0;
      end
      else code:=1;
    end
    else code:=1;
  end
  else code:=1;
End;

(*-------------------------------------------------------------------------*)
(*  _lirentier                                                             *)
(*                     Lit une chaine au clavier, la convertit en entier   *)
(*                     si possible et gre les erreurs ventuelles         *)
(*-------------------------------------------------------------------------*)
PROCEDURE _lirentier(var E,detect:integer;colonne,ligne:byte);
Var ch:string;
Begin
  detect:=0;
  readln(ch);
  _str_to_int(ch,E,detect);
  if detect=1 then _erreur(colonne,ligne)
  else _ok(70,ligne)
End;

(*-------------------------------------------------------------------------*)
(*  _lirecar                                                               *)
(*                     Lit un caractre donn au clavier, teste s'il       *)
(*                     correspond aux choix proposs et gre les erreurs   *)
(*                     ventuelles                                         *)
(*-------------------------------------------------------------------------*)
PROCEDURE _lirecar(var res:char;var detect:integer;X1,X2,ligne:byte;
                  chx1,chx2:char);
Var car:char;
Begin
  detect:=0;
  car:=_readkey;
  if ord(car)=13 then
  begin
    res:=chx2;     (* rsultat par dfaut *)
    _ok(X2,ligne)
  end
  else
  begin
    write(car);
    readln;
    if _minuscule(car) then car:=upcase(car);
    if (car=chx1) or (car=chx2) then
    begin
      res:=car;     (* caractre tap valide *)
      _ok(X2,ligne)
    end
    else
    begin
      detect:=1;
      _erreur(X1,ligne)
    end
  end
End;

(*-------------------------------------------------------------------------*)
(*  _lireel                                                                *)
(*                     Lit une chaine au clavier, la convertit en rel si  *)
(*                     possible, teste si ce rel est dans l'intervalle    *)
(*                     donn et gre les erreurs ventuelles               *)
(*-------------------------------------------------------------------------*)
PROCEDURE _lireel(var R:real;var donne:boolean;var detect:integer;colonne,
                 ligne:byte;min,max:real);
Var ch:string;
Begin
  detect:=0;donne:=true;
  readln(ch);
  if ch='' then
  begin
    donne:=false;
    _ok(70,ligne);
    exit
  end;
  _str_to_num(ch,R,detect);
  if detect=0 then
    if _real_range(min,max,R) then _ok(70,ligne)
    else detect:=1;
  if detect=1 then _erreur(colonne,ligne)
End;

(*-------------------------------------------------------------------------*)
(*  _infocurseur                                                           *)
(*                     Retourne la position actuelle du curseur. A         *)
(*                     n'appeler qu'en dbut de programme.                 *)
(*-------------------------------------------------------------------------*)
PROCEDURE _infocurseur;
Begin
  _regs.ah:=$0F;
  intr($10,_regs);
  _regs.ah:=$03;
  intr($10,_regs);
  _curdeb:=_regs.ch;
  _curfin:=_regs.cl;
End;

(*-------------------------------------------------------------------------*)
(*  _curseurinvis                                                          *)
(*                     Rend le curseur invisible                           *)
(*-------------------------------------------------------------------------*)
PROCEDURE _curseurinvis;
Begin
  _regs.ah:=$01;
  _regs.ch:=$20;
  _regs.cl:=$00;
  intr($10,_regs);
  _modecurseur:=0;
End;

(*-------------------------------------------------------------------------*)
(*  _curseurvisibl                                                         *)
(*                     Rend le curseur  nouveau visible                   *)
(*-------------------------------------------------------------------------*)
PROCEDURE _curseurvisibl;
Begin
  _regs.ah:=$01;
  _regs.ch:=_curdeb;
  _regs.cl:=_curfin;
  intr($10,_regs);
  _modecurseur:=1;
End;

(*-------------------------------------------------------------------------*)
(*  _go                                                                    *)
(*                     Version abrge de la procdure pascal              *)
(*                     gotoxy(x,y)                                         *)
(*-------------------------------------------------------------------------*)
PROCEDURE _go(colonne,ligne:byte);
Begin
  gotoxy(colonne,ligne);
End;

(*-------------------------------------------------------------------------*)
(*  _horizontal                                                            *)
(*                     Trace une ligne horizontale avec le caractre       *)
(*                     indiqu.                                            *)
(*-------------------------------------------------------------------------*)
PROCEDURE _horizontal(colonne,ligne,longueur,caractere:byte);
Var i:byte;
Begin
  gotoxy(colonne,ligne);
  for i:=1 to longueur do write(chr(caractere));
End;

(*-------------------------------------------------------------------------*)
(*  _vertical                                                              *)
(*                     Trace une ligne verticale avec le caractre         *)
(*                     indiqu.                                            *)
(*-------------------------------------------------------------------------*)
PROCEDURE _vertical(colonne,ligne,longueur,caractere:byte);
Var i:byte;
Begin
  for i:=ligne to (ligne+longueur-1) do
  begin
    gotoxy(colonne,i);
    write(chr(caractere));
  end;
End;

(*-------------------------------------------------------------------------*)
(*  _lignvides                                                             *)
(*                     Cre  l'cran le nombre de lignes vides            *)
(*                     demandes.                                          *)
(*-------------------------------------------------------------------------*)
PROCEDURE _lignvides(lignes:byte);
Var i:byte;
Begin
  for i:=1 to lignes do writeln;
End;

(*-------------------------------------------------------------------------*)
(*  _attendre                                                              *)
(*                     Attend l'appui d'une touche quelconque              *)
(*-------------------------------------------------------------------------*)
PROCEDURE _attendre;
Var car:char;
Begin
  car:=readkey;
End;

(*-------------------------------------------------------------------------*)
(*  _attends_touche                                                        *)
(*                     Ecrit en video inverse en 25. ligne un texte        *)
(*                     centr et attend l'appui d'une touche. La 25.       *)
(*                     est ensuite efface.                                *)
(*-------------------------------------------------------------------------*)
PROCEDURE _attends_touche;
Const Mess=' Appuyez sur une touche pour continuer ... ';
Begin
  _ecrit_centr(1,80,25,mess,true);
  _curseurinvis;
  _attendre;
End;

(*-------------------------------------------------------------------------*)
(*  _reponsparON                                                           *)
(*                     A la position prcise s'affiche la question       *)
(*                     laquelle nous ne pouvons rpondre que par <O> ou    *)
(*                     <N>. Le caractre frapp est retourn  l'appelant  *)
(*                     Le texte est ensuite effac.                        *)
(*-------------------------------------------------------------------------*)
FUNCTION _reponsparON(colonne,ligne,coul:byte;question:_workstr;
                      entree,default:boolean): boolean;
Var car:char;
Begin
  _ecrit_coul(colonne,ligne,coul,question);
  repeat
    gotoxy(colonne+length(question),ligne);
    car:=readkey;
    if (ord(car)=13) and (entree) then
      if default then car:='o'
      else car:='n';
    car:=upcase(car);
  until car in _oui_ou_non;
  if (car='O') then _reponsparON:=true
  else _reponsparON:=false;
  _clean(colonne,ligne,length(question));
End;

(*-------------------------------------------------------------------------*)
(* _barre_select                                                           *)
(*                     Les rubriques peuvent tre disposes horizontalement*)
(*                     ou verticalement  l'cran. Slection par les       *)
(*                     touches de direction. Selon la disposition seules   *)
(*                     les touches <gauche> <droite> ou/et <haut> <bas>    *)
(*                     seront acceptes. La fonction retourne le numro    *)
(*                     d'ordre de la rubrique valide par <CR>.            *)
(*-------------------------------------------------------------------------*)
PROCEDURE _barre_select(liste:_liste;chxgra:boolean;coulfond,coulplan,
                       coulindic,ligne,colonne:byte;var lign,col:byte);
Var Touches:set of char;
    i,j:byte;  (* compteurs *)
    car:char; (* touche enfonce *)
    CMode:0..1;
    moitie:byte;
Procedure choix;
begin
  _ecrit(liste[i,j].col,liste[i,j].lign,liste[i,j].nom);
  case car of
    _Up :begin
           dec(i);
           if i<1 then i:=ligne;
         end;
    _Left:begin
            dec(j);
            if j<1 then j:=colonne;
          end;
    _Dn:begin
          inc(i);
          if i>ligne then i:=1;
        end;
    _Right:begin
             inc(j);
             if j>colonne then j:=1;
           end;
    _Home:begin
            i:=1;
            j:=1;
          end;
    _End :begin
            i:=ligne;
            j:=colonne;
          end;
  end;(*case*)
  _ecrit_invers(liste[i,j].col,liste[i,j].lign,liste[i,j].nom);
  gotoxy(liste[i,j].col,liste[i,j].lign)
end;
Begin
  CMode:=_modecurseur;
  _settempcolor(coulindic,coulfond,false);
  if not chxgra then
  begin
  _ecrit(31,2,'PAYS PROPOSES');
  _ecrit(17,3,'slectionnez un pays ou une rgion puis validez')
  end
  else
  begin
  _ecrit(28,2,'GRAPHIQUES PROPOSES');
  _ecrit(20,3,'slectionnez successivement 3 variables')
  end;
  _horizontal(15,4,50,254);
  _horizontal(15,1,50,254);
  _getoldcolor(false);
  if (colonne>1) then Touches:=[_Left,_Right,_Dn,_Up,_Home,_End,_CR]
  else Touches:=[_Dn,_Up,_Home,_End,_CR];
  _settempcolor(coulplan,coulfond,false);
  for i:=1 to ligne do
    for j:=1 to colonne do
    _ecrit(liste[i,j].col,liste[i,j].lign,liste[i,j].nom);
  i:=1;j:=1;
  _ecrit_invers(liste[i,j].col,liste[i,j].lign,liste[i,j].nom);
  gotoxy(liste[i,j].col,liste[i,j].lign);
  car:=' ';
  while car<>_CR do
  begin
    _curseurinvis;
    repeat
      car:=_readkey;
    until car in Touches;
    if CMODE=1 then _curseurvisibl;
    if car<>_CR then choix;
  end;
  _getoldcolor(true);
  if not chxgra then
    if (i=ligne) and (j=colonne) then
    begin
      clrscr;
      halt
    end;
  lign:=i;
  col:=j;
End;

(*-------------------------------------------------------------------------*)
(*  _invers_oui                                                            *)
(*                     Echange la couleur de fond et de premier plan.      *)
(*-------------------------------------------------------------------------*)
PROCEDURE _invers_oui;
Begin
  textbackground(_config.prem_plan);
  textcolor(_config.fond);
End;

(*-------------------------------------------------------------------------*)
(*  _invers_non                                                            *)
(*                     Rtablit la couleur de fond et de premier plan.     *)
(*-------------------------------------------------------------------------*)
PROCEDURE _invers_non;
Begin
  textbackground(_config.fond);
  textcolor(_config.prem_plan);
End;

(*-------------------------------------------------------------------------*)
(*  _ecrit                                                                 *)
(*                     Ecrit un texte en un endroit prcis de l'cran.     *)
(*-------------------------------------------------------------------------*)
PROCEDURE _ecrit(colonne,ligne:byte;str:_workstr);
Begin
  gotoxy(colonne,ligne);
  write(str);
End;

(*-------------------------------------------------------------------------*)
(*  _ecrit_invers                                                          *)
(*                     Ecrit un texte en vido inverse en un endroit       *)
(*                     prcis de l'cran.                                   *)
(*-------------------------------------------------------------------------*)
PROCEDURE _ecrit_invers(colonne,ligne:byte;str:_workstr);
Begin
  _invers_oui;
  _ecrit(colonne,ligne,str);
  _invers_non;
End;

(*-------------------------------------------------------------------------*)
(*  _ecrit_coul                                                            *)
(*                     Ecrit un texte dans une couleur spcifie en un     *)
(*                     endroit prcis de l'cran.                          *)
(*-------------------------------------------------------------------------*)
PROCEDURE _ecrit_coul(colonne,ligne,couleur:byte;str:_workstr);
Begin
  if (couleur<>_config.fond) and _moniteurcoul then
  begin
    textcolor(couleur);
    _ecrit(colonne,ligne,str);
    textcolor(_config.prem_plan);
  end
  else _ecrit(colonne,ligne,str);
End;

(*-------------------------------------------------------------------------*)
(*  _ecrit_centr                                                           *)
(*                     Ecrit un texte en video inverse ou non, centr      *)
(*                     entre 2 colonnes,  la ligne indique.              *)
(*-------------------------------------------------------------------------*)
PROCEDURE _ecrit_centr(debut,fin,ligne:byte;str:_workstr;
                       invers:boolean);
var diff,  (* fin-debut/2 *)
    moitie:real;  (* la moiti de la longueur du texte *)
    col:byte;
Begin
  diff:=(fin-debut)/2;
  moitie:=(length(str))/2;
  col:=debut+trunc(diff-moitie);
  if invers then _invers_oui;
  _ecrit(col,ligne,str);
  if invers then _invers_non;
End;

(*-------------------------------------------------------------------------*)
(*  _clean                                                                 *)
(*                     Efface la ligne indique sur une certaine longueur  *)
(*-------------------------------------------------------------------------*)
PROCEDURE _clean(colonne,ligne,longueur:byte);
Begin
  _horizontal(colonne,ligne,longueur,32);
End;

(*-------------------------------------------------------------------------*)
(*  _clean25                                                               *)
(*                     Efface la 25 me ligne de l'cran                   *)
(*-------------------------------------------------------------------------*)
PROCEDURE _clean25;
Begin
  gotoxy(1,25);
  clreol;
End;

(*-------------------------------------------------------------------------*)
(*  _setcolor                                                              *)
(*                     Dfinit les couleurs de premier plan et de fond     *)
(*                     du moniteur. Effectue des contrles de conformit.  *)
(*-------------------------------------------------------------------------*)
PROCEDURE _setcolor(C1,C2:byte;clear:boolean);
Begin
  _config.prem_plan:=C1;
  _config.fond:=C2;
  _setConfigColor;    (* couleurs de configuration *)
  if clear then clrscr;
End;

(*-------------------------------------------------------------------------*)
(*  _settempcolor                                                          *)
(*                     Modifie temporairement les couleurs de premier plan *)
(*                     et de fond. Les valeurs en cours tant stockes,vous*)
(*                     pouvez les rutiliser avec la procdure _getoldcolor*)
(*                     C1=couleur de premier plan, C2=couleur de fond      *)
(*-------------------------------------------------------------------------*)
PROCEDURE _settempcolor(C1,C2:byte;clear:boolean);
Begin
  _OldPremPlan:=_config.prem_plan;
  _OldFond:=_config.fond;
  _setcolor(C1,C2,clear);
End;

(*-------------------------------------------------------------------------*)
(*  _getoldcolor                                                           *)
(*                     Restaure les valeurs prcises pour les couleurs de *)
(*                     premier plan et de fond avant l'appel de la         *)
(*                     procdure _settempcolor.                            *)
(*-------------------------------------------------------------------------*)
PROCEDURE _getoldcolor(clear:boolean);
Begin
  _setcolor(_OldPremPlan,_OldFond,clear);
End;

(*=========================================================================*)
(*  INITIALISATION                                                         *)
(*=========================================================================*)

BEGIN

  _infocurseur;
  _curseurvisibl;

END.

(*=========================================================================*)
(*  END OF UNIT                                                            *)
(*=========================================================================*)









