(*=========================================================================*)
(* UNITE     : _declpyr.pas                                                *)
(*                                                                         *)
(* date      : 03.08.93                                                    *)
(* compiler  : turbo pascal 5.5                                            *)
(*                                                                         *)
(*=========================================================================*)
(* Cette unit contient une dclaration gnrale. Des constantes, types et *)
(* variables, sont dclares, qui trouveront leur emploi dans d'autres     *)
(* units.                                                                 *)
(*=========================================================================*)

Unit _declpyr;

(*=========================================================================*)
(*  INTERFACE                                                              *)
(*=========================================================================*)

Interface

Uses crt,dos;   (* units de turbo pascal 5.5 *)

Const _Error:byte=0;

Type _workstr=string[79];

     registers=record
                 case Integer of
                 0: (AX,BX,CX,DX,BP,SI,DI,DS,ES,Flags:word);
                 1: (AL,AH,BL,BH,CL,CH,DL,DH:byte);
                 end;

     _MonitorPar=record
                   prem_plan:byte;
                   fond:byte;
                 end;

     (* nous employons ce type pour slectionner le moniteur, la couleur *)
     (* de premier plan et de fond. Voici les valeurs valides:           *)
     (* Monit. : 1 noir/blanc       2 noir/jaune                         *)
     (*          3 noir/vert        4 moniteur couleur                   *)
     (* Couleur premier plan et fond :                                   *)
     (*          0 noir      1 bleu        2 vert                        *)
     (*          4 rouge     7 gris       14 jaune                       *)
     (*         15 blanc                                                 *)

Var _touche:char;      (* appui sur une touche *)
    _ok:boolean;   (* emploi d'ordre gnral *)
    _regs:registers;   (* registre du processeur *)
    _config:_MonitorPar;
    _oui_ou_non:set of char;   (* rponse par O ou N *)
    _oui:set of char;
    _non:set of char;
    _OldPremPlan:byte;
    _OldFond:byte;

Procedure _SetConfigColor;

(*=========================================================================*)
(*  IMPLEMENTATION                                                         *)
(*=========================================================================*)

Implementation


(*-------------------------------------------------------------------------*)
(*  _SetConfigColor                                                        *)
(*-------------------------------------------------------------------------*)
PROCEDURE _SetConfigColor;
Begin
  textcolor(_config.prem_plan);
  textbackground(_config.fond);
End;


(*=========================================================================*)
(*   INITIALISATION                                                        *)
(*=========================================================================*)

BEGIN
  _oui_ou_non:=['O','o','N','n'];
  _oui:=['O','o'];
  _non:=['N','n'];
  _config.prem_plan:=white;
  _config.fond:=black;
  _SetConfigColor;
  _OldPremPlan:=_config.prem_plan;
  _OldFond:=_config.fond;
  Clrscr;
END.

(*=========================================================================*)
(*   FIN                                                                   *)
(*=========================================================================*)

