(*=========================================================================*)
(*      PYRAMIDES ANIMEES  ( Turbo Pascal 5.5 - aout 1993 )                *)
(*                 ( Pour cran VGA )     (vers. 1.2 du 28/11/93)          *)
(*                                                                         *)
(*   Programme de projections dmographiques avec affichage continu des    *)
(*   pyramides, des rsultats et des courbes d'volution de l'esprance    *)
(*   de vie,de la fcondit et du taux d'accroissement.                    *)
(*                                                                         *)
(* Ecrit par Sandrine Bertrais                                             *)
(*      (  partir de la version QuickBasic crite par Henri Leridon )     *)
(* INED  27 rue du Commandeur  75014 PARIS. Fax : 33-1 42 18 21 99         *)
(*=========================================================================*)


PROGRAM PYRAVGA(input,output);

   USES crt,graph,_unitpyr;

    (* crt : unit texte de Turbo Pascal version 5.5           *)
    (* graph : unit graphique de Turbo Pascal version 5.5     *)
    (* _unitpyr : unit cre pour les besoins de ce programme *)


(***************************************************************************)
(************  DECLARATION  DES  CONSTANTES  ET  DES  TYPES  ***************)
(***************************************************************************)


(************************** PARAMETRES ECRAN *******************************)

   CONST LEC=640;HEC=480;TXS=150;
         LECGRA=3*(LEC div 4);
         XOR1=(LECGRA div 2 ) - 6;
         XOR2=XOR1+12;
         YOR=HEC-2;
         HM=16;
         NMAX=184;
         ralenti=1000;

    (* HEC : hauteur de l'cran en pixels *)
    (* HM : hauteur d'une marche de la pyramide *)
    (* LEC : largeur de l'cran en pixels *)
    (* LECGRA : largeur de la fentre graphique principale 'pyramide des ges'*)
    (* NMAX : nombre de pays prsents dans le fichier de donnes *)
    (* RALENTI : temps entre chaque pyramide ; pour ralentir : augmenter
                 la valeur de cette constante *)
    (* TXS : hauteur de la zone suprieure rserve pour du texte *)
    (* XOR1,XOR2,YOR : coordonnes points de dpart de la pyramide *)


   TYPE liste=array[1..NMAX]of string;
        tab18=array[1..18]of real;
        tab10=array[1..10]of real;
        mode=0..1;


(***************************************************************************)
(***************  DECLARATION  DES  VARIABLES  GLOBALES  *******************)
(***************************************************************************)

   VAR fich1,fich2:text;
       PAYS:liste;
       i,num:byte;
       AD,DTMOR,DTOBJ,DU,DV,E,graphdriver,graphmode,indic,N,NP,attente:integer;
       CF,echelpop,EV,EV0,EVFIN,EVF0,EVM0,F,F0,initpop,NA,ordev0,ordfec0,
       ordpop0,ordpv0,ordta0,PT,PT0,PV,R,SNR,TA,TAC,TAC0:real;
       PF,PF0,PM,PM0,QF,QM:tab18;
       TF:tab10;
       FIN,REP,surimp:mode;
       MOR,OBJ,PY,VIT:char;
       nomgraph1,nomgraph2,nomgraph3:string;
       bool,donne,stop:boolean;
       gra:array[1..3]of byte;
       absc:array[1..3]of integer;

    (* abscev0,abscfec0,abscta0 : abscisses pour dessins courbes volution *)
    (* AD :anne de dpart *)
    (* bool : rsultat des questions dont les rponses sont <O> ou <N> *)
    (* CF : coefficient pour dessin pyramide *)
    (* donne : indique si l'utilisateur a donn un nombre *)
    (* DTMOR : dure de la transition (annes) vers mortalit finale *)
    (* DTOBJ : dure de la transition (annes) vers objectif *)
    (* DU : dure de la projection (annes) *)
    (* DV : dure supplmentaire de projection (annes) *)
    (* E : entier lu au clavier *)
    (* EV : esprance de vie courante *)
    (* EV0 : esprance de vie initiale *)
    (* EVFIN : objectif pour l'esprance de vie *)
    (* EVF0 : esprance de vie initiale pour les femmes *)
    (* EVM0 : esprance de vie initiale pour les hommes *)
    (* F : objectif pour la fcondit (SNR) *)
    (* F0 : valeur initiale de la SNR *)
    (* fich1 : variable fichier texte reprsentant le fichier de donnes *)
    (* FIN : indicateur de fin du programme *)
    (* graphdriver,graphmode: carte et mode graphiques *)
    (* indic : indicateur d'erreur ventuelle au cours des choix *)
    (* MOR : type de mortalit choisi (constante ou variable) *)
    (* N : valeur courante du nombre d'annes depuis dbut projection *)
    (* NA : nombre de naissances(en 5 ans)pour la priode courante(milliers) *)
    (* num : numro associ au pays choisi par l'utilisateur *)
    (* OBJ : objectif choisi ( fcondit ou taux d'accroissement) *)
    (* ordev0,ordfec0,ordta0 : ordonnes pour dessins courbes volution *)
    (* PAYS : tableau contenant les noms des pays *)
    (* PF : effectifs fminins courants *)
    (* PF0 : effectifs fminins initiaux *)
    (* PM : effectifs masculins courants *)
    (* PM0 : effectifs masculins initiaux *)
    (* PT : population totale courante (milliers) *)
    (* PT0 : population totale initiale (milliers) *)
    (* PY : type de pyramide choisi (relle ou proportionnelle) *)
    (* QF : quotients perspectifs mortalit fminins courants *)
    (* QM : quotients perspectifs mortalit masculins courants *)
    (* R : rel lu au clavier *)
    (* REP : indicateur de demande d'impression d'cran *)
    (* SNR : nombre d'enfants par femme pour la priode courante *)
    (* surimp : indicateur de surimpression de la pyramide initiale *)
    (* TA : objectif pour le taux d'accroissement *)
    (* TAC : taux d'accroissement annuel courant *)
    (* TAC0 : taux d'accroissement annuel initial *)
    (* TF : taux de fcondit initiaux *)


(***************************************************************************)
(************  DECLARATION  DES  FONCTIONS  ET  DES  PROCEDURES  ***********)
(***************************************************************************)


(********************* LECTURE DE LA LISTE DES PAYS ************************)

   PROCEDURE lecture_liste(nomfichier:string;
                           var enreg:liste );
   (*** appel dans le programme principal ***)
   (*** lit dans le fichier 'nomfichier' les noms de tous les pays ***)
   (*** pouvant tre tudis par l'utilisateur et enregistre ces noms ***)
   (*** dans une liste ***)
       (* enreg : tableau des noms de pays proposs *)
       (* fich4 : variable fichier texte (var.loc.) *)
       (* nomfichier : nom du fichier prsentant la liste des pays *)
       (* num1 : numro du pays dans la liste (var.loc.) *)
       (* num2 : numro du pays  l'ONU (var.loc.) *)
     var fich4:text;
         num1,num2:byte;
     Begin
       assign(fich4,nomfichier);
       reset(fich4);  (* ouverture en lecture *)
       while not eof(fich4) do
       begin
         readln(fich4,num1,num2,enreg[num1]);
         delete(enreg[num1],1,8)
       end;
       close(fich4)
     End;

(****************** REORGANISATION DE LA LISTE DES PAYS ********************)


(* le tableau PAYS devrait tre un paramtre des procdures suivantes mais *)
(* il y a alors un problme  la compilation car on dpasse la capacit de *)
(* mmoire alloue pour les variables des procdures *)


   PROCEDURE init_regliste(var liste1,liste2,liste3:_liste);
   (*** appel dans la procdure selection ***)
   (*** initialise des listes de rgions  partir de la liste des noms ***)
   (*** de pays et de la configuration du fichier de donnes ***)
     (* liste1 : liste des rgions du Monde et coordonnes d'affichage *)
     (* liste2 : liste des rgions d'Afrique et coordonnes d'affichage *)
     (* liste3 : liste des rgions d'Asie et coordonnes d'affichage *)
     var i:byte; (* compteur *)
     Begin
       (* liste pour les rgions du Monde *)
       for i:=1 to 4 do
       begin
         liste1[i,1].nom:=PAYS[1+i-1];
         liste1[i,1].num:=1+i-1
       end;
       liste1[5,1].nom:='  Amrique                    ';
       liste1[6,1].nom:=PAYS[96];
       liste1[6,1].num:=96;
       liste1[7,1].nom:=PAYS[141];
       liste1[7,1].num:=141;
       liste1[8,1].nom:=PAYS[173];
       liste1[8,1].num:=173;
       liste1[9,1].nom:=PAYS[182];
       liste1[9,1].num:=182;
       liste1[10,1].nom:=' LISTE SPECIALE              ';
       for i:=1 to 10 do
       begin
         liste1[i,1].col:=25;
         liste1[i,1].lign:=10+i
       end;
       liste1[11,1].nom:='  FIN........................';
       liste1[11,1].col:=25;
       liste1[11,1].lign:=24;
       (* liste pour les rgions d'Afrique *)
       liste2[1,1].nom:=PAYS[4];
       liste2[1,1].num:=4;
       liste2[2,1].nom:=PAYS[5];
       liste2[2,1].num:=5;
       liste2[3,1].nom:=PAYS[22];
       liste2[3,1].num:=22;
       liste2[4,1].nom:=PAYS[31];
       liste2[4,1].num:=31;
       liste2[5,1].nom:=PAYS[38];
       liste2[5,1].num:=38;
       liste2[6,1].nom:=PAYS[44];
       liste2[6,1].num:=44;
       for i:=1 to 6 do
       begin
         liste2[i,1].col:=25;
         liste2[i,1].lign:=12+i
       end;
       liste2[7,1].nom:='  FIN........................';
       liste2[7,1].col:=25;
       liste2[7,1].lign:=24;
       (* liste pour les rgions d'Asie *)
       liste3[1,1].nom:=PAYS[96];
       liste3[1,1].num:=96;
       liste3[2,1].nom:=PAYS[97];
       liste3[2,1].num:=97;
       liste3[3,1].nom:=PAYS[105];
       liste3[3,1].num:=105;
       liste3[4,1].nom:=PAYS[116];
       liste3[4,1].num:=116;
       liste3[5,1].nom:=PAYS[125];
       liste3[5,1].num:=125;
       for i:=1 to 5 do
       begin
         liste3[i,1].col:=25;
         liste3[i,1].lign:=12+i
       end;
       liste3[6,1].nom:='  FIN........................';
       liste3[6,1].col:=25;
       liste3[6,1].lign:=24
     End;

   PROCEDURE init_payliste(depNo,nombre:byte;var liste:_liste);
   (*** appel dans la procdure selection ***)
   (*** initialise une liste de pays  partir de la configuration du ***)
   (*** fichier de donnes et de la liste des noms de pays ***)
     (* depNo : numro associ au premier pays de la liste *)
     (* nombre : nombre de pays dans la liste *)
     (* liste : liste de noms de pays avec leurs coordonnes d'affichage *)
     Var i,   (* compteur *)
         moitie:byte; (* nombre/2 *)
     Begin
       if (nombre>=10) then
       begin
         moitie:=nombre div 2;
         for i:=1 to moitie do
         begin
           liste[i,1].nom:=PAYS[depNo+i-1];
           liste[i,1].num:=depNo+i-1;
           liste[i,1].col:=5;
           liste[i,1].lign:=5+i
         end;
         if (nombre mod 2)=0 then
         begin
           liste[moitie+1,1].nom:='                        ';
           liste[moitie+1,1].col:=5;
           liste[moitie+1,1].lign:=5+moitie+1;
           for i:=1 to moitie do
           begin
             liste[i,2].nom:=PAYS[depNo+moitie+i-1];
             liste[i,2].num:=depNo+moitie+i-1;
             liste[i,2].col:=45;
             liste[i,2].lign:=5+i
           end
         end
         else
         begin
           liste[moitie+1,1].nom:=PAYS[depNo+moitie];
           liste[moitie+1,1].num:=depNo+moitie;
           liste[moitie+1,1].col:=5;
           liste[moitie+1,1].lign:=5+moitie+1;
           for i:=1 to moitie do
           begin
             liste[i,2].nom:=PAYS[depNo+moitie+i];
             liste[i,2].num:=depNo+moitie+i;
             liste[i,2].col:=45;
             liste[i,2].lign:=5+i
           end
         end;
         liste[moitie+1,2].nom:='  FIN...................';
         liste[moitie+1,2].col:=45;
         liste[moitie+1,2].lign:=24
       end
       else
       begin
         for i:=1 to nombre do
         begin
           liste[i,1].nom:=pays[depNo+i-1];
           liste[i,1].num:=depNo+i-1;
           liste[i,1].col:=25;
           liste[i,1].lign:=10+i
         end;
         liste[nombre+1,1].nom:='  FIN......................';
         liste[nombre+1,1].col:=25;
         liste[nombre+1,1].lign:=24
       end
     End;

(****************** SELECTION DU PAYS ETUDIE : INTERFACE *******************)

   PROCEDURE select_pays(coulfond,coulplan,coulindic:byte;
                       var numero:byte);
   (*** appel dans le programme principal ***)
   (*** l'utilisateur choisit le pays qu'il veut tudier avec les ***)
   (*** touches de direction et la touche entre ***)
     (* coulfond,coulplan : couleurs de fond et de premier plan *)
     (* coulindic : couleurs des indications donnes  l'utilisateur *)
     (* liste1 : liste de pays (var.loc.) *)
     (* listeMONDE : liste des rgions du Monde (var.loc.) *)
     (* listeAFRIQ : liste des rgions d'Afrique (var.loc.) *)
     (* listeASIE : liste des rgions d'Asie (var.loc.) *)
     (* numero : numro du pays choisi par l'utilisateur *)
     (* reslign,rescol : position du pays slectionn (var.loc.) *)
     Var reslign,rescol:byte;
         listeMONDE,listeAFRIQ,listeASIE,liste1:_liste;
     Begin
       INIT_REGLISTE(listeMONDE,listeAFRIQ,listeASIE);
       _barre_select(listeMONDE,false,coulfond,coulplan,coulindic,11,1,
                     reslign,rescol);
       if (reslign in [1..3]) or (reslign=9) then
       begin
         numero:=listeMONDE[reslign,rescol].num;
         exit
       end;
       if (reslign=4) then
       begin
         _barre_select(listeAFRIQ,false,coulfond,coulplan,coulindic,7,1,
                       reslign,rescol);
         if (reslign=1) then
         begin
           numero:=listeAFRIQ[reslign,rescol].num;
           exit
         end;
         if (reslign=2) then
         begin
           INIT_PAYLISTE(5,17,liste1);
           _barre_select(liste1,false,coulfond,coulplan,coulindic,9,2,
                         reslign,rescol);
           numero:=liste1[reslign,rescol].num;
           exit
         end;
         if (reslign=3) then
         begin
           INIT_PAYLISTE(22,9,liste1);
           _barre_select(liste1,false,coulfond,coulplan,coulindic,10,1,
                         reslign,rescol);
           numero:=liste1[reslign,rescol].num;
           exit
         end;
         if (reslign=4) then
         begin
           INIT_PAYLISTE(31,7,liste1);
           _barre_select(liste1,false,coulfond,coulplan,coulindic,8,1,
                         reslign,rescol);
           numero:=liste1[reslign,rescol].num;
           exit
         end;
         if (reslign=5) then
         begin
           INIT_PAYLISTE(38,6,liste1);
           _barre_select(liste1,false,coulfond,coulplan,coulindic,7,1,
                         reslign,rescol);
           numero:=liste1[reslign,rescol].num;
           exit
         end;
         if (reslign=6) then
         begin
           INIT_PAYLISTE(44,17,liste1);
           _barre_select(liste1,false,coulfond,coulplan,coulindic,9,2,reslign,
                         rescol);
           numero:=liste1[reslign,rescol].num;
           exit
         end
       end;
       if (reslign=5) then
       begin
         INIT_PAYLISTE(61,35,liste1);
         _barre_select(liste1,false,coulfond,coulplan,coulindic,18,2,reslign,
                       rescol);
         numero:=liste1[reslign,rescol].num;
         exit
       end;
       if (reslign=6) then
       begin
         _barre_select(listeASIE,false,coulfond,coulplan,coulindic,6,1,
                       reslign,rescol);
         if (reslign=1) then
         begin
           numero:=listeASIE[reslign,rescol].num;
           exit
         end;
         if (reslign=2) then
         begin
           INIT_PAYLISTE(97,8,liste1);
           _barre_select(liste1,false,coulfond,coulplan,coulindic,9,1,
                         reslign,rescol);
           numero:=liste1[reslign,rescol].num;
           exit
         end;
         if (reslign=3) then
         begin
           INIT_PAYLISTE(105,11,liste1);
           _barre_select(liste1,false,coulfond,coulplan,coulindic,6,2,reslign,
                         rescol);
           numero:=liste1[reslign,rescol].num;
           exit
         end;
         if (reslign=4) then
         begin
           INIT_PAYLISTE(116,9,liste1);
           _barre_select(liste1,false,coulfond,coulplan,coulindic,10,1,reslign,
                         rescol);
           numero:=liste1[reslign,rescol].num;
           exit
         end;
         if (reslign=5) then
         begin
           INIT_PAYLISTE(125,16,liste1);
           _barre_select(liste1,false,coulfond,coulplan,coulindic,9,2,reslign,
                         rescol);
           numero:=liste1[reslign,rescol].num;
           exit
         end
       end;
       if (reslign=7) then
       begin
         INIT_PAYLISTE(141,32,liste1);
         _barre_select(liste1,false,coulfond,coulplan,coulindic,17,2,reslign,
                       rescol);
         numero:=liste1[reslign,rescol].num;
         exit
       end;
       if (reslign=8) then
       begin
         INIT_PAYLISTE(173,9,liste1);
         _barre_select(liste1,false,coulfond,coulplan,coulindic,10,1,reslign,
                       rescol);
         numero:=liste1[reslign,rescol].num;
         exit
       end;
       if (reslign=10) then
       begin
         INIT_PAYLISTE(183,2,liste1);
         _barre_select(liste1,false,coulfond,coulplan,coulindic,3,1,reslign,
                       rescol);
         numero:=liste1[reslign,rescol].num;
         exit
       end
 End;

(************* SELECTION DES GRAPHIQUES D'EVOLUTION : INTERFACE ************)

   PROCEDURE select_graph(coulfond,coulplan,coulindic:byte;
                          var lign1,lign2,lign3:byte;
                          var nom1,nom2,nom3:string);
     var listegra1,listegra2,listegra3:_liste;
         i,rescol:byte; (* compteur *)
     Begin
       (* initialisation de la liste de slection *)
       listegra1[1,1].nom:='Esprance de vie     ';
       listegra1[2,1].nom:='Fcondit            ';
       listegra1[3,1].nom:='Taux d''accroissement';
       listegra1[4,1].nom:='Population totale    ';
       listegra1[5,1].nom:='Proportion >65 ans   ';
       for i:=1 to 5 do
       begin
         listegra1[i,1].num:=i;
         listegra1[i,1].col:=30;
         listegra1[i,1].lign:=9+i
       end;
       (* choix du premier graphique *)
       _barre_select(listegra1,true,black,lightgreen,white,5,1,lign1,rescol);
       nom1:=listegra1[lign1,1].nom;
       if lign1=5 then
       begin
         lign2:=1;nom2:=listegra1[1,1].nom;
         lign3:=2;nom3:=listegra1[2,1].nom;
         exit
       end;
       for i:=1 to lign1 do
       begin
         _go(30,9+i);
         writeln(listegra1[i,1].nom)
       end;
       (* choix du deuxime graphique *)
       for i:=1 to (5-lign1) do listegra2[i,1]:=listegra1[lign1+i,1];
       _barre_select(listegra2,true,black,lightgreen,white,5-lign1,1,
                     lign2,rescol);
       if lign2=5-lign1 then
       begin
         lign2:=listegra2[lign2,1].num;
         nom2:=listegra1[lign2,1].nom;
         lign3:=3;nom3:=listegra1[3,1].nom;
         exit
       end;
       for i:=1 to lign1 do
       begin
         _go(30,9+i);
         writeln(listegra1[i,1].nom)
       end;
       for i:=1 to lign2 do
       begin
         _go(30,9+lign1+i);
         writeln(listegra2[i,1].nom)
       end;
       (* choix du troisime graphique *)
       for i:=1 to (5-lign1-lign2) do listegra3[i,1]:=listegra2[lign2+i,1];
       _barre_select(listegra3,true,black,lightgreen,white,5-lign2-lign1,1,
                     lign3,rescol);
       lign2:=listegra2[lign2,1].num;
       nom2:=listegra1[lign2,1].nom;
       lign3:=listegra3[lign3,1].num;
       nom3:=listegra1[lign3,1].nom
     End;

(************* LECTURE DES DONNEES CONCERNANT LE PAYS CHOISI ***************)


   PROCEDURE calcul_quot_mort(esp:real;var quotF,quotM :tab18);
   (*** appel dans la procdure lecture et la procdure projection ***)
   (*** calcule les quotients perspectifs de mortalit ***)
      (* A0,A1 : variables en lecture pour calculer QF et QM (var.loc.) *)
      (* fichf,fichm : variables fichiers texte (var.loc.) *)
      (* QGF : variables intermdiaires pour calculer QF (var.loc.) *)
      (* QGM : variables intermdiaires pour calculer QM (var.loc.) *)
      (* X : variable intermdiaire pour calculer QF et QM (var.loc.) *)
     var i:byte; (* compteur *)
         X:real;
         A0,A1,QGM,QGF:tab18;
         fichf,fichm:text;
     Begin
       (* lecture des donnes pour calculer les quotients perpectifs *)
       assign(fichf,'led100.f');
       assign(fichm,'led100.m');
       reset(fichf);
       reset(fichm);  (* ouvertures en lecture *)
       for i:=1 to 17 do
       begin
         read(fichm,A0[i],A1[i]);
         X:=A0[i]*2.30258+A1[i]*ln(100-esp);
         QGM[i]:=exp(X)
       end;
       for i:=1 to 17 do
       begin
         read(fichf,A0[i],A1[i]);
         X:=A0[i]*2.30258+A1[i]*ln(100-esp);
         QGF[i]:=exp(X)
       end;
       close(fichm);close(fichf);
       QGF[18]:=(337.8+0.69798*QGF[17])/1000;
       QGM[18]:=(337.8+0.69798*QGM[17])/1000;
       (* transformation en quotients perspectifs *)
       quotM[1]:=0.65*QGM[1];quotF[1]:=0.65*QGF[1];
       quotM[2]:=0.25*QGM[1]+0.5*QGM[2];quotF[2]:=0.25*QGF[1]+0.5*QGF[2];
       for i:=3 to 17 do
       begin
         quotM[i]:=0.5*(QGM[i-1]+QGM[i]);
         quotF[i]:=0.5*(QGF[i-1]+QGF[i])
       end;
       quotF[18]:=1;quotM[18]:=1
     End;

   PROCEDURE calcul_txfec_naiss(naissred:real;popF:tab18;
                                var tauxfec:tab10;var naiss:real);
   (*** appel dans la procdure lecture ***)
   (*** calcule le tableau des taux de fcondit et le nombre des ***)
   (*** naissances ***)
     (* X : variable intermdiaire de calcul (var.loc.) *)
     Var i:integer; (* compteur *)
         X:real;
     Begin
       for i:=1 to 3 do tauxfec[i]:=0;
       tauxfec[10]:=0;naiss:=0;
       for i:=4 to 9 do
       begin
         X:=5*i - 2.5;
         tauxfec[i]:=naissred*1000*(X-16)*sqr(49-X)/99120;
         naiss:=naiss+5*tauxfec[i]*(popF[i]/1000)
       end
     End;

   PROCEDURE lecture(numero:byte;
                     var depAn:integer;
                     var coeff,esp,esp0,espF0,espM0,fecond0,naiss,pop,pop0,
                         naissred,txaccr,txaccr0:real;
                     var popF,popF0,popM,popM0,quotF,quotM:tab18;
                     var tauxfec:tab10);
   (*** appel dans le programme principal ***)
   (*** lit les donnes concernant le pays choisi pour construire ***)
   (*** la pyramide initiale ***)
       (* coeff : coefficient pour dessin pyramide *)
       (* depAn : anne de dpart *)
       (* esp : esprance de vie courante *)
       (* esp0 : esprance de vie initiale *)
       (* espF0 : esprance de vie initiale pour les femmes *)
       (* espM0 : esprance de vie initiale pour les hommes *)
       (* fecond0 : valeur initiale de la SNR *)
       (* naiss : nombre de naissances(en 5 ans)pour la priode courante *)
       (* naissred : valeur courante de la SNR *)
       (* numero : numro du pays choisi par l'utilisateur *)
       (* ONU : numro du pays  l'ONU (var.loc.) *)
       (* PAYS_ANGL : nom du pays en anglais (var.loc.) *)
       (* PM4 : effectif des 4 premires tranches d'ges (var.loc.) *)
       (* PM8 : effectif des 4 dernires tranches d'ges (var.loc.) *)
       (* pop : population totale courante *)
       (* pop0 : population totale initiale *)
       (* popF[i] : effectif fminin courant pour la tranche d'ge i *)
       (* popF0[i] : effectif fminin initial pour la tranche d'ge i *)
       (* popM[i] : effectif masculin courant pour la tranche d'ge i *)
       (* popM0[i] : effectif masculin initial pour la tranche d'ge i *)
       (* quotF : quotients perspectifs mortalit fminins courants *)
       (* quotM : quotients perspectifs mortalit masculins courants *)
       (* txaccr : taux d'accroissement annuel courant *)
       (* txaccr0 : taux d'accroissement annuel initial *)
       (* tauxfec : taux de fcondit initiaux *)
   var i,j,  (* compteurs *)
         ONU:integer;
         PM4,PM8:real;
         PAYS_ANGL:string;
     Begin
       (* lecture des donnes concernant le pays *)
       assign(fich1,'poponu90.dat');
       reset(fich1);   (* ouverture en lecture *)
       (* on se positionne au bon endroit dans le fichier de donnees *)
       if numero<>1 then
       begin
         j:=(numero-1)*11;
         for i:=1 to j do readln(fich1)
       end;
       read(fich1,numero,ONU,PAYS_ANGL,depAn,txaccr0);
       txaccr0:=txaccr0/1000;
       txaccr:=txaccr0;
       pop0:=0;
       for i:=1 to 18 do
       begin
         read(fich1,popF[i]);
         pop0:=pop0+popF[i];
         popF0[i]:=popF[i]
       end;
       for i:=1 to 18 do
       begin
         read(fich1,popM[i]);
         pop0:=pop0+popM[i];
         popM0[i]:=popM[i]
       end;
       pop:=pop0;
       read(fich1,fecond0,espF0,espM0);
       naissred:=fecond0;
       esp0:=(espF0+espM0)/2;esp:=esp0;
       (* calcul du coefficient pour chelle de la pyramide *)
       PM4:=0;PM8:=0;
       for i:=1 to 4 do PM4:=PM4+popM[i];
       for i:=8 to 11 do PM8:=PM8+popM[i];
       if (PM8 > PM4) then coeff:=(0.9*LECGRA)*pop0/PM8
       else coeff:=(1.25*LECGRA)*pop0/PM4;
       (* calcul des quotients perspectifs de mortalit *)
       CALCUL_QUOT_MORT(esp0,quotF,quotM);
       (* calcul des taux de fcondit et du nombre de naissances *)
       CALCUL_TXFEC_NAISS(naissred,popF,tauxfec,naiss)
     End;

(****************** AFFICHAGE DE LA SITUATION INITIALE *********************)
(************** ET DES OPTIONS A CHOISIR POUR LA PROJECTION ****************)


   PROCEDURE menu_options(numero:byte;depAn:integer;
                          pop0,txaccr0,fecond0,esp0:real);
   (*** appel dans le programme principal ***)
   (*** affiche les options que peut choisir l'utilisateur ***)
     Begin
       (* affichage de la situation initiale *)
       _settempcolor(lightmagenta,black,false);
       _horizontal(6,1,60,42);
       _go(25,2);writeln('SITUATION INITIALE :');
       _go(12,3);writeln(copy(PAYS[numero],1,43),'(',depAn,')');
       _go(10,4);writeln('Population totale (en milliers) : ',pop0:8:0);
       _go(10,5);writeln('Taux d''accroissement (%): ',100*txaccr0:4:2);
       _go(10,6);
       writeln('Taux de fcondit (nbre enfants par femme) : ',fecond0:3:2);
       _go(10,7);writeln('Esprance de vie (annes): ',esp0:4:1);
       _horizontal(6,8,60,42);
       _getoldcolor(false);
       (* choix des options *)
       _go(25,9);writeln('CHOIX DES OBJECTIFS :');
       _settempcolor(lightgray,black,false);
       _go(1,11);
       write('- DUREE DE LA PROJECTION (en annes, valeur par dfaut: 50 ans) : ');
       _go(1,13);
       write('- MORTALITE CONSTANTE (C) OU VARIABLE (V) (C par dfaut) : ');
       _go(1,17);
       write('- OBJECTIF FECONDITE (F) OU TAUX D''ACCROISSEM. CONSTANT (T) : ');
       _go(1,21);
       write('- PYRAMIDE REELLE (R) OU PROPORTIONNELLE (P) (P par dfaut) : ');
       _getoldcolor(false)
     End;

(****************** DESSIN PYRAMIDE ET PROJECTION A 5 ANS ******************)

   PROCEDURE dessin_lign_pyr(No:integer;coulfond,coul1,coul2:byte;coeff,pop,
                             pop0:real;popM,popF:tab18;chxpyr:char);
   (*** appel dans la procdure dessine_pyr ***)
   (*** dessine une ligne de la pyramide ***)
     (* coul : couleur du dessin (var.loc.) *)
     (* coul1,coul2 : couleurs du dessin *)
     (* coulfond : couleur de fond *)
     (* No : numro de la ligne  dessiner [1..18] *)
     (* X1,X2,Y1,Y2 : coordonnes pour construire un rectangle plein (loc.)*)
     var coul,X1,X2,Y1,Y2:integer;
     Begin
       setviewport(0,TXS,LECGRA,HEC,clipon);
       coul:=coul1;X1:=0;X2:=0;Y1:=0;Y2:=0;
       if not _int_range(5,13,No) then coul:=coul2;
       if chxpyr='R' then popM[No]:=coeff*popM[No]/pop0
       else popM[No]:=coeff*popM[No]/pop;
       X1:=XOR1;
       Y1:=YOR-(No*HM);
       X2:=XOR1-round(popM[No]);
       Y2:=Y1+HM-1;
       if (X2 < 3) then X2:=3;
       setfillstyle(1,coul);
       bar(X2,Y1,X1,Y2);
       setfillstyle(1,coulfond);
       if No<14 then bar(4,Y1,X2,Y2) else bar(40,Y1,X2,Y2);
       if chxpyr='R' then popF[No]:=coeff*popF[No]/pop0
       else popF[No]:=coeff*popF[No]/pop;
       X1:=XOR2;
       Y1:=YOR-(No*HM);
       X2:=XOR2+round(popF[No]);
       Y2:=Y1+HM-1;
       if (X2 > (LECGRA-3)) then X2:=LECGRA-3;
       setfillstyle(1,coul);
       bar(X1,Y1,X2,Y2);
       setfillstyle(1,coulfond);
       if No<14 then bar(LECGRA-4,Y1,X2,Y2)
       else bar(LECGRA-40,Y1,X2,Y2);
       if chxpyr='R' then
       begin
         popM[No]:=popM[No]*pop0/coeff;
         popF[No]:=popF[No]*pop0/coeff
       end
       else
       begin
         popM[No]:=popM[No]*pop/coeff;
         popF[No]:=popF[No]*pop/coeff
       end
    End;

   PROCEDURE calcul_et_affich(coulplan,coulfond:byte;naiss,pop,txaccr,esp,
                              naissred:real;popM,popF:tab18;
                              var JE,VI,txmort,txnat,txfecond:real);
   (*** appel dans la procdure dessine_pyr ***)
   (*** calcule et affiche les variables au fur et  mesure de la ***)
   (*** projection ***)
     (* coulfond,coulplan : couleurs de fond et de premier plan *)
     (* JE : proportion de la population < 20 ans *)
     (* PFR : population fminine (var.loc.) *)
     (* txnat : taux de natalit *)
     (* txmort : taux de mortalit *)
     (* txfecond : taux global de fcondit *)
     (* VI : proportion de la population > 65 ans *)
     var PFR:real;
         i:byte; (* compteur *)
     Begin
       (* rpartition par groupe d'ge *)
       JE:=0;VI:=0;
       for i:=1 to 4 do JE:=JE+popM[i]+popF[i];
       JE:=JE/pop;
       if (JE < 0.001) then JE:=0;
       for i:=14 to 18 do VI:=VI+popM[i]+popF[i];
       VI:=VI/pop;
       if (VI < 0.001) then VI:=0;
       (* taux natalit,mortalit,global fcondit *)
       txnat:=(naiss/pop)*200;
       PFR:=0;
       for i:=1 to 4 do PFR:=PFR+popF[i];
       if PFR<>0 then txfecond:=(naiss/PFR)*200;
       txmort:=txnat-1000*txaccr;
       (* affichage de ces valeurs *)
       _settempcolor(coulplan,coulfond,false);
       _go(1,8);
       write('TX.ACCR.(%)=',100*txaccr:4:2,'         ','Esp.Vie=',esp:4:1,
             '           ','SNR=',naissred:4:2);
       _go(1,9);
       write('<20ans(%):',100*JE:4:1,'          ','>65ans(%):',100*VI:4:1,
             '          ','TGF=',txfecond:4:1);
       _getoldcolor(false)
     End;

   PROCEDURE surimprime(popF0,popM0:tab18;coeff,pop,pop0:real;
                        coul1,coul2:byte);
   (*** appel dans le programme principal et dans la procdure pause ***)
     (* coul : couleur du trac (var.loc.) *)
     (* coul1,coul2 : couleurs de dessin *)
     (* XOR1,XOR2,YOR : coordonnes dpart de la pyramide (constantes) *)
     var i, (* compteur *)
         coul,XC1,XC2,X1,X2,Y1:integer;
         X01,X02:real;
     Begin
       i:=1;
       XC1:=XOR1;XC2:=XOR2;
       moveto(XOR1,YOR);
       Y1:=getY;
       while i<19 do
       begin
         if not _int_range(6,14,i) then coul:=coul1
         else coul:=coul2;
         X01:=popM0[i]*coeff/pop0;X02:=popF0[i]*coeff/pop0;
         X1:=round(X01);X2:=round(X02);
         X1:=XOR1-X1;
         setcolor(coul);
         line(XC1,Y1,X1,Y1);
          X2:=XOR2+X2;
         line(XC2,Y1,X2,Y1);
         if i=14 then coul:=coul1;
         if i=5 then coul:=coul2;
         setcolor(coul);
         line(X1,Y1-1,X1,Y1-HM);
         line(X2,Y1-1,X2,Y1-HM);
         XC1:=X1;XC2:=X2;
         Y1:=Y1-HM;
         i:=i+1
       end
     End;

   PROCEDURE modif_param(var dureeproj:integer;
                         var modifopt:mode;
                         var chxpyr:char;
                         var pop,redn:real;
                         var popM,popF:tab18);
   (*** appel dans la procdure pause ***)
   (*** permet de modifier certains paramtres pendant la projection ***)
     (* car : caractre lu au clavier (var.loc.) *)
     (* detect : indicateur d'erreur dans le choix des options (var.loc.) *)
     (* donne : indique si l'utilisateur a donn un nombre (var.loc.) *)
     (* E : entier lu au clavier (var.loc.) *)
     (* modifopt : indicateur de choix de l'option crise dmographique *)
     (* redn : rduction (%) de la natalit *)
     (* RM : rduction (%) de la population masculine 20-39ans par crise(loc.)*)
     (* RP : rduction (%) des autres groupes (masculins ou fminins) (loc.)*)
     var i, (* compteur *)
         E:integer;
         RM,RP:real;
         detect:integer;
         car:char;
         donne:boolean;
     Begin
       _curseurvisibl;
       RM:=0;RP:=0;redn:=0;modifopt:=0;
       for i:=1 to 9 do _horizontal(1,i,60,0);
       _go(1,2);
       writeln('OPTION : - CRISE DEMOGRAPHIQUE (C) ');
       writeln('         - MODIF. DUREE PROJECTION (D) ');
       writeln('         - MODIF. TYPE PYRAMIDE (P) ');
       _ecrit(1,5,'Votre choix : ');
       car:=_readkey;
       if (car='c') or (car='d') or (car='p') then car:=upcase(car);
       for i:=1 to 9 do _horizontal(1,i,60,0);
       detect:=0;
       (* option crise dmographique *)
       if car='C' then
       begin
         _ecrit(1,1,'CRISE DE MORTALITE ');
         REPEAT
         _ecrit(1,2,'- DIMIN.POPUL.MASCUL.20-39ANS(%) : ');
         _lireel(RM,donne,detect,1,15,0,100);
         if detect=1 then _horizontal(1,2,60,0)
         else _horizontal(1,4,60,0);
         UNTIL detect<>1;
         RM:=RM/100;
         detect:=0;
         REPEAT
         _ecrit(1,3,'- DIMIN. AUTRES GROUPES (%) : ');
         _lireel(RP,donne,detect,1,17,0,100);
         if detect=1 then _horizontal(1,3,60,0)
         else _horizontal(1,5,60,0);
         UNTIL detect<>1;
         RP:=RP/100;
         detect:=0;
         REPEAT
         _ecrit(1,4,'CRISE DE NATALITE : DIMIN. NATALITE (%) : ');
         _lireel(redn,donne,detect,1,19,0,100);
         If detect=1 then _horizontal(1,4,60,0)
         else _horizontal(1,6,60,0);
         UNTIL detect<>1;
         redn:=redn/100;
         pop:=0;
         for i:=1 to 18 do
         begin
           popF[i]:=(1-RP)*popF[i];
           pop:=pop+popF[i]
         end;
         for i:=1 to 4 do
         begin
           popM[i]:=(1-RP)*popM[i];
           pop:=pop+popM[i]
         end;
         for i:=5 to 8 do
         begin
           popM[i]:=(1-RM)*popM[i];
           pop:=pop+popM[i]
         end;
         for i:=9 to 18 do
         begin
           popM[i]:=(1-RP)*popM[i];
           pop:=pop+popM[i]
         end;
         modifopt:=1
       end;
       (* option modif. dure de projection *)
       if car='D' then
       begin
         _ecrit(3,2,'MODIF. DE LA DUREE DE PROJECTION');
         REPEAT
         _ecrit(1,4,'Nouvelle dure totale de project.: ');
         _lirentier(E,detect,1,4);
         UNTIL detect<>1;
         if E<>0 then dureeproj:=E
       end;
       (* option modif. pyramide *)
       if car='P' then
       begin
         _ecrit(3,2,'MODIFICATION DU TYPE DE LA PYRAMIDE');
         REPEAT
         _ecrit(1,4,'Pyr. relle (R) ou proport. (P) : ');
         _lirecar(chxpyr,detect,1,70,4,'R','P');
         UNTIL detect<>1
       end;
       _curseurinvis;
       for i:=1 to 9 do _horizontal(1,i,60,0)
     End;

   PROCEDURE pause(popF0,popM0:tab18;coeff,pop0:real;coulfond,coul1,coul2:byte;
                   var modifopt,copy:mode;var dureeproj:integer;
                   var popF,popM:tab18;var chxpyr:char;var pop,redn:real);
   (*** appel dans la procdure dessine_pyr ***)
   (*** permet  l'utilisateur d'interrompre le programme au cours de la ***)
   (*** projection, de demander la surimpression de la pyramide initiale ***)
   (*** de modifier les paramtres, de quitter le programme ***)
     (* car : caractre lu au clavier (var.loc.) *)
     (* bool : rsultat des questions dont les rponses sont <O> ou <N> (loc.)*)
     (* copy : indicateur de copie d'cran *)
     (* coul1,coul2 : couleurs de dessin pour la surimpression *)
     (* coulfond : couleur de fond *)
     (* modifopt : indicateur de choix de l'option crise dmographique *)
     (* redn : rduction (%) de la natalit *)
     (* surimp : indicateur de demande de surimpression pyramide initiale(loc.)*)
     var car:char;
         bool:boolean;
         surimp:mode;
     Begin
       bool:=false;surimp:=0;
       if not keypressed then exit;
       _horizontal(1,1,60,0);
       car:=readkey;
       window(1,1,60,12);
       bool:=_reponsparON(10,1,white,'On continue ? (O/N) ',false,false);
       if bool then exit;
       bool:=_reponsparON(5,1,white,'Pyr. init. en surimpression ? (O/N) : ',false,false);
       if bool then
       begin
         surimprime(popF0,popM0,coeff,pop,pop0,coul1,coul2);
         surimp:=1
       end;
    (* bool:=_reponsparON(10,1,white,'Copie d''cran ? (O/N) :',false);
       if bool then REP:=1;   *)
       bool:=_reponsparON(5,1,white,'On modifie les paramtres ? (O/N) :',false,false);
       if bool then
       begin
          MODIF_PARAM(dureeproj,modifopt,chxpyr,pop,redn,popM,popF);
          if surimp=1 then
          begin
            surimprime(popF0,popM0,coeff,pop,pop0,coul2,coul1);
            surimp:=0
          end;
          exit;
       end;
       bool:=_reponsparON(10,1,white,'On termine ? (O/N) :',false,false);
       if bool then
       begin
         close(fich1);
         closegraph;
         textmode(3);
         halt;
       end;
       if surimp=1 then
       begin
         surimprime(popF0,popM0,coeff,pop,pop0,coul2,coul1);
         surimp:=0
       end
     End;

   PROCEDURE enregistrer(numero:byte;chxmort,chxobj:char;
                         depAn,dureemort,dureeobj,nbreAn:integer;
                         espF0,espM0,JE,naissred,pop,txaccr,txfecond,txnat,
                         txmort,VI:real;
                         popF,popM:tab18);
   (*** appel dans la procdure dessine_pyr ***)
   (*** enregistre les rsultats dans le fichier 'fichout.dat' qui est ***)
   (*** cras  chaque nouvelle projection ***)
     (* JE : proportion de la population < 20 ans *)
     (* PFEM : population totale fminine courante (var.loc.) *)
     (* PMASC : population totale masculine courante (var.loc.) *)
     (* txfecond : taux global de fcondit *)
     (* txmort : taux de mortalit *)
     (* txnat : taux de natalit *)
     (* VI : proportion de la population > 65 ans *)
     var i:integer; (* compteur *)
         PMASC,PFEM:real;
         chOBJ,chMOR,M1,M2:string;
         chAGE:array[1..18]of string;
     Begin
       for i:=1 to 78 do write(fich2,'-');
       writeln(fich2,'');writeln(fich2,'');
       writeln(fich2,'PAYS : ',copy(PAYS[numero],2,43));
       writeln(fich2,'');
       if chxobj='F' then chOBJ:='SNR';
       if chxobj='T' then chOBJ:='TX ACC.';
       if chxmort='C' then chMOR:='CSTE';
       if chxmort='V' then chMOR:='VAR.';
       writeln(fich2,'OPTIONS : ',chOBJ,' CONSTANT APRES ',dureeobj,' ANNEES');
       if chxmort='C' then
       writeln(fich2,'           MORTALITE ',chMOR);
       if chxmort='V' then
       writeln(fich2,'           MORTALITE ',chMOR,' CONSTANTE APRES ',
               dureemort,' ANNEES.');
       writeln(fich2,'');
       PMASC:=0;PFEM:=0;
       writeln(fich2,'');
       writeln(fich2,'PERIODE :',depAn+nbreAn,'-',depAn+nbreAn+4);
       for i:=1 to 40
        do write(fich2,'-');
       writeln(fich2,'');
       writeln(fich2,' AGE           HOMMES           FEMMES');
       writeln(fich2,'');
       for i:=1 to 18 do
       begin
         PMASC:=PMASC+popM[i];
         PFEM:=PFEM+popF[i];
         str(5*(i-1),M1);str(5*(i-1)+4,M2);
         chAGE[i]:=M1+'-'+M2
       end;
       chAGE[18]:='85 &+';
       for i:=1 to 18 do
       begin
         if i<3 then write(fich2,'  ');
         write(fich2,chAGE[i]);
         write(fich2,'         ');
         write(fich2,popM[i]:8:0);
         write(fich2,'         ');
         writeln(fich2,popF[i]:8:0)
       end;
       write(fich2,'TOTAL : ','      ',PMASC:8:0);
       writeln(fich2,'         ',PFEM:8:0);
       writeln(fich2,'');
       writeln(fich2,'POPUL. TOTALE (milliers):',pop:8:0);
       write(fich2,'% < 20 ans : ',100*JE:3:1);
       writeln(fich2,'        ','% > 65 ans : ',100*VI:3:1);
       write(fich2,'ESP. VIE M : ',espM0:3:1);
       writeln(fich2,'        ','ESP. VIE F : ',espF0:3:1);
       writeln(fich2,'');
       writeln(fich2,'TX BRUT MORTALITE (p.1000): ',txmort:3:1);
       writeln(fich2,'TX BRUT NATALITE  (p.1000): ',txnat:3:1);
       writeln(fich2,'TX D''ACCROISSEMENT (%): ',100*txaccr:4:2);
       writeln(fich2,'TX GLOBAL DE FECONDITE (p.1000): ',txfecond:4:1);
       writeln(fich2,'SOMME DES NAISSANCES REDUITES : ',naissred:4:2)
     End;

   PROCEDURE projection(dureemort,dureeobj:integer;
                        espfin,fecond0,fecondfin,redn:real;
                        tauxfec:tab10;
                        chxmort,chxobj:char;
                        var modifopt:mode;
                        var nbrAn:integer;
                        var popF,popM,quotF,quotM:tab18;
                        var esp,esp0,pop,naiss,naissred,txaccr,txaccr0,txfin:real);
   (*** appel dans la procdure dessine_pyr ***)
   (*** effectue une projection dmographique en fonction des options ***)
   (*** choisies par l'utilisateur ***)
     (* fecondfin : objectif pour la fcondit (SNR) *)
     (* modifopt : indicateur de choix de l'option crise dmographique *)
     (* quotF : quotients perspectifs mortalit fminins courants *)
     (* quotM : quotients perspectifs mortalit masculins courants *)
     (* redn : rduction (%) de la natalit *)
     (* tauxfec : taux de fcondit initiaux *)
     (* txfin : taux d'accroissement fix comme objectif *)
     var i:integer; (* compteur *)
         KF,NF,NM,NS,PA,Q1,S1,TAC5,TT,TC:real;
         AF,AM:tab18;
     Begin
       nbrAn:=nbrAn+5;
       PA:=pop;pop:=0;
       for i:=1 to 18 do
       begin
         AF[i]:=popF[i];
         AM[i]:=popM[i]
       end;
       if chxmort='V' then
       (* projection par esprance de vie finale donne *)
       begin
       if (nbrAn<=dureemort) then
       begin
         esp:=esp0+(espfin-esp0)*(nbrAn/dureemort);
         CALCUL_QUOT_MORT(esp,quotF,quotM)
       end
       end;
       for i:=2 to 18 do
       begin
         popF[i]:=AF[i-1]*(1000-quotF[i])/1000;
         popM[i]:=AM[i-1]*(1000-quotM[i])/1000;
         pop:=pop+popM[i]+popF[i];
       end;
       naiss:=0;
       if chxobj='T' then
       (* projection par taux d'accroissement final donn *)
       begin
         TT:=txaccr0;TC:=txfin/100;
         if nbrAn<=dureeobj then TC:=TT+((txfin/100)-TT)*(nbrAn/dureeobj);
         TAC5:=exp(5*ln(1+TC))-1;
         Q1:=(quotM[1]+quotF[1])/2;
         S1:=(1000-Q1)/1000;
         naiss:=((2+TAC5)*PA-(2-TAC5)*pop)/((2-TAC5)*S1);
         naissred:=0;NS:=0;
         for i:=4 to 9 do NS:=NS+5*tauxfec[i]*(popF[i]/1000);
         if NS<>0 then naissred:=fecond0*naiss/NS
       end;
       if OBJ='F' then
       (* projection par taux de fcondit final donn *)
       begin
         KF:=fecondfin/fecond0;
         if (nbrAn< dureeobj) then KF:=1+((fecondfin-fecond0)/fecond0)*
                                          (nbrAn/dureeobj);
         naissred:=0;
         for i:=4 to 9 do
         begin
           naissred:=naissred+5*KF*tauxfec[i]/1000;
           naiss:=naiss+(KF*tauxfec[i]*5*(popF[i]+AF[i]))/2000
         end;
       end;
       (* suite commune *)
       if modifopt=1 then
       begin
         naiss:=(1-redn)*naiss;
         naissred:=(1-redn)*naissred;
         modifopt:=0
       end;
       NF:=0.488*naiss;
       NM:=0.5120001*naiss;
       popF[1]:=NF*(1000-quotF[1])/1000;
       popM[1]:=NM*(1000-quotM[1])/1000;
       pop:=pop+popF[1]+popM[1];
       TAC5:=(pop-PA)/PA;
       txaccr:=(exp(0.2*ln(1+TAC5)))-1
     End;

   PROCEDURE dessine_pyr(chxmort,chxobj:char;
                         depAn,dureemort,dureeobj:integer;
                         coeff,espF0,espM0,fecond0,espfin,taux,txaccr0,
                          pop0:real;
                         popM0,popF0:tab18;
                         numero,coulfond,coul1,coul2:byte;
                         var fecond,txaccr,esp,naiss,naissred,pop,VI:real;
                         var chxpyr:char;var dureeproj,nbreAn:integer;
                         var popM,popF:tab18);
   (*** appel dans le programme principal ***)
   (*** procedure principale du programme ***)
     var i:integer;
         ESP0,PJ,R1,R2,RN,TGF,TBN,TBM:real;
         OP:mode;
         chOBJ,chMOR,chPY:string;
     Begin
       esp0:=(espF0+espM0)/2;
       window(1,1,60,12);
       _ecrit(5,1,'APPUYEZ SUR UNE TOUCHE POUR INTERROMPRE...');
       _settempcolor(lightgreen,coulfond,false);
       if chxpyr='R' then chPY:='Relle';
       if chxpyr='P' then chPY:='Propor.';
       _go(1,3);
       writeln('PAYS : ',copy(PAYS[numero],2,25),' (',depAn,')','      PYR=',chPY);
       if chxobj='F' then
       begin
         chOBJ:='FECOND.(SNR)=';
         R1:=fecond
       end;
       if chxobj='T' then
       begin
         chOBJ:='TX.ACCR.(%)=';
         R1:=taux
       end;
       writeln('OBJECTIF : ',chOBJ,R:4:2,' en ',dureeobj,' ans ');
       if chxmort='V' then
       writeln('MORTALITE VARIABLE. Esprance de vie : ',espfin:4:2,' en ',
               dureemort,' ans');
       if chxmort='C' then writeln('MORTALITE CONSTANTE');
       writeln('          ');
       _getoldcolor(false);
       _settempcolor(white,coulfond,false);
       _go(1,7);
       writeln('ANNEE : ',depAn+nbreAn,'    ','    POPULATION (millions):',pop/1000:10:3);
       _getoldcolor(false);
       for i:=1 to 18 do DESSIN_LIGN_PYR(i,coulfond,coul1,coul2,coeff,pop,
                                         pop0,popM,popF,chxpyr);
       CALCUL_ET_AFFICH(white,black,naiss,pop,txaccr,esp,naissred,popM,
                        popF,PJ,VI,TBM,TBN,TGF);
       PAUSE(popF0,popM0,coeff,pop0,coulfond,coul1,coul2,OP,REP,dureeproj,
             popF,popM,chxpyr,pop,RN);
       ENREGISTRER(numero,chxmort,chxobj,depAn,dureemort,dureeobj,nbreAn,
                   espF0,espM0,PJ,naissred,pop,txaccr,TGF,TBN,TBM,
                   VI,popF,popM);
       PROJECTION(dureemort,dureeobj,espfin,fecond0,fecond,RN,TF,
                  chxmort,chxobj,OP,nbreAn,popF,popM,QF,QM,esp,esp0,pop,naiss,
                  naissred,txaccr,txaccr0,taux)
     End;


(************* DESSIN DES COURBES D'EVOLUTION DE L'ESPERANCE ***************)
(*********** DE VIE, DE LA FECONDITE ET DU TAUX D'ACCROISSEMENT ************)


   PROCEDURE evolut_ev(Nograph:byte;dureeproj:integer;esp:real;
                       var X0:integer;var espt0:real);
   (*** appel dans le programme principal ***)
   (*** trace la courbe qui montre l'volution de l'esprance de vie ***)
     var espt1:real;
         inter,X1,Y0,Y1:integer;
     Begin
       espt1:=esp;
       inter:=(148*5)div dureeproj;
       X1:=X0+inter;
       case Nograph of
         1:begin
             setviewport(LECGRA,0,LEC,160,clipon);
             outtextxy(LECGRA+15,5,'ESPERANCE DE VIE');
             Y0:=155-round((espt0-20)*145/80);
             Y1:=155-round((espt1-20)*145/80)
           end;
         2:begin
             setviewport(LECGRA,160,LEC,320,clipon);
             outtextxy(LECGRA+15,165,'ESPERANCE DE VIE');
             Y0:=315-round((espt0-20)*145/80);
             Y1:=315-round((espt1-20)*145/80)
           end;
         3:begin
             setviewport(LECGRA,320,LEC,480,clipon);
             outtextxy(LECGRA+15,325,'ESPERANCE DE VIE');
             Y0:=475-round((espt0-20)*145/80);
             Y1:=475-round((espt1-20)*145/80)
           end;
       end; (* case *)
       setcolor(lightmagenta);
       line(X0,Y0,X1,Y1);
       setcolor(white);
       espt0:=espt1;
       X0:=X1
     End;

   PROCEDURE evolut_fec(Nograph:byte;dureeproj:integer;naissred:real;
                       var X0:integer;var fect0:real);
   (*** appel dans le programme principal ***)
   (*** trace la courbe qui montre l'volution de la fcondit ***)
     var fect1:real;
         inter,X1,Y0,Y1:integer;
     Begin
       fect1:=naissred;
       if fect1<0 then fect1:=0;
       inter:=(148*5)div dureeproj;
       X1:=X0+inter;
       case Nograph of
         1:begin
             setviewport(LECGRA,0,LEC,160,clipon);
             outtextxy(LECGRA+30,5,'FECONDITE');
             Y0:=155-round((fect0)*145/10);
             Y1:=155-round((fect1)*145/10)
           end;
         2:begin
             setviewport(LECGRA,160,LEC,320,clipon);
             outtextxy(LECGRA+30,165,'FECONDITE');
             Y0:=315-round((fect0)*145/10);
             Y1:=315-round((fect1)*145/10)
           end;
         3:begin
             setviewport(LECGRA,320,LEC,480,clipon);
             outtextxy(LECGRA+30,325,'FECONDITE');
             Y0:=475-round((fect0)*145/10);
             Y1:=475-round((fect1)*145/10)
           end;
       end; (* case *)
       setcolor(lightmagenta);
       line(X0,Y0,X1,Y1);
       setcolor(white);
       fect0:=fect1;
       X0:=X1
     End;

   PROCEDURE evolut_tac(Nograph:byte;dureeproj:integer;tauxaccr:real;
                        var X0:integer;var tact0:real);
   (*** appel dans le programme principal ***)
   (*** trace la courbe qui montre l'volution du taux d'accroissement ***)
     var tact1:real;
         inter,X1,Y0,Y1:integer;
     Begin
       tact1:=tauxaccr;
       inter:=(148*5)div dureeproj;
       X1:=X0+inter;
       case Nograph of
         1:begin
             setviewport(LECGRA,0,LEC,160,clipon);
             outtextxy(LECGRA+8,5,'TAUX D''ACCROISSEM.');
             if (tact0 >= 0) then Y0:=100 - round(100*tact0*90/5)
             else Y0:=100 - round(100*tact0*54/3);
             if (tact1 >= 0) then Y1:=100 - round(100*tact1*90/5)
             else Y1:=100 - round(100*tact1*54/3);
           end;
         2:begin
             setviewport(LECGRA,160,LEC,320,clipon);
             outtextxy(LECGRA+8,165,'TAUX D''ACCROISSEM.');
             if (tact0 >= 0) then Y0:=260 - round(100*tact0*90/5)
             else Y0:=260 - round(100*tact0*54/3);
             if (tact1 >= 0) then Y1:=260 - round(100*tact1*90/5)
             else Y1:=260 - round(100*tact1*54/3);
           end;
         3:begin
             setviewport(LECGRA,320,LEC,480,clipon);
             outtextxy(LECGRA+8,325,'TAUX D''ACCROISSEM.');
             if (tact0 >= 0) then Y0:=420 - round(100*tact0*90/5)
             else Y0:=420 - round(100*tact0*54/3);
             if (tact1 >= 0) then Y1:=420 - round(100*tact1*90/5)
             else Y1:=420 - round(100*tact1*54/3);
           end;
       end; (* case *)
       setcolor(lightmagenta);
       line(X0,Y0,X1,Y1);
       setcolor(white);
       tact0:=tact1;
       X0:=X1
     End;

    PROCEDURE evolut_pop(Nograph:byte;dureeproj:integer;echelpop,initpop,
                        pop:real;var X0:integer;var popt0:real;
                        var arret:boolean);
   (*** appel dans le programme principal ***)
   (*** trace la courbe qui montre l'volution de la population totale ***)
     var popt1:real;
         inter,X1,Y0,Y1:integer;
     Begin
       if arret=true then exit;
       popt1:=pop;
       inter:=(148*5)div dureeproj;
       X1:=X0+inter;
       case Nograph of
         1:begin
             setviewport(LECGRA,0,LEC,160,clipon);
             outtextxy(LECGRA+14,5,'POPULATION TOTALE');
             Y0:=108 - round((initpop-popt0)/echelpop);
             Y1:=108 - round((initpop-popt1)/echelpop);
           end;
         2:begin
             setviewport(LECGRA,160,LEC,320,clipon);
             outtextxy(LECGRA+14,165,'POPULATION TOTALE');
             Y0:=268 - round((initpop-popt0)/echelpop);
             Y1:=268 - round((initpop-popt1)/echelpop);
           end;
         3:begin
             setviewport(LECGRA,320,LEC,480,clipon);
             outtextxy(LECGRA+14,325,'POPULATION TOTALE');
             Y0:=428 - round((initpop-popt0)/echelpop);
             Y1:=428 - round((initpop-popt1)/echelpop);
           end;
       end; (* case *)
       setcolor(lightmagenta);
       case Nograph of
         2:begin
             if Y1>=160 then line(X0,Y0,X1,Y1)
             else
             begin
               line(X0,Y0,X1,160);
               arret:=true
             end
           end;
         3:begin
             if Y1>=320 then line(X0,Y0,X1,Y1)
             else
             begin
               line(X0,Y0,X1,320);
               arret:=true
             end
           end
       end; (* case *)
       setcolor(white);
       popt0:=popt1;
       X0:=X1
     End;

    PROCEDURE evolut_pv(Nograph:byte;dureeproj:integer;pv:real;
                        var X0:integer;var pvt0:real);
   (*** appel dans le programme principal ***)
   (*** trace la courbe qui montre l'volution de la proportion des >65ans ***)
     var pvt1:real;
         inter,X1,Y0,Y1:integer;
     Begin
       pvt1:=pv;
       inter:=(148*5)div dureeproj;
       X1:=X0+inter;
       case Nograph of
         1:begin
             setviewport(LECGRA,0,LEC,160,clipon);
             outtextxy(LECGRA+7,5,'PROPORTION >65ans');
             Y0:=155 - round((100*pvt0)*145/25);
             Y1:=155 - round((100*pvt1)*145/25);
           end;
         2:begin
             setviewport(LECGRA,160,LEC,320,clipon);
             outtextxy(LECGRA+7,165,'PROPORTION >65ans');
             Y0:=315 - round((100*pvt0)*145/25);
             Y1:=315 - round((100*pvt1)*145/25);
           end;
         3:begin
             setviewport(LECGRA,320,LEC,480,clipon);
             outtextxy(LECGRA+7,325,'PROPORTION >65ans');
             Y0:=475 - round((100*pvt0)*145/25);
             Y1:=475 - round((100*pvt1)*145/25);
          end;
       end; (* case *)
       setcolor(lightmagenta);
       line(X0,Y0,X1,Y1);
       setcolor(white);
       pvt0:=pvt1;
       X0:=X1
     End;


(***************************************************************************)
(***********************  PROGRAMME  PRINCIPAL  ****************************)
(***************************************************************************)


BEGIN
 attente:=ralenti;

(************************* CHOIX DES OPTIONS *******************************)

NP:=1;


(* PREMIER ECRAN *)

textmode(3);
_settempcolor(yellow,lightgreen,true);
_horizontal(18,2,13,42);
_ecrit(32,2,'PYRAMIDES ANIMEES');
_horizontal(50,2,13,42);
_ecrit(21,5,'Programme de projections dmographiques ');
_horizontal(18,8,10,42);
_ecrit(28,8,'( H.Leridon, INED, 08-93 )');
_horizontal(54,8,9,42);
_vertical(18,3,5,174);
_vertical(62,3,5,175);
_ecrit(10,12,'Ce programme permet de projeter la population de n''importe quel');
_ecrit(10,13,'pays du monde (sans migrations), en choisissant un objectif en');
_ecrit(10,14,'termes de taux d''accroissement ou de fcondit (SNR), et une');
_ecrit(10,15,'volution de la mortalit.');
_ecrit(32,20,'CHOIX DES OPTIONS');
_attends_touche;
_getoldcolor(true);

REPEAT
clrscr;
textmode(3);

(* CHOIX DU PAYS : DEUXIEME ECRAN *)

LECTURE_LISTE('codonufr.dat',PAYS);
SELECT_PAYS(black,cyan,yellow,num);

(* CHOIX DES GRAPHIQUES : TROISIEME ECRAN *)

if NP=1 then
begin
  gra[1]:=1;gra[2]:=2;gra[3]:=3;
  nomgraph1:='Esprance de vie';
  nomgraph2:='Fcondit';
  nomgraph3:='Taux d''accroissement'
end;
clrscr;
_ecrit(10,7,'EN PLUS DE LA PYRAMIDE DES AGES, CE PROGRAMME PERMET DE VOIR');
_ecrit(20,8,'L''EVOLUTION DE CERTAINES VARIABLES.');
_ecrit(10,10,'Par dfaut, vous verrez l''volution de :');
_go(20,12);write('1-',nomgraph1);
_go(20,13);write('2-',nomgraph2);
_go(20,14);write('3-',nomgraph3);
bool:=_reponsparON(20,20,lightmagenta,'Autres choix (O/N) ? ',true,false);
if bool then
begin
  clrscr;
  SELECT_GRAPH(black,cyan,yellow,gra[1],gra[2],gra[3],nomgraph1,nomgraph2,
               nomgraph3)
end;

(* AUTRES OPTIONS : QUATRIEME ECRAN *)

(* lecture des donnes *)
LECTURE(num,AD,CF,EV,EV0,EVF0,EVM0,F0,NA,PT,PT0,SNR,TAC,TAC0,PF,PF0,PM,PM0,
        QF,QM,TF);

REPEAT

(* choix des options pour la projection *)
clrscr;
MENU_OPTIONS(num,AD,PT0,TAC0,F0,EV0);
_curseurvisibl;

REPEAT (* dure de la projection *)
_ecrit(1,11,'- DUREE DE LA PROJECTION (en annes, valeur par dfaut: 50 ans) : ');
_lirentier(E,indic,1,11);
UNTIL indic<>1;
if (E<>0) then DU:=E
else DU:=50;

REPEAT (* mortalit constante ou variable *)
_ecrit(1,13,'- MORTALITE CONSTANTE (C) OU VARIABLE (V) (C par dfaut) : ');
_lirecar(MOR,indic,1,70,13,'V','C')
UNTIL indic<>1;
IF MOR='V' THEN (* option mortalit variable *)
begin
  REPEAT
  _ecrit(3,14,'- ESPERANCE DE VIE FINALE (entre 20 et 99, par dfaut:70.5) : ');
  _lireel(EVFIN,donne,indic,3,14,20,99);
  if not donne then EVFIN:=70.5;
(*  begin
    _erreur(3,14);
    indic:=1
  end;*)
  UNTIL indic<>1;
  REPEAT
  _ecrit(3,15,'- DUREE DE TRANSITION (en annes, par dfaut : 25 ans) : ');
  _lirentier(E,indic,3,15);
  if not _int_range(0,DU,E) then
  begin
    indic:=1;
    _erreur(3,15)
  end;
  UNTIL indic<>1;
  if E<>0 then DTMOR:=E
  else DTMOR:=25
end;

REPEAT (* objectif=fcondit ou taux d'accroissement constant *)
_ecrit(1,17,'- OBJECTIF=FECONDITE (F) OU TAUX D''ACCROISSEM. CONSTANT (T): ');
_lirecar(OBJ,indic,1,70,17,'T','F')
UNTIL indic<>1;
IF OBJ='F' THEN (* option fcondit *)
begin
  repeat
  _ecrit(3,18,'- FECONDITE FINALE (nb d''enfants par femme, de 0  10, df.:2.1): ');
  _lireel(R,donne,indic,3,18,0,10);
  if not donne then R:=2.1;
  until indic<>1;
  if R<>0 then F:=R
  else F:=0.0001
end;
IF OBJ='T' THEN (* option taux d'accroissement constant *)
begin
  repeat
  _ecrit(3,18,'- TAUX D''ACCROISSEMENT (en %, de -2  4, par dfaut: 1.5) : ');
  _lireel(R,donne,indic,3,18,(-2),4);
  if not donne then R:=1.5;
(*  begin
    _erreur(3,18);
    indic:=1
  end;*)
  until indic<>1;
  TA:=R
end;
REPEAT (* dure de transition *)
_ecrit(3,19,'- DUREE DE TRANSITION (en annes, mini=5, 20 ans par dfaut ) : ');
_lirentier(E,indic,3,19);
if not _int_range(0,DU,E) then
begin
  indic:=1;
  _erreur(3,19)
end;
UNTIL indic<>1;
if E<>0 then DTOBJ:=E
else DTOBJ:=20;

REPEAT (* pyramide relle ou proportionnelle *)
_ecrit(1,21,'- PYRAMIDE REELLE (R) OU PROPORTIONNELLE (P) (P par dfaut) : ');
_lirecar(PY,indic,1,70,21,'R','P')
UNTIL indic<>1;

bool:=_reponsparON(15,24,white,'ETES-VOUS SATISFAIT(E) DE VOS CHOIX (0/N) ?',
                true,true);
UNTIL bool=true;

(********************** FIN DU CHOIX DES OPTIONS ***************************)
(*************************** ECRAN D'ATTENTE *******************************)

_curseurinvis;
_settempcolor(yellow,lightgreen,true);
_lignvides(3);
_ecrit(23,4,' ******  O.K. ON Y VA ... ****** ');
_lignvides(2);
_ecrit(19,7,' POUR INTERROMPRE,FRAPPER SUR UNE TOUCHE ');
delay(3000);
_getoldcolor(true);

(************************* CORPS DU PROGRAMME ******************************)

(** INITIALISATION DU MODE GRAPHIQUE ET DEFINITION DES FENETRES GRAPHIQUES **)

graphdriver:=VGA;graphmode:=2;
initgraph(graphdriver,graphmode,'');
if graphresult<>grok then halt(1);
directvideo:=false;

(* premire fentre : graphique volution *)
setviewport(LECGRA,0,LEC,160,clipon);
setlinestyle(0,1,3);
rectangle(LECGRA+1,1,LEC-1,160); (* contours fentre graphique *)

(* deuxime fentre : graphique *)
setviewport(LECGRA,160,LEC,320,clipon);
setlinestyle(0,1,3);
rectangle(LECGRA+1,161,LEC-1,320);  (* contours fentre graphique *)

(* troisime fentre : graphique volution *)
setviewport(LECGRA,320,LEC,480,clipon);
setlinestyle(0,1,3);
rectangle(LECGRA+1,321,LEC-1,479);  (* contours fentre graphique *)

(* initialisations graphiques : premiers points des courbes *)
ordev0:=EV0;
ordfec0:=F0;
ordta0:=TAC0;
ordpop0:=PT0;
echelpop:=((PT0*6/100)-PT0)/103;
initpop:=PT0;
stop:=false;
for i:=1 to 3 do absc[i]:=LECGRA+7;

(* quatrime fentre graphique : pyramide des ges *)
setviewport(0,TXS,LECGRA,HEC,clipon);
outtextxy(180,TXS+8,'PYRAMIDE DES AGES');
setlinestyle(0,1,3);
rectangle(1,TXS+1,LECGRA-1,HEC-1); (* contours fentre graphique *)
setlinestyle(0,1,1);
rectangle(16,169,36,185);
moveto(21,172);lineto(21,182);
moveto(31,172);lineto(31,182);
moveto(22,178);lineto(30,178);
rectangle(443,169,463,185);
moveto(448,172);lineto(448,182);
moveto(449,172);lineto(458,172);
moveto(449,178);lineto(454,178);
moveto(XOR1,YOR);


(************************  CORPS  DU  PROGRAMME  ***************************)
(***************  DESSIN PYRAMIDE ET PROJECTION A 5 ANS  *******************)

N:=0;FIN:=0;bool:=false;surimp:=0;
assign(fich2,'fichout.dat');
rewrite(fich2);
REPEAT
while (N<=DU) and (FIN=0) do
begin
   DESSINE_PYR(MOR,OBJ,AD,DTMOR,DTOBJ,CF,EVF0,EVM0,F0,EVFIN,TA,TAC0,PT0,PM0,
               PF0,num,black,lightblue,yellow,F,TAC,EV,NA,SNR,PT,PV,
               PY,DU,N,PM,PF);
   if N=5 then ordpv0:=pv;
   for i:=1 to 3 do
   begin
     case gra[i] of
      1:EVOLUT_EV(i,DU,EV,absc[i],ordev0);
      2:EVOLUT_FEC(i,DU,SNR,absc[i],ordfec0);
      3:EVOLUT_TAC(i,DU,TAC,absc[i],ordta0);
      4:EVOLUT_POP(i,DU,echelpop,initpop,PT,absc[i],ordpop0,stop);
      5:EVOLUT_PV(i,DU,PV,absc[i],ordpv0);
     end (* case *)
   end;
   delay(attente );
end;
window(1,1,60,12);
_horizontal(1,1,60,0);
bool:=_reponsparON(5,1,white,'Pyr. init. en surimpression ? (O/N) ',false,false);
if bool then
begin
  surimprime(PF0,PM0,CF,PT,PT0,lightblue,yellow);
  surimp:=1
end;
bool:=_reponsparON(5,1,white,'Dure supplmentaire ? (O/N) ',false,false);
if bool then
begin
  REPEAT
  _ecrit(5,1,'Dure supplmentaire : ');
  _lirentier(DV,indic,5,1)
  UNTIL indic<>1;
  DU:=DU+DV;
  if surimp=1 then
  begin
    surimprime(PF0,PM0,CF,PT,PT0,yellow,lightblue);
    surimp:=0
  end
end;
UNTIL N>DU;

(************************** FIN DE PROJECTION ******************************)

close(fich2);
_clean(1,1,80);
(* bool:=_reponsparON(5,1,white,'Impression des rsultats ? (O/N) ',false);
if bool then REP:=1; *)

(* Modif. vitessse affichage) *)
bool:=_reponsparON(5,1,white,'Modifier vitesse excution ? (O/N):',false,false);
if bool then
begin
 REPEAT
 _ecrit(5,1,'Acclrer(A) ou Ralentir(R) ? ');
 _lirecar(VIT,indic,1,45,1,'A','R');
 UNTIL indic<>1;
 if VIT='A' then attente:=ROUND(attente*0.6);
  if VIT='R' then attente:=ROUND(attente*1.7);
end;

bool:=_reponsparON(5,1,white,'Une autre projection ? (O/N)   ',false,false);
if not bool then
begin
  FIN:=1;
  close(fich1);
  closegraph;
  textmode(3);
  halt
end
else NP:=NP+1;

UNTIL FIN=1;

END.
