(*=========================================================================*)
(*        PYRAMIDES ANIMEES ( Turbo Pascal 5.5 - aout 1993 )               *)
(*                      ( version CGA du 21/12/93 )                        *)
(*                                                                         *)
(*   Programme de projections dmographiques avec affichage continu des    *)
(*   pyramides et des rsultats.                                           *)
(*                                                                         *)
(* Ecrit par Sandrine Bertrais                                             *)
(*      (  partir de la version QuickBasic crite par Henri Leridon )     *)
(* INED 27 rue du Commandeur 75014 PARIS. Fax : 33-1 42 18 21 99           *)
(*=========================================================================*)

PROGRAM PYRACGA(input,output);

   USES crt,graph,_unitpyr;

    (* crt : unit texte de Turbo Pascal version 5.5 *)
    (* graph : unit graphique de Turbo Pascal version 5.5 *)
    (* _unitpyr : unit cre pour les besoins de ce programme *)


(***************************************************************************)
(************  DECLARATION  DES  CONSTANTES  ET  DES  TYPES  ***************)
(***************************************************************************)


(************************* PARAMETRES  ECRAN *******************************)

   CONST LEC=320;HEC=200;TXS=28;TXI=28;
         XOR1=(LEC div 2)-10;
         XOR2=XOR1+12;
         YOR=HEC-TXI;
         HM=7;
         NMAX=184;

    (* HEC : hauteur de l'cran en pixels *)
    (* HM : hauteur d'une marche de la pyramide *)
    (* LEC : largeur de l'cran en pixels *)
    (* NMAX : nombre de pays prsents dans le fichier de donnes *)
    (* TXI : hauteur de la zone infrieure rserve pour du texte *)
    (* TXS : hauteur de la zone suprieure rserve pour du texte *)
    (* XOR1,XOR2,YOR : coordonnes points de dpart de la pyramide *)


   TYPE liste=array[1..NMAX]of string;
        tab18=array[1..18]of real;
        tab10=array[1..10]of real;
        mode=0..1;


(***************************************************************************)
(***************  DECLARATION  DES  VARIABLES  GLOBALES  *******************)
(***************************************************************************)

   VAR fich1:text;
       PAYS:liste;
       bool:boolean;
       num:byte;
       MOR,OBJ,PY:char;
       PF,PF0,PM,PM0,QF,QM:tab18;
       TF:tab10;
       FIN,REP,surimp:mode;
       AD,DTMOR,DTOBJ,DU,DV,E,graphdriver,graphmode,indic,N:integer;
       CF,EV,EV0,EVFIN,EVF0,EVM0,F,F0,NA,PT,PT0,R,SNR,TA,TAC,TAC0:real;

    (* AD :anne de dpart *)
    (* bool : rsultat des questions dont les rponses sont <O> ou <N> *)
    (* CF : coefficient pour dessin pyramide *)
    (* DTMOR : dure de la transition(annes) vers mortalit finale *)
    (* DTOBJ : dure de la transition(annes) vers objectif *)
    (* DU : dure de la projection(annes) *)
    (* DV : dure supplmentaire de projection(annes) *)
    (* E : entier lu au clavier *)
    (* EV : esprance de vie courante *)
    (* EV0 : esprance de vie initiale *)
    (* EVFIN : objectif pour l'esprance de vie *)
    (* EVF0 : esprance de vie initiale pour les femmes *)
    (* EVM0 : esprance de vie initiale pour les hommes *)
    (* F : objectif pour la fcondit (SNR) *)
    (* F0 : valeur initiale de la SNR *)
    (* fich1 : variable fichier texte reprsentant le fichier de donnes *)
    (* FIN : indicateur de fin du programme *)
    (* graphdriver,graphmode: carte et mode graphiques *)
    (* indic : indicateur d'erreur ventuelle au cours des choix *)
    (* MOR : type de mortalit choisi (constante ou variable) *)
    (* N : valeur courante du nombre d'annes depuis dbut projection *)
    (* NA : nombre de naissances(en 5 ans)pour la priode courante(milliers) *)
    (* num : numro associ au pays choisi par l'utilisateur *)
    (* OBJ : objectif choisi ( fcondit ou taux d'accroissement) *)
    (* PAYS : tableau contenant les noms des pays *)
    (* PF : effectifs fminins courants *)
    (* PF0 : effectifs fminins initiaux *)
    (* PM : effectifs masculins courants *)
    (* PM0 : effectifs masculins initiaux *)
    (* PT : population totale courante (milliers) *)
    (* PT0 : population totale initiale (milliers) *)
    (* PY : type de pyramide choisi (relle ou proportionnelle) *)
    (* QF : quotients perspectifs mortalit fminins courants *)
    (* QM : quotients perspectifs mortalit masculins courants *)
    (* R : rel lu au clavier *)
    (* REP : indicateur de demande d'impression d'cran *)
    (* SNR : nombre d'enfants par femme pour la priode courante *)
    (* surimp : indicateur de demande de surimpression de pyramide initiale *)
    (* TA : objectif pour le taux d'accroissement *)
    (* TAC : taux d'accroissement annuel courant *)
    (* TAC0 : taux d'accroissement annuel initial *)
    (* TF : taux de fcondit initiaux *)


(***************************************************************************)
(************  DECLARATION  DES  FONCTIONS  ET  DES  PROCEDURES  ***********)
(***************************************************************************)


(*********************** LECTURE DE LA LISTE DES PAYS **********************)

   PROCEDURE lecture_liste(nomfichier:string;
                           var enreg:liste );
   (*** appel dans le programme principal ***)
   (*** lit dans le fichier 'nomfichier' les noms de tous les pays ***)
   (*** pouvant tre tudis par l'utilisateur et enregistre ces noms ***)
   (*** dans une liste ***)
       (* enreg : tableau des noms de pays proposs *)
       (* fich4 : variable fichier texte (var.loc.) *)
       (* nomfichier : nom du fichier prsentant la liste des pays *)
       (* num1 : numro du pays dans la liste (var.loc.) *)
       (* num2 : numro du pays  l'ONU (var.loc.) *)
     var fich4:text;
         num1,num2:byte;
     Begin
       assign(fich4,nomfichier);
       reset(fich4);  (* ouverture en lecture *)
       while not eof(fich4) do
       begin
         readln(fich4,num1,num2,enreg[num1]);
         delete(enreg[num1],1,8)
       end;
       close(fich4)
     End;

(****************** REORGANISATION DE LA LISTE DES PAYS ********************)

(* le tableau PAYS devrait tre un paramtre des procdures suivantes mais *)
(* il y a alors un problme  la compilation car on dpasse la capacit de *)
(* mmoire alloue pour les variables des procdures *)

   PROCEDURE init_regliste(var liste1,liste2,liste3:_liste);
   (*** appel dans la procdure selection ***)
   (*** initialise des listes de rgions  partir de la liste des noms ***)
   (*** de pays et de la configuration du fichier de donnes ***)
     (* liste1 : liste des rgions du Monde et coordonnes d'affichage *)
     (* liste2 : liste des rgions d'Afrique et coordonnes d'affichage *)
     (* liste3 : liste des rgions d'Asie et coordonnes d'affichage *)
     var i:byte; (* compteur *)
     Begin
       (* liste pour les rgions du Monde *)
       for i:=1 to 4 do
       begin
         liste1[i,1].nom:=PAYS[1+i-1];
         liste1[i,1].num:=1+i-1
       end;
       liste1[5,1].nom:='  Amrique                   ';
       liste1[6,1].nom:=PAYS[96];
       liste1[6,1].num:=96;
       liste1[7,1].nom:=PAYS[141];
       liste1[7,1].num:=141;
       liste1[8,1].nom:=PAYS[173];
       liste1[8,1].num:=173;
       liste1[9,1].nom:=PAYS[182];
       liste1[9,1].num:=182;
       liste1[10,1].nom:='LISTE SPECIALE        ';
       for i:=1 to 10 do
       begin
         liste1[i,1].col:=25;
         liste1[i,1].lign:=10+i
       end;
       liste1[11,1].nom:='  FIN........................';
       liste1[11,1].col:=25;
       liste1[11,1].lign:=24;
       (* liste pour les rgions d'Afrique *)
       liste2[1,1].nom:=PAYS[4];
       liste2[1,1].num:=4;
       liste2[2,1].nom:=PAYS[5];
       liste2[2,1].num:=5;
       liste2[3,1].nom:=PAYS[22];
       liste2[3,1].num:=22;
       liste2[4,1].nom:=PAYS[31];
       liste2[4,1].num:=31;
       liste2[5,1].nom:=PAYS[38];
       liste2[5,1].num:=38;
       liste2[6,1].nom:=PAYS[44];
       liste2[6,1].num:=44;
       for i:=1 to 6 do
       begin
         liste2[i,1].col:=25;
         liste2[i,1].lign:=12+i
       end;
       liste2[7,1].nom:='  FIN........................';
       liste2[7,1].col:=25;
       liste2[7,1].lign:=24;
       (* liste pour les rgions d'Asie *)
       liste3[1,1].nom:=PAYS[96];
       liste3[1,1].num:=96;
       liste3[2,1].nom:=PAYS[97];
       liste3[2,1].num:=97;
       liste3[3,1].nom:=PAYS[105];
       liste3[3,1].num:=105;
       liste3[4,1].nom:=PAYS[116];
       liste3[4,1].num:=116;
       liste3[5,1].nom:=PAYS[125];
       liste3[5,1].num:=125;
       for i:=1 to 5 do
       begin
         liste3[i,1].col:=25;
         liste3[i,1].lign:=12+i
       end;
       liste3[6,1].nom:='  FIN........................';
       liste3[6,1].col:=25;
       liste3[6,1].lign:=24
     End;

   PROCEDURE init_payliste(depNo,nombre:byte;var liste:_liste);
   (*** appel dans la procdure selection ***)
   (*** initialise une liste de pays  partir de la configuration du ***)
   (*** fichier de donnes et de la liste des noms de pays ***)
     (* depNo : numro associ au premier pays de la liste *)
     (* nombre : nombre de pays dans la liste *)
     (* liste : liste de noms de pays avec leurs coordonnes d'affichage *)
     Var i,   (* compteur *)
         moitie:byte; (* nombre/2 *)
     Begin
       if (nombre>=10) then
       begin
         moitie:=nombre div 2;
         for i:=1 to moitie do
         begin
           liste[i,1].nom:=PAYS[depNo+i-1];
           liste[i,1].num:=depNo+i-1;
           liste[i,1].col:=5;
           liste[i,1].lign:=5+i
         end;
         if (nombre mod 2)=0 then
         begin
           liste[moitie+1,1].nom:='                    ';
           liste[moitie+1,1].col:=5;
           liste[moitie+1,1].lign:=5+moitie+1;
           for i:=1 to moitie do
           begin
             liste[i,2].nom:=PAYS[depNo+moitie+i-1];
             liste[i,2].num:=depNo+moitie+i-1;
             liste[i,2].col:=45;
             liste[i,2].lign:=5+i
           end
         end
         else
         begin
           liste[moitie+1,1].nom:=PAYS[depNo+moitie];
           liste[moitie+1,1].num:=depNo+moitie;
           liste[moitie+1,1].col:=5;
           liste[moitie+1,1].lign:=5+moitie+1;
           for i:=1 to moitie do
           begin
             liste[i,2].nom:=PAYS[depNo+moitie+i];
             liste[i,2].num:=depNo+moitie+i;
             liste[i,2].col:=45;
             liste[i,2].lign:=5+i
           end
         end;
         liste[moitie+1,2].nom:='  FIN...................';
         liste[moitie+1,2].col:=45;
         liste[moitie+1,2].lign:=24
       end
       else
       begin
         for i:=1 to nombre do
         begin
           liste[i,1].nom:=pays[depNo+i-1];
           liste[i,1].num:=depNo+i-1;
           liste[i,1].col:=25;
           liste[i,1].lign:=10+i
         end;
         liste[nombre+1,1].nom:='  FIN......................';
         liste[nombre+1,1].col:=25;
         liste[nombre+1,1].lign:=24
       end
     End;

(****************** SELECTION DU PAYS ETUDIE : INTERFACE *******************)

   PROCEDURE selection(coulfond,coulplan,coulindic:byte;
                       var numero:byte);
   (*** appel dans le programme principal ***)
   (*** l'utilisateur choisit le pays qu'il veut tudier avec les ***)
   (*** touches de direction et la touche entre ***)
     (* coulfond,coulplan : couleurs de fond et de premier plan *)
     (* coulindic : couleurs des indications donnes a l'utilisateur *)
     (* liste1 : liste de pays (var.loc.) *)
     (* listeMONDE : liste des rgions du Monde (var.loc.) *)
     (* listeAFRIQ : liste des rgions d'Afrique (var.loc.) *)
     (* listeASIE : liste des rgions d'Asie (var.loc.) *)
     (* numero : numro du pays choisi par l'utilisateur *)
     (* reslign,rescol : position du pays selectionn (var.loc.) *)
     Var reslign,rescol:byte;
         listeMONDE,listeAFRIQ,listeASIE,liste1:_liste;
     Begin
       INIT_REGLISTE(listeMONDE,listeAFRIQ,listeASIE);
       _barre_select(listeMONDE,false,coulfond,coulplan,coulindic,11,1,reslign,
                     rescol);
       if (reslign in [1..3]) or (reslign=9) then
       begin
         numero:=listeMONDE[reslign,rescol].num;
         exit
       end;
       if (reslign=4) then
       begin
         _barre_select(listeAFRIQ,false,coulfond,coulplan,coulindic,7,1,reslign,
                       rescol);
         if (reslign=1) then
         begin
           numero:=listeAFRIQ[reslign,rescol].num;
           exit
         end;
         if (reslign=2) then
         begin
           INIT_PAYLISTE(5,17,liste1);
           _barre_select(liste1,false,coulfond,coulplan,coulindic,9,2,reslign,
                         rescol);
           numero:=liste1[reslign,rescol].num;
           exit
         end;
         if (reslign=3) then
         begin
           INIT_PAYLISTE(22,9,liste1);
           _barre_select(liste1,false,coulfond,coulplan,coulindic,10,1,reslign,
                         rescol);
           numero:=liste1[reslign,rescol].num;
           exit
         end;
         if (reslign=4) then
         begin
           INIT_PAYLISTE(31,7,liste1);
           _barre_select(liste1,false,coulfond,coulplan,coulindic,8,1,reslign,
                         rescol);
           numero:=liste1[reslign,rescol].num;
           exit
         end;
         if (reslign=5) then
         begin
           INIT_PAYLISTE(38,6,liste1);
           _barre_select(liste1,false,coulfond,coulplan,coulindic,7,1,reslign,
                         rescol);
           numero:=liste1[reslign,rescol].num;
           exit
         end;
         if (reslign=6) then
         begin
           INIT_PAYLISTE(44,17,liste1);
           _barre_select(liste1,false,coulfond,coulplan,coulindic,9,2,reslign,
                         rescol);
           numero:=liste1[reslign,rescol].num;
           exit
         end
       end;
       if (reslign=5) then
       begin
         INIT_PAYLISTE(61,35,liste1);
         _barre_select(liste1,false,coulfond,coulplan,coulindic,18,2,reslign,
                       rescol);
         numero:=liste1[reslign,rescol].num;
         exit
       end;
       if (reslign=6) then
       begin
         _barre_select(listeASIE,false,coulfond,coulplan,coulindic,6,1,reslign,
                       rescol);
         if (reslign=1) then
         begin
           numero:=listeASIE[reslign,rescol].num;
           exit
         end;
         if (reslign=2) then
         begin
           INIT_PAYLISTE(97,8,liste1);
           _barre_select(liste1,false,coulfond,coulplan,coulindic,9,1,reslign,
                         rescol);
           numero:=liste1[reslign,rescol].num;
           exit
         end;
         if (reslign=3) then
         begin
           INIT_PAYLISTE(105,11,liste1);
           _barre_select(liste1,false,coulfond,coulplan,coulindic,6,2,reslign,
                         rescol);
           numero:=liste1[reslign,rescol].num;
           exit
         end;
         if (reslign=4) then
         begin
           INIT_PAYLISTE(116,9,liste1);
           _barre_select(liste1,false,coulfond,coulplan,coulindic,10,1,reslign,
                         rescol);
           numero:=liste1[reslign,rescol].num;
           exit
         end;
         if (reslign=5) then
         begin
           INIT_PAYLISTE(125,16,liste1);
           _barre_select(liste1,false,coulfond,coulplan,coulindic,9,2,reslign,
                         rescol);
           numero:=liste1[reslign,rescol].num;
           exit
         end
       end;
       if (reslign=7) then
       begin
         INIT_PAYLISTE(141,32,liste1);
         _barre_select(liste1,false,coulfond,coulplan,coulindic,17,2,reslign,
                       rescol);
         numero:=liste1[reslign,rescol].num;
         exit
       end;
       if (reslign=8) then
       begin
         INIT_PAYLISTE(173,9,liste1);
         _barre_select(liste1,false,coulfond,coulplan,coulindic,10,1,reslign,
                       rescol);
         numero:=liste1[reslign,rescol].num;
         exit
       end;
       if(reslign=10) then
       begin
        INIT_PAYLISTE(183,2,liste1);
        _barre_select(liste1,false,coulfond,coulplan,coulindic,3,1,reslign,
                       rescol);
        numero:=liste1[reslign,rescol].num;
        exit
       end
     End;

(************** LECTURE DES DONNEES CONCERNANT LE PAYS CHOISI **************)


   PROCEDURE calcul_quot_mort(esp:real;var quotF,quotM :tab18);
   (*** appel dans la procdure lecture et la procdure projection ***)
   (*** calcule les quotients perspectifs de mortalit ***)
      (* A0,A1 : variables en lecture pour calculer QF et QM (var.loc.) *)
      (* esp : esprance de vie courante *)
      (* fichf,fichm : variables fichiers texte (var.loc.) *)
      (* QGF : variables intermdiaires pour calculer QF (var.loc.) *)
      (* QGM : variables intermdiaires pour calculer QM (var.loc.) *)
      (* quotF :quotients perspectifs mortalit fminins courants *)
      (* quotM : quotients perspectifs mortalit masculins courants *)
      (* X : variable intermdiaire pour calculer QF et QM (var.loc.) *)
     var i:byte; (* compteur *)
         X:real;
         A0,A1,QGM,QGF:tab18;
         fichf,fichm:text;
     Begin
       (* lecture des donnes pour calculer les quotients perpectifs *)
       assign(fichf,'led100.f');
       assign(fichm,'led100.m');
       reset(fichf);
       reset(fichm);  (* ouvertures en lecture *)
       for i:=1 to 17 do
       begin
         read(fichm,A0[i],A1[i]);
         X:=A0[i]*2.30258+A1[i]*ln(100-esp);
         QGM[i]:=exp(X)
       end;
       for i:=1 to 17 do
       begin
         read(fichf,A0[i],A1[i]);
         X:=A0[i]*2.30258+A1[i]*ln(100-esp);
         QGF[i]:=exp(X)
       end;
       close(fichm);close(fichf);
       QGF[18]:=(337.8+0.69798*QGF[17])/1000;
       QGM[18]:=(337.8+0.69798*QGM[17])/1000;
       (* transformation en quotients perspectifs *)
       quotM[1]:=0.65*QGM[1];quotF[1]:=0.65*QGF[1];
       quotM[2]:=0.25*QGM[1]+0.5*QGM[2];quotF[2]:=0.25*QGF[1]+0.5*QGF[2];
       for i:=3 to 17 do
       begin
         quotM[i]:=0.5*(QGM[i-1]+QGM[i]);
         quotF[i]:=0.5*(QGF[i-1]+QGF[i])
       end;
       quotF[18]:=1;quotM[18]:=1
     End;

   PROCEDURE calcul_txfec_naiss(naissred:real;popF:tab18;
                                var tauxfec:tab10;var naiss:real);
   (*** appel dans la procdure lecture ***)
   (*** calcule le tableau des taux de fcondit et le nombre des ***)
   (*** naissances ***)
     (* naiss : nombre de naissances (en 5 ans) pour la priode courante *)
     (* naissred : SNR courante *)
     (* popF : effectifs fminins courants *)
     (* tauxfec : tableau des taux de fcondit *)
     (* X : variable intermdiaire de calcul (var.loc.) *)
     Var i:integer; (* compteur *)
         X:real;
     Begin
       for i:=1 to 3 do tauxfec[i]:=0;
       tauxfec[10]:=0;naiss:=0;
       for i:=4 to 9 do
       begin
         X:=5*i - 2.5;
         tauxfec[i]:=naissred*1000*(X-16)*sqr(49-X)/99120;
         naiss:=naiss+5*tauxfec[i]*(popF[i]/1000)
       end
     End;

   PROCEDURE lecture(numero:byte;
                     var depAn:integer;
                     var coeff,esp,esp0,espF0,espM0,fecond0,naiss,pop,pop0,
                         naissred,txaccr,txaccr0:real;
                     var popF,popF0,popM,popM0,quotF,quotM:tab18;
                     var tauxfec:tab10);
   (*** appel dans le programme principal ***)
   (*** lit les donnes concernant le pays choisi pour construire ***)
   (*** la pyramide initiale ***)
       (* coeff : coefficient pour dessin pyramide *)
       (* depAn : anne de dpart *)
       (* esp : esprance de vie courante *)
       (* esp0 : esprance de vie initiale *)
       (* espF0 : esprance de vie initiale pour les femmes *)
       (* espM0 : esprance de vie initiale pour les hommes *)
       (* fecond0 : valeur initiale de la SNR *)
       (* naiss : nombre de naissances(en 5 ans)pour la priode courante *)
       (* naissred : valeur courante de la SNR *)
       (* numero : numro du pays choisi par l'utilisateur *)
       (* ONU : numro du pays  l'ONU (var.loc.) *)
       (* PAYS_ANGL : nom du pays en anglais (var.loc.) *)
       (* PM4 : effectif des 4 premires tranches d'ges (var.loc.) *)
       (* PM8 : effectif des 4 dernires tranches d'ges (var.loc.) *)
       (* pop : population totale courante *)
       (* pop0 : population totale initiale *)
       (* popF[i] : effectif fminin courant pour la tranche d'ge i *)
       (* popF0[i] : effectif fminin initial pour la tranche d'ge i *)
       (* popM[i] : effectif masculin courant pour la tranche d'ge i *)
       (* popM0[i] : effectif masculin initial pour la tranche d'ge i *)
       (* quotF : quotients perspectifs mortalit fminins courants *)
       (* quotM : quotients perspectifs mortalit masculins courants *)
       (* txaccr : taux d'accroissement annuel courant *)
       (* txaccr0 : taux d'accroissement annuel initial *)
       (* tauxfec : taux de fcondit initiaux *)
     var i,j,  (* compteurs *)
         ONU:integer;
         PM4,PM8:real;
         PAYS_ANGL:string;
     Begin
       (* lecture des donnes concernant le pays *)
       assign(fich1,'poponu90.dat');
       reset(fich1);   (* ouverture en lecture *)
       (* on se positionne au bon endroit dans le fichier de donnes *)
       if numero<>1 then
       begin
         j:=(numero-1)*11;
         for i:=1 to j do readln(fich1)
       end;
       read(fich1,numero,ONU,PAYS_ANGL,depAn,txaccr0);
       txaccr0:=txaccr0/1000;
       txaccr:=txaccr0;
       pop0:=0;
       for i:=1 to 18 do
       begin
         read(fich1,popF[i]);
         pop0:=pop0+popF[i];
         popF0[i]:=popF[i]
       end;
       for i:=1 to 18 do
       begin
         read(fich1,popM[i]);
         pop0:=pop0+popM[i];
         popM0[i]:=popM[i]
       end;
       pop:=pop0;
       read(fich1,fecond0,espF0,espM0);
       naissred:=fecond0;
       esp0:=(espF0+espM0)/2;esp:=esp0;
       (* calcul de coeff pour chelle de la pyramide *)
       PM4:=0;PM8:=0;
       for i:=1 to 4 do PM4:=PM4+popM[i];
       for i:=8 to 11 do PM8:=PM8+popM[i];
       if (PM8 > PM4) then coeff:=(0.9*LEC)*pop0/PM8
       else coeff:=(1.25*LEC)*pop0/PM4;
       (* calcul des quotients perspectifs *)
       CALCUL_QUOT_MORT(esp0,quotF,quotM);
       (* calcul des taux de fcondit et du nombre de naissances *)
       CALCUL_TXFEC_NAISS(naissred,popF,tauxfec,naiss)
     End;


(***************** AFFICHAGE DE LA SITUATION INITIALE **********************)
(************* ET DES OPTIONS A CHOISIR POR LA PROJECTION ******************)


   PROCEDURE menu_options(numero:byte;depAn:integer;
                          pop0,txaccr0,fecond0,esp0:real);
   (*** appel dans le programme principal ***)
   (*** affiche les options que peut choisir l'utilisateur ***)
       (* depAn : anne de dpart *)
       (* esp0 : esprance de vie initiale *)
       (* fecond0 : valeur initiale de la SNR *)
       (* numero : numro associ au pays choisi par l'utilisateur *)
       (* pop0 : population totale initiale *)
       (* txaccr0 : taux d'accroissement annuel initial *)
     Begin
       (* affichage de la situation initiale *)
       _settempcolor(lightmagenta,black,false);
       _horizontal(6,1,60,42);
       _go(12,2);writeln(copy(PAYS[numero],1,43),'(',depAn,')');
       _go(10,4);writeln('Population totale (en milliers) : ',pop0:8:0);
       _go(10,5);writeln('Taux d''accroissement (%): ',100*txaccr0:4:2);
       _go(10,6);
       writeln('Taux de fcondit (nbre d''enfants par femme) : ',fecond0:3:2);
       _go(10,7);writeln('Esprance de vie : ',esp0:4:1);
       _horizontal(6,9,60,42);
       _getoldcolor(false);
       (* choix des options *)
       _settempcolor(lightgray,black,false);
       _go(1,11);
       write('- DUREE DE LA PROJECTION (en annes - 50 ans par dfaut -) : ');
       _go(1,14);
       write('- MORTALITE CONSTANTE (C) OU VARIABLE (V) - C par dfaut - : ');
       _go(1,19);
       write('- OBJECTIF FECONDITE (F) OU TAUX D''ACCROISSEMENT CONSTANT (T): ');
       _go(1,24);
       write('- PYRAMIDE REELLE (R) OU PROPORTIONNELLE (P) - P par dfaut - : ');
       _getoldcolor(false);
     End;

(**************** GESTION DES ERREURS AU COURS DE LA LECTURE ***************)
(******************* DES OPTIONS CHOISIES PAR L'UTILISATEUR ****************)


   PROCEDURE erreur(X,Y:integer);
   (*** appel dans programme principal et plusieurs procdures ***)
   (*** affiche message si choix d'une option incorrect ***)
     Begin
       _settempcolor(lightred,black,false);
       _horizontal(X,Y,70,0);
       write('ERREUR');
       _getoldcolor(false);
       _go(X,Y);
     End;

   PROCEDURE OK(X,Y:integer);
   (*** appel dans programme principal et plusieurs procdures ***)
   (*** efface le message d'erreur si choix correct ***)
     Begin
       _go(X,Y);
       _horizontal(X,Y,9,0);
     End;

   PROCEDURE lirentier(var E:integer;var detect:integer;X,Y:integer);
   (*** appel dans programme principal ***)
   (*** lit une chaine au clavier, la convertit en entier si possible, ***)
   (*** et gre les erreurs ventuelles de l'utilisateur ***)
     var ch:string;
     Begin
       readln(ch);
       _str_to_int(ch,E,detect);
       if (detect=1) then ERREUR(X,Y)
       else OK(70,Y)
     End;

   PROCEDURE lirecar(var res:char;var detect:integer;
                     X1,X2,Y:integer;chx1,chx2:char);
   (*** appel dans programme principal ***)
   (*** lit un caractre donn au clavier , teste s'il correspond aux ***)
   (*** choix proposs et gre les erreurs ventuelles ***)
     var car:char;
     Begin
       detect:=0;
       car:=_readkey;
       if ord(car)=13 then
       begin
         res:=chx2;          (* rsultat par dfaut si l'utilisateur *)
         OK(X2,Y);           (* n'a pas fait de choix *)
       end
       else
       begin
         write(car);
         readln;
         if _minuscule(car) then car:=upcase(car);
         if (car=chx1) or (car=chx2) then
         begin
           res:=car;       (* caractre tap valide *)
           OK(X2,Y)
         end
         else
         begin
           detect:=1;      (* caractre tap non valide *)
           ERREUR(X1,Y)
         end
       end
     End;

   PROCEDURE lireel(var R:real;donne:boolean;var detect:integer;X,Y:integer;
                    MIN,MAX:real);
   (*** appel dans programme principal ***)
   (*** lit une chaine au clavier, la convertit en rel si possible ***)
   (*** teste si ce rel est dans l'intervalle donn et gre ***)
   (*** les erreurs ventuelles de l'utilisateur ***)
     (* donne : si vrai oblige l'utilisateur  donner un nombre *)
     var ch:string;
     Begin
       readln(ch);
       if (ch='') and donne then
       begin
         detect:=1;
         ERREUR(X,Y);
         exit
       end;
       _str_to_num(ch,R,detect);
       if detect=0 then
         if _real_range(MIN,MAX,R) then OK(70,Y)
         else detect:=1;
       if detect=1 then ERREUR(X,Y)
     End;

(****************** DESSIN PYRAMIDE ET PROJECTION A 5 ANS ******************)

   PROCEDURE dessin_lign_pyr(No:integer;coulfond,coul1,coul2:byte;coeff,pop,
                             pop0:real;popM,popF:tab18;chxpyr:char);
   (*** appel dans la procdure dessine_pyr ***)
   (*** dessine une ligne de la pyramide ***)
     (* chxpyr : pyramide relle ou proportionnelle *)
     (* coul : couleur du dessin (var.loc.) *)
     (* coul1,coul2 : couleurs du dessin *)
     (* coulfond: couleur de fond *)
     (* coeff : coefficient pour dessin pyramide *)
     (* HEC : hauteur de l'cran en pixels (constante) *)
     (* HM : hauteur d'une marche de la pyramide (constante) *)
     (* LECGRA : largeur de la fentre graphique principale (constante) *)
     (* No : numro de la ligne  dessiner [1..18] *)
     (* pop : population totale courante *)
     (* pop0 : population totale initiale *)
     (* popF[i] : effectifs fminins courants *)
     (* popM[i] : effectifs masculins courants *)
     (* TXS : hauteur de la zone suprieure rserve pour du texte(constante)*)
     (* XOR1,XOR2,YOR : coordonnes pour dpart de la pyramide (constantes)*)
     (* X1,X2,Y1,Y2 : coordonnes pour construire un rectangle plein (loc.)*)
     var coul,X1,X2,Y1,Y2:integer;
     Begin
       coul:=coul1;X1:=0;X2:=0;Y1:=0;Y2:=0;
       if not _int_range(5,13,No) then coul:=coul2;
       if chxpyr='R' then popM[No]:=coeff*popM[No]/pop0
       else popM[No]:=coeff*popM[No]/pop;
       X1:=XOR1;
       Y1:=YOR-(No*HM);
       X2:=XOR1-round(popM[No]);
       Y2:=Y1+HM-1;
       setfillstyle(1,coul);
       bar(X2,Y1,X1,Y2);
       setfillstyle(1,coulfond);
       if No<14 then bar(4,Y1,X2,Y2) else bar(31,Y1,X2,Y2);
       if chxpyr='R' then popF[No]:=coeff*popF[No]/pop0
       else popF[No]:=coeff*popF[No]/pop;
       X1:=XOR2;
       Y1:=YOR-(No*HM);
       X2:=XOR2+round(popF[No]);
       Y2:=Y1+HM-1;
       setfillstyle(1,coul);
       bar(X1,Y1,X2,Y2);
       setfillstyle(1,coulfond);
       if No<14 then bar(LEC-5,Y1,X2,Y2) else bar(LEC-31,Y1,X2,Y2);
       setcolor(white);
       rectangle(3,HEC-TXI,LEC-4,TXS+17);
       if chxpyr='R' then
       begin
         popM[No]:=popM[No]*pop0/coeff;
         popF[No]:=popF[No]*pop0/coeff
       end
       else
       begin
         popM[No]:=popM[No]*pop/coeff;
         popF[No]:=popF[No]*pop/coeff
       end
    End;

   PROCEDURE calcul_et_affich(coulplan,coulfond:byte;naiss,pop,txaccr,esp,
                              naissred:real;popM,popF:tab18;
                              var JE,VI,txmort,txnat,txfecond:real);
   (*** appel dans la procdure dessine_pyr ***)
   (*** calcule et affiche les variables au fur et  mesure de la ***)
   (*** projection ***)
     (* coulfond,coulplan : couleurs de fonds et de premier plan *)
     (* esp : esprance de vie courante *)
     (* JE : proportion de la population < 20 ans  *)
     (* naiss : nombre de naissances(en 5 ans)pour priode courante *)
     (* naissred : SNR courante *)
     (* PFR : population fminine (var.loc.) *)
     (* pop : population totale courante *)
     (* popF : effectifs fminins courants *)
     (* popM : effectifs masculins courants *)
     (* txaccr : taux d'accroissement annuel courant *)
     (* txnat : taux de natalit *)
     (* txmort : taux de mortalit *)
     (* txfecond : taux global de fcondit *)
     (* VI : proportion de la population > 65 ans *)
     var PFR:real;
         i:byte; (* compteur *)
     Begin
       (* rpartition par groupe d'ge *)
       JE:=0;VI:=0;
       for i:=1 to 4 do JE:=JE+popM[i]+popF[i];
       JE:=JE/pop;
       if (JE < 0.001) then JE:=0;
       for i:=14 to 18 do VI:=VI+popM[i]+popF[i];
       VI:=VI/pop;
       if (VI < 0.001) then VI:=0;
       (* taux natalit,mortalit,global fcondit *)
       txnat:=(naiss/pop)*200;
       PFR:=0;
       for i:=1 to 4 do PFR:=PFR+popF[i];
       if PFR<>0 then txfecond:=(naiss/PFR)*200;
       txmort:=txnat-1000*txaccr;
       (* affichage de ces valeurs *)
       _settempcolor(coulplan,coulfond,false);
       _go(1,24);
       write('Tx.acc.(%)=',100*txaccr:4:2,'  ','EV=',esp:4:1);
       _go(60,24);
       writeln('  ','SNR=',naissred:4:2);
       _go(1,25);
       write('<20a.(%):',100*JE:4:1,'  ','>65a.(%):',100*VI:4:1);
       _go(60,25);
       write('  ','TGF=',txfecond:4:1);
       _getoldcolor(false)
     End;

   PROCEDURE surimprime(popF0,popM0:tab18;coeff,pop,pop0:real;
                        coul1,coul2:byte);
   (*** appel dans le programme principal et dans la procdure pause ***)
     (* coeff : coefficient pour surimpression pyramide *)
     (* coul : couleur du trac (var.loc.) *)
     (* coul1,coul2 : couleurs de dessin *)
     (* pop : population totale courante *)
     (* pop0 : population totale initiale *)
     (* popF0 : effectifs fminins initiaux *)
     (* popM0 : effectifs masculins initiaux *)
     (* XOR1,XOR2,YOR : coordonnes dpart de la pyramide (constantes) *)
     var i,   (* compteur *)
         coul,XC1,XC2,X1,X2,Y1:integer;
         X01,X02:real;
     Begin
       i:=1;
       XC1:=XOR1;XC2:=XOR2;
       moveto(XOR1,YOR);
       Y1:=getY;
       while i<19 do
       begin
         if not _int_range(6,14,i) then coul:=coul1
         else coul:=coul2;
         X01:=popM0[i]*coeff/pop0;X02:=popF0[i]*coeff/pop0;
         X1:=round(X01);X2:=round(X02);
         X1:=XOR1-X1;
         setcolor(coul);
         line(XC1,Y1,X1,Y1);
          X2:=XOR2+X2;
         line(XC2,Y1,X2,Y1);
         if i=14 then coul:=coul1;
         if i=5 then coul:=coul2;
         setcolor(coul);
         line(X1,Y1-1,X1,Y1-7);
         line(X2,Y1-1,X2,Y1-7);
         XC1:=X1;XC2:=X2;
         Y1:=Y1-7;
         i:=i+1
       end
     End;

   PROCEDURE modif_param(var modifopt:mode;
                         var dureeproj:integer;
                         var chxpyr:char;
                         var pop,redn:real;
                         var popM,popF:tab18);
   (*** appel dans la procdure pause ***)
   (*** permet de modifier certains paramtres pendant la projection ***)
     (* car : caractre lu au clavier (var.loc.) *)
     (* chxpyr : type de pyramide choisi (relle ou proportionnelle) *)
     (* detect : indicateur d'erreur ventuelle au cours des choix *)
     (* dureeproj : dure de la projection *)
     (* E : entier lu au clavier (var.loc.) *)
     (* modifopt : indicateur de choix de l'option crise dmographique *)
     (* pop : population totale courante *)
     (* popF : effectifs fminins courants *)
     (* popM : effectifs masculins courants *)
     (* redn : rduction (%) de la natalit *)
     (* RM : rduction (%) de la population masculine 20-39ans par crise(loc.) *)
     (* RP : rduction (%) des autres groupes (masculins ou fminins) (loc.) *)
     var i, (* compteur *)
         E:integer;
         RM,RP:real;
         detect:integer;
         car:char;
     Begin
       _curseurvisibl;
       RM:=0;RP:=0;redn:=0;modifopt:=0;
       for i:=1 to 5 do _horizontal(1,i,80,0);
       _go(1,2);
       writeln('OPTION : - CRISE DEMOGRAPHIQUE (C) ');
       writeln('         - MODIF. DUREE PROJECTION (D) ');
       writeln('         - MODIF. TYPE PYRAMIDE (P) ');
       write('Votre choix : ');
       car:=_readkey;
       if (car='c') or (car='d') or (car='p') then car:=upcase(car);
       for i:=1 to 5 do _horizontal(1,i,80,0);
       detect:=0;
       (* option crise dmographique *)
       if car='C' then
       begin
         _ecrit(1,1,'CRISE DE MORTALITE ');
         REPEAT
         _ecrit(1,2,'- DIMIN.POPUL.MASCUL.20-39ANS(%) :');
         LIREEL(RM,false,detect,1,15,0,100);
         if detect=1 then _horizontal(1,2,80,0);
         UNTIL detect<>1;
         RM:=RM/100;
         detect:=0;
         REPEAT
         _ecrit(1,3,'- DIMIN. AUTRES GROUPES (%) :');
         LIREEL(RP,false,detect,1,17,0,100);
         if detect=1 then _horizontal(1,3,80,0);
         UNTIL detect<>1;
         RP:=RP/100;
         detect:=0;
         REPEAT
         _ecrit(1,4,'CRISE DE NATALITE:DIMIN.NATALITE (%):');
         LIREEL(redn,false,detect,1,19,0,100);
         if detect=1 then _horizontal(1,4,80,0);
         UNTIL detect<>1;
         redn:=redn/100;
         pop:=0;
         for i:=1 to 18 do
         begin
           popF[i]:=(1-RP)*popF[i];
           pop:=pop+popF[i]
         end;
         for i:=1 to 4 do
         begin
           popM[i]:=(1-RP)*popM[i];
           pop:=pop+popM[i]
         end;
         for i:=5 to 8 do
         begin
           popM[i]:=(1-RM)*popM[i];
           pop:=pop+popM[i]
         end;
         for i:=9 to 18 do
         begin
           popM[i]:=(1-RP)*popM[i];
           pop:=pop+popM[i]
         end;
         modifopt:=1
       end;
       (* option modif. dure de projection *)
       if car='D' then
       begin
         _ecrit(3,2,'MODIF. DE LA DUREE DE PROJECTION');
         REPEAT
         _ecrit(1,4,'Nouvelle dure totale de project.: ');
         LIRENTIER(E,detect,1,4);
         UNTIL detect<>1;
         if E<>0 then dureeproj:=E
       end;
       (* option modif. pyramide *)
       if car='P' then
       begin
         _ecrit(3,2,'MODIFICATION DU TYPE DE LA PYRAMIDE');
         REPEAT
         _ecrit(1,4,'Pyr. relle (R) ou proport. (P) : ');
         LIRECAR(chxpyr,detect,70,1,4,'R','P');
         UNTIL detect<>1
       end;
       _curseurinvis;
       for i:=1 to 5 do _horizontal(1,i,80,0)
     End;

   PROCEDURE pause(popF0,popM0:tab18;coeff,pop0:real;coul1,coul2:byte;
                   var modifopt,copy:mode;
                   var dureeproj:integer;
                   var popF,popM:tab18;var chxpyr:char;var pop,redn:real);
   (*** appel dans la procdure dessine_pyr ***)
   (*** permet  l'utilisateur d'interrompre le programme au cours de la ***)
   (*** projection, de demander la surimpression de la pyramide initiale ***)
   (*** de modifier les paramtres, de quitter le programme ***)
     (* car : caractre lu au clavier (var.loc.) *)
     (* bool : rsultat des questions dont les rponses sont <O> ou <N> (loc.)*)
     (* chxpyr : type de pyramide choisi (relle ou proportionnelle) *)
     (* coeff : coefficient pour surimpression pyramide initiale *)
     (* copy : indicateur de copie d'cran *)
     (* coul1,coul2 : couleurs de dessin pour surimpression *)
     (* dureeproj : dure de la projection *)
     (* modifopt : indicateur de choix de l'option crise dmographique *)
     (* pop : population totale courante *)
     (* pop0 : population totale initiale *)
     (* popF : effectifs fminins courants *)
     (* popF0 : effectifs fminins initiaux *)
     (* popM : effectifs masculins courants *)
     (* popM0 : effectifs masculins initiaux *)
     (* redn : rduction (%) de la natalit *)
     (* surimp : indicateur de demande surimpression pyramide initiale(loc.)*)
     var car:char;
         bool:boolean;
         surimp:mode;
     Begin
       bool:=false;surimp:=0;
       if not keypressed then exit;
       car:=readkey;
       window(1,1,80,6);
       _horizontal(1,1,80,0);
       bool:=_reponsparON(10,1,white,'on continue (O/N) ? ',false, false);
       if bool then exit;
       bool:=_reponsparON(1,1,white,'pyr. init. en surimpression (O/N) : ',
         false,false);
       if bool then
       begin
         surimprime(popF0,popM0,coeff,pop,pop0,coul1,coul2);
         surimp:=1
       end;
       bool:=_reponsparON(10,1,white,'copie d''cran (O/N) : ',false,false);
       if bool then copy:=1;(* copie cran *)
       bool:=_reponsparON(1,1,white,'on modifie les paramtres (O/N) : ',false,false);
       if bool then
       begin
         MODIF_PARAM(modifopt,dureeproj,chxpyr,pop,redn,popM,popF);
         if surimp=1 then
         begin
           surimprime(popF0,popM0,coeff,pop,pop0,coul2,coul1);
           surimp:=0
         end;
         exit;
       end;
       bool:=_reponsparON(10,1,white,'on termine (O/N) : ',false,false);
       if bool then
       begin
         close(fich1);
         closegraph;
         textmode(3);
         halt;
       end;
       if surimp=1 then
       begin
         surimprime(popF0,popM0,coeff,pop,pop0,coul2,coul1);
         surimp:=0
       end
     End;

   PROCEDURE enregistrer(numero:byte;chxmort,chxobj:char;
                         depAn,dureemort,dureeobj,nbreAn:integer;
                         espF0,espM0,JE,naissred,pop,txaccr,txfecond,txnat,
                         txmort,VI:real;
                         popF,popM:tab18);
   (*** appel dans la procdure dessine_pyr ***)
   (*** enregistre les rsultats dans le fichier 'fichout.dat' qui est ***)
   (*** cras  chaque nouvelle projection ***)
     (* chxmort : type de mortalit choisi (constante ou variable) *)
     (* chxobj : objectif choisi (fcondit ou taux d'accroissement) *)
     (* depAn : anne de dpart *)
     (* dureemort : dure de la transition(annes) vers mortalit finale *)
     (* dureeobj : dure de la transition(annes) vers objectif *)
     (* espF0 : esprance de vie initiale pour les femmes *)
     (* espM0 : esprance de vie initiale pour les hommes *)
     (* fich2 : variable fichier texte en criture (var.loc.) *)
     (* JE : proportion de la population < 20 ans  *)
     (* naissred : valeur courante de la SNR *)
     (* nbreAn : valeur courante du nombre d'annes depuis dbut projection *)
     (* numero : numro du pays choisi par l'utilisateur *)
     (* PFEM : population totale fminine courante (var.loc.) *)
     (* PMASC : population totale masculine courante (var.loc.) *)
     (* pop : population totale courante *)
     (* popF[i] : effectif fminin courant pour la tranche d'ge i *)
     (* popM[i] : effectif masculin courant pour la tranche d'ge i *)
     (* txaccr : taux d'accroissement annuel courant *)
     (* txnat : taux de natalit *)
     (* txmort : taux de mortalit *)
     (* txfecond : taux global de fcondit *)
     (* VI : proportion de la population > 65 ans *)
     var fich2:text;
         i:integer; (* compteur *)
         PMASC,PFEM:real;
         chOBJ,chMOR,M1,M2:string;
         chAGE:array[1..18]of string;
     Begin
       assign(fich2,'fichout.dat');
       rewrite(fich2);
       writeln(fich2,'');writeln(fich2,'');
       writeln(fich2,'pays : ',copy(PAYS[numero],2,43));
       writeln(fich2,'');
       if chxobj='F' then chOBJ:='SNR';
       if chxobj='T' then chOBJ:='TX ACC.';
       if chxmort='C' then chMOR:='CSTE';
       if chxmort='V' then chMOR:='VAR.';
       writeln(fich2,'OPTIONS : ',chOBJ,' CONSTANT APRES ',dureeobj,'ANNEES.');
       if chxmort='C' then
       writeln(fich2,'          MORTALITE ',chMOR);
       if chxmort='V' then
       writeln(fich2,'          MORTALITE ',chMOR,' CONSTANTE APRES ',
               dureemort,'ANNEES.');
       writeln(fich2,'');
       for i:=1 to 80 do write(fich2,'-');
       PMASC:=0;PFEM:=0;
       for i:=1 to 3 do writeln(fich2,'');
       writeln(fich2,'PERIODE :',depAn+nbreAn,'-',depAn+nbreAn+4);
       for i:=1 to 28 do write(fich2,'-');
       writeln(fich2,'');
       writeln(fich2,'AGE          HOMMES              FEMMES');
       writeln(fich2,'');
       for i:=1 to 18 do
       begin
         PMASC:=PMASC+popM[i];
         PFEM:=PFEM+popF[i];
         str(5*(i-1),M1);str(5*(i-1)+4,M2);
         chAGE[i]:=M1+'-'+M2
       end;
       chAGE[18]:='85 et +';
       for i:=1 to 18 do
       begin
         write(fich2,chAGE[i]);
         write(fich2,'         ');
         write(fich2,popM[i]:8:0);
         write(fich2,'         ');
         writeln(fich2,popF[i]:8:0)
       end;
       write(fich2,' TOTAL : ','           ',PMASC:8:0);
       writeln(fich2,'          ',PFEM:8:0);
       writeln(fich2,'');
       writeln(fich2,'POPULATION TOTALE :',pop:8:0);
       write(fich2,'% < 20 ans : ',100*JE:3:1);
       writeln(fich2,'        ','% > 65 ans : ',100*VI:3:1);
       write(fich2,'ESP. VIE M : ',espM0:3:1);
       writeln(fich2,'        ','ESP. VIE F : ',espF0:3:1);
       writeln(fich2,'');
       writeln(fich2,'TX BRUT MORTALITE : ',txmort:3:1);
       writeln(fich2,'TX BRUT NATALITE : ',txnat:3:1);
       writeln(fich2,'TX D''ACCROISSEMENT : ',100*txaccr:3:1);
       writeln(fich2,'TX GLOBAL DE FECONDITE : ',txfecond:4:1);
       writeln(fich2,'SOMME DES NAISSANCES REDUITES : ',naissred:4:2);
       close(fich2)
     End;

   PROCEDURE projection(dureemort,dureeobj:integer;
                        espfin,fecond0,fecondfin,redn:real;
                        tauxfec:tab10;
                        chxmort,chxobj:char;
                        var modifopt:mode;
                        var nbrAn:integer;
                        var popF,popM,quotF,quotM:tab18;
                        var esp,esp0,pop,naiss,naissred,txaccr,txaccr0,txfin:real);
   (*** appel dans la procdure dessine_pyr ***)
   (*** effectue une projection dmographique en fonction des options ***)
   (*** choisies par l'utilisateur ***)
     (* chxmort : type de mortalit choisi (constante ou variable) *)
     (* chxobj : objectif choisi (fcondit ou taux d'accroissement) *)
     (* dureemort : dure de la transition(annes) vers mortalit finale *)
     (* dureeobj : dure de la transition(annes) vers objectif *)
     (* esp : esprance de vie courante*)
     (* espfin : objectif pour l'esprance de vie *)
     (* fecond0 : valeur initiale de la SNR *)
     (* fecondfin : objectif pour la fcondit *)
     (* modifopt : indicateur de choix de l'option crise dmographique *)
     (* naiss : nombre de naissances(en 5 ans)pour priode courante *)
     (* naissred : valeur courante de la SNR *)
     (* nbrAn : valeur courante du nombre d'annes depuis dbut projection *)
     (* pop : population totale courante *)
     (* popF[i] : effectif fminin courant pour la tranche d'ge i *)
     (* popM[i] : effectif masculin courant pour la tranche d'ge i *)
     (* quotF : quotients perspectifs mortalit fminins courants *)
     (* quotM : quotients perspectifs mortalit masculins courants *)
     (* redn : rduction (%) de la natalit *)
     (* tauxfec : taux de fcondit initiaux *)
     (* txaccr : taux d'accroissement annuel courant *)
     (* txaccr0 : taux d'accroissement annuel initial *)
     (* txfin : objectif pour le taux d'accroissement *)
     var i:integer; (* compteur *)
         KF,NF,NM,NS,PA,Q1,S1,TAC5,TT,TC:real;
         AF,AM:tab18;
     Begin
       nbrAn:=nbrAn+5;
       PA:=pop;pop:=0;
       for i:=1 to 18 do
       begin
         AF[i]:=popF[i];
         AM[i]:=popM[i]
       end;
       if chxmort='V' then
       (* projection par esprance de vie finale donne *)
       begin
       if (nbrAn<=dureemort) then
       begin
         esp:=esp0+(espfin-esp0)*(nbrAn/dureemort);
         CALCUL_QUOT_MORT(esp,quotF,quotM)
       end
       end;
       for i:=2 to 18 do
       begin
         popF[i]:=AF[i-1]*(1000-quotF[i])/1000;
         popM[i]:=AM[i-1]*(1000-quotM[i])/1000;
         pop:=pop+popM[i]+popF[i];
       end;
       naiss:=0;
       if chxobj='T' then
       (* projection par taux d'accroissement donn *)
       begin
         TT:=txaccr0;TC:=txfin/100;
         if nbrAn<dureeobj then TC:=TT+((txfin/100)-TT)*(nbrAn/dureeobj);
         TAC5:=exp(5*ln(1+TC))-1;
         Q1:=(quotM[1]+quotF[1])/2;
         S1:=(1000-Q1)/1000;
         naiss:=((2+TAC5)*PA-(2-TAC5)*pop)/((2-TAC5)*S1);
         naissred:=0;NS:=0;
         for i:=4 to 9 do NS:=NS+5*tauxfec[i]*(popF[i]/1000);
         if NS<>0 then naissred:=fecond0*naiss/NS
       end;
       if OBJ='F' then
       (* projection par taux de fcondit donn *)
       begin
         KF:=fecondfin/fecond0;
         if (nbrAn< dureeobj) then KF:=1+((fecondfin-fecond0)/fecond0)*
                                       (nbrAn/dureeobj);
         naissred:=0;
         for i:=4 to 9 do
         begin
           naissred:=naissred+5*KF*tauxfec[i]/1000;
           naiss:=naiss+(KF*tauxfec[i]*5*(popF[i]+AF[i]))/2000
         end;
       end;
       (* suite commune *)
       if modifopt=1 then
       begin
         naiss:=(1-redn)*naiss;
         naissred:=(1-redn)*naissred;
         modifopt:=0
       end;
       NF:=0.488*naiss;
       NM:=0.5120001*naiss;
       popF[1]:=NF*(1000-quotF[1])/1000;
       popM[1]:=NM*(1000-quotM[1])/1000;
       pop:=pop+popF[1]+popM[1];
       TAC5:=(pop-PA)/PA;
       txaccr:=(exp(0.2*ln(1+TAC5)))-1
     End;

   PROCEDURE dessine_pyr(chxmort,chxobj:char;
                         depAn,dureemort,dureeobj:integer;
                         coeff,espF0,espM0,fecond0,espfin,taux,txaccr0,
                         pop0:real;
                         popM0,popF0:tab18;
                         numero,coulfond,coul1,coul2:byte;
                         var fecond,txaccr,esp,naiss,naissred,pop:real;
                         var chxpyr:char;var dureeproj,nbreAn:integer;
                         var popM,popF:tab18);
   (*** appel dans le programme principal ***)
   (*** procdure principale du programme ***)
     (* coeff : coefficient pour dessin pyramide *)
     (* chxmort : mortalit choisie (constante ou variable) *)
     (* chxobj : type d'objectif choisi (fcondit ou taux accr. constant) *)
     (* chxpyr : type de pyramide choisi (relle ou proportionnelle) *)
     (* coul1,coul2 : couleurs dessin pyramide *)
     (* coulfond : couleur de fond *)
     (* depAn : anne de dpart *)
     (* dureemort : dure de la transition(annes) vers mortalit finale *)
     (* dureeobj : dure de la transition(annes) vers objectif *)
     (* dureeproj : dure de la projection *)
     (* esp : esprance de vie courante*)
     (* espF0 : esprance de vie initiale pour les femmes *)
     (* espM0 : esprance de vie initiale pour les hommes *)
     (* espfin : objectif pour l'esprance de vie *)
     (* fecond : objectif de fcondit  (SNR) *)
     (* fecond0 : valeur initiale de la SNR *)
     (* naiss : nombre de naissances(en 5 ans)pour priode courante *)
     (* naissred : valeur courante de la SNR *)
     (* nbreAn : valeur courante de nbre d'annes depuis dbut projection *)
     (* numero : numro du pays choisi par l'utilisateur *)
     (* OP : indicateur de choix de l'option crise dmographique *)
     (* PAYS : tableau d'enregistrement des noms de pays *)
     (* PJ : proportion de la population < 20 ans *)
     (* pop : population totale courante *)
     (* pop0 : population totale initiale *)
     (* popF[i] : effectif fminin courant pour la tranche d'ge i *)
     (* popF0[i] : effectif fminin initial pour la tranche d'ge i *)
     (* popM[i] : effectif masculin courant pour la tranche d'ge i *)
     (* popM0[i] : effectif masculin initial pour la tranche d'ge i *)
     (* PV : proportion de la population > 65 ans *)
     (* RN : rduction (%) de la natalit *)
     (* TBM : taux de mortalit *)
     (* TBN : taux de natalit *)
     (* TGF : taux global de fcondit *)
     (* taux : taux d'accroissement fix comme objectif *)
     (* txaccr : taux d'accroissement annuel courant *)
     (* txaccr0 : taux d'accroissement annuel initial *)
     var i:integer;
         PJ,R1,R2,RN,TGF,TBN,TBM,PV,esp0:real;
         OP:mode;
         chOBJ,chMOR,chPY:string;
     Begin
       esp0:=(espF0+espM0)/2;
       window(1,1,80,6);
       _ecrit(1,1,'APPUYEZ SUR UNE TOUCHE POUR INTERROMPRE');
       _settempcolor(lightgreen,coulfond,false);
       _go(1,3);
       writeln(' Pays : ',copy(PAYS[numero],2,25),' (',depAn,')');
       if chxobj='F' then
       begin
         chOBJ:='Fcond.(SNR)=';
         R:=fecond
       end;
       if chxobj='T' then
       begin
         chOBJ:='Tx.accr.(%)=';
         R:=taux
       end;
       if chxmort='V' then chMOR:='Var.';
       if chxmort='C' then chMOR:='Const.';
       if chxpyr='R' then chPY:='Relle';
       if chxpyr='P' then chPY:='Propor.';
       writeln('Objectif : ',chOBJ,R:4:2,' en ',dureeobj,' ans ');
       writeln('Mortalit : ',chMOR,'   ','Pyramide : ',chPY);
       window(1,23,80,25);
       _go(1,1);
       writeln('Anne : ',depAn+nbreAn,'    ','Population : ',pop:8:0);
       _getoldcolor(false);
       for i:=1 to 18 do DESSIN_LIGN_PYR(i,coulfond,coul1,coul2,coeff,pop,
                                         pop0,popM,popF,chxpyr);
       CALCUL_ET_AFFICH(lightgreen,coulfond,naiss,pop,txaccr,esp,naissred,popM,
                        popF,PJ,PV,TBM,TBN,TGF);
       PAUSE(popF0,popM0,coeff,pop0,coul1,coul2,OP,REP,dureeproj,popF,popM,
             chxpyr,pop,RN);
       ENREGISTRER(numero,chxmort,chxobj,depAn,dureemort,dureeobj,nbreAn,
                   espF0,espM0,PJ,naissred,pop,txaccr,TGF,TBN,TBM,PV,popF,
                   popM);
       PROJECTION(dureemort,dureeobj,espfin,fecond0,fecond,RN,TF,chxmort,
                  chxobj,OP,nbreAn,popF,popM,QF,QM,esp,esp0,pop,naiss,naissred,
                  txaccr,txaccr0,taux)
     End;


(***************************************************************************)
(***********************  PROGRAMME  PRINCIPAL  ****************************)
(***************************************************************************)


BEGIN

(************************* CHOIX DES OPTIONS *******************************)

(* PREMIER ECRAN *)

textmode(3);
_settempcolor(lightgreen,lightblue,true);
_horizontal(18,2,13,42);
_ecrit(32,2,'PYRAMIDES ANIMEES');
_horizontal(50,2,13,42);
_ecrit(21,5,'Programme de projections dmographiques');
_horizontal(18,8,10,42);
_ecrit(28,8,'( H.Leridon, INED, 08-93 )');
_horizontal(54,8,9,42);
_vertical(18,3,5,174);
_vertical(62,3,5,175);
_ecrit(10,12,'Ce programme permet de projeter la population de n''importe');
_ecrit(10,13,'quel pays du monde (sans migrations), en choisissant un ');
_ecrit(10,14,'objectif en termes de taux d''accroissement ou de fcondit');
_ecrit(10,15,'(SNR), et une volution de la mortalit.');
_ecrit(32,20,'CHOIX DES OPTIONS');
_attends_touche;
_getoldcolor(true);


(* CHOIX DU PAYS : DEUXIEME ECRAN *)
REPEAT
 clrscr;
 textmode(3);

LECTURE_LISTE('codonufr.dat',PAYS);
SELECTION(black,cyan,yellow,num);

(* AUTRES OPTIONS : TROISIEME ECRAN *)

(* lecture des donnes *)
LECTURE(num,AD,CF,EV,EV0,EVF0,EVM0,F0,NA,PT,PT0,SNR,TAC,TAC0,PF,PF0,PM,PM0,
        QF,QM,TF);

(* choix des options *)
MENU_OPTIONS(num,AD,PT0,TAC0,F0,EV0);
_curseurvisibl;

REPEAT (* dure de la projection *)
_ecrit(1,11,'- DUREE DE LA PROJECTION (en annes - 50 ans par dfaut -) : ');
LIRENTIER(E,indic,1,11);
UNTIL indic<>1;
if (E<>0) then DU:=E
else DU:=50;

REPEAT (* mortalit constante ou variable *)
_ecrit(1,14,'- MORTALITE CONSTANTE (C) OU VARIABLE (V) - C par dfaut - : ');
LIRECAR(MOR,indic,1,70,14,'V','C')
UNTIL indic<>1;
IF MOR='V' THEN (* option mortalit variable *)
begin
  REPEAT
  _ecrit(3,15,'- ESPERANCE DE VIE FINALE ([20..99]) : ');
  LIREEL(EVFIN,true,indic,3,15,20,99)
  UNTIL indic<>1;
  REPEAT
  _ecrit(3,16,'- DUREE DE TRANSITION (en annes -25 ans par dfaut-) : ');
  LIRENTIER(E,indic,3,16);
  if not _int_range(0,DU,E) then
  begin
    indic:=1;
    ERREUR(3,16)
  end;
  UNTIL indic<>1;
  if E<>0 then DTMOR:=E
  else DTMOR:=25
end;

REPEAT (* objectif=fcondit ou taux d'accroissement constant *)
_ecrit(1,19,'- OBJECTIF=FECONDITE (F) OU TAUX D''ACCROISSEMENT CONSTANT (T) : ');
LIRECAR(OBJ,indic,1,70,19,'T','F')
UNTIL indic<>1;
IF OBJ='F' THEN (* option fcondit *)
begin
  repeat
  _ecrit(3,20,'- FECONDITE FINALE (SNR=nombre d''enfants par femme [0..10]): ');
  LIREEL(R,true,indic,3,20,0,10)
  until indic<>1;
  if R<>0 then F:=R
  else F:=0.0001
end;
IF OBJ='T' THEN (* option taux d'accroissement constant *)
begin
  repeat
  _ecrit(3,20,'- TAUX D''ACCROISSEMENT (en % [-2..4]): ');
  LIREEL(R,true,indic,3,20,(-2),4)
  until indic<>1;
  TA:=R
end;
REPEAT (* dure de transition *)
_ecrit(3,21,'- DUREE DE TRANSITION (en annes - 20 ans par dfaut -) : ');
LIRENTIER(E,indic,3,21);
if not _int_range(0,DU,E) then
begin
  indic:=1;
  ERREUR(3,21)
end;
UNTIL indic<>1;
if E<>0 then DTOBJ:=E
else DTOBJ:=20;

REPEAT (* pyramide relle ou proportionnelle *)
_ecrit(1,24,'- PYRAMIDE REELLE (R) OU PROPORTIONNELLE (P) - P par dfaut - : ');
LIRECAR(PY,indic,1,70,24,'R','P')
UNTIL indic<>1;


(********************** FIN DU CHOIX DES OPTIONS ***************************)
(*************************** ECRAN  D'ATTENTE ******************************)


_curseurinvis;
_settempcolor(lightgreen,lightblue,true);
_lignvides(3);
_ecrit(23,4,' ******  O.K. ON Y VA ... ****** ');
_lignvides(2);
_ecrit(19,7,' POUR INTERROMPRE,FRAPPER SUR UNE TOUCHE ');
delay(3000);
_getoldcolor(true);

(************************** CORPS DU PROGRAMME *****************************)

(* INITIALISATION DU MODE GRAPHIQUE ET DEFINITION DE LA FENETRE GRAPHIQUE *)

graphdriver:=CGA;graphmode:=3;
initgraph(graphdriver,graphmode,'');
if graphresult<>grok then halt(1);
directvideo:=false;

setviewport(3,HEC-TXI,LEC-4,TXS+20,clipon);
rectangle(3,HEC-TXI,LEC-4,TXS+17); (* contours fenetre graphique *)
setlinestyle(0,1,1);
rectangle(10,50,30,66);
moveto(15,53);lineto(15,63);
moveto(25,53);lineto(25,63);
moveto(16,59);lineto(24,59);
rectangle(290,50,310,66);
moveto(295,53);lineto(295,63);
moveto(296,53);lineto(305,53);
moveto(296,59);lineto(301,59);
moveto(XOR1,YOR);

(**************************** CORPS DU PROGRAMME ***************************)
(******************* DESSIN PYRAMIDE ET PROJECTION A 5 ANS *****************)

N:=0;FIN:=0;bool:=false;surimp:=0;
REPEAT
while (N<=DU) and (FIN=0) do DESSINE_PYR(MOR,OBJ,AD,DTMOR,DTOBJ,CF,EVF0,EVM0,
                                         F0,EVFIN,TA,TAC0,PT0,PM0,PF0,num,
                                         black,blue,yellow,F,TAC,EV,NA,SNR,PT,
                                         PY,DU,N,PM,PF);
window(1,1,80,5);
_horizontal(1,1,80,0);
bool:=_reponsparON(1,1,white,'pyr. init. en surimpression (O/N) ? ',false,false);
if bool then
begin
  surimprime(PF0,PM0,CF,PT,PT0,blue,yellow);
  surimp:=1
end;
bool:=_reponsparON(5,1,white,'dure supplmentaire (O/N) ? ',false,false);
if bool then
begin
  REPEAT
  _ecrit(5,1,'dure supplmentaire : ');
  LIRENTIER(DV,indic,5,1)
  UNTIL indic<>1;
  DU:=DU+DV;
  if surimp=1 then surimprime(PF0,PM0,CF,PT,PT0,yellow,blue);
end;
UNTIL N>DU;

(************************ FIN DE PROJECTION ********************************)

_clean(1,1,80);
bool:=_reponsparON(5,1,white,'impression des rsultats (O/N) ? ',false,false);
if bool then REP:=1; (*copy fichout.dat*)
bool:=_reponsparON(5,1,white,'une autre projection (O/N) ? ',false,false);
if not bool then
begin
  FIN:=1;
  close(fich1);
  closegraph;
  textmode(3);
  halt;
end;

UNTIL FIN=1;

END.
