{**************************************************************}
{********** B G I L I N K                          *** (TP) ***}
{**************************************************************}
{ Copyright (c) 1985, 1990 by Borland International, Inc. }

PROGRAM BGILink;
{ Ce programme illustre la mthode  employer pour intgrer des pilotes et 
  des polices de caractres graphiques dans le code excutable. 
  Ces lments (pilotes et polices) sont livrs individuellement sous 
  forme de fichiers BGI; ils sont donc chargs suivant besoin pendant 
  le droulement d'un programme graphique. Il est cependant prfrable, 
  dans certains cas, de pouvoir placer tous les fichiers auxiliaires d'un 
  programme directement dans le fichier excutable de celui-ci. 
  Ce programme, en relation avec son fichier make (BGILINK.MAK) et les 
  deux units BGIDRIV.PAS et BGIFONT.PAS, intgre (  titre d'illustration)
  tous les pilotes et toutes les polices dans le code excutable BGILINK.EXE.

  Ayez les programmes suivants dans le rpertoire courant, ou 
  rendez-les accessibles via une spcification de chemin d'accs (PATH), 
  ils sont fournis sur la disquette II :

    MAKE.EXE     - Utilitaire MAKE pour construire BGILINK.EXE
    BINOBJ.EXE   - Utilitaire de conversion de fichier binaire vers .OBJ.

  Ayez les fichiers suivants dans le rpertoire courant, ils sont fournis sur 
  la disquette III :

    BGILINK.PAS  - Ce fichier source
    BGIDRIV.PAS  - Unit Pascal rassemblant tous les pilotes BGI
    BGIFONT.PAS  - Unit Pascal rassemblant toutes les polices BGI
    *.CHR        - Fichiers de polices BGI
    *.BGI        - Fichiers de pilotes BGI
    BGILINK.MAK  - Fichier make spcifiant la construction de 
                   BGIDRIV.TPU, FONT.TPU, puis BGILINK.EXE

  INDICATIONS :
  1. Lancez MAKE avec BGILINK.MAK ainsi :

       make -fbgilink.mak

     MAKE fait d'abord appel  BINOBJ.EXE pour crer les fichiers objet .OBJ 
      partir des fichiers des pilotes graphiques (*.BGI), puis appelle
     Turbo Pascal afin de compiler BGIDRIV.PAS. Ensuite, il procde de mme 
      partir de ceux des polices (*.CHR) et en compilant BGIFONT.PAS. 
     Finalement, BGILINK.PAS est compil (il rfrence BGIDRIV.TPU et 
     BGIFONT.TPU).

  2. Lancez l'excution de BGILINK.EXE. Il contient tous les pilotes et polices,
     et pourra donc fonctionner sur tous systmes supports par l'unit GRAPH 
     (CGA, EGA, EGA 64 Ko, EGA monochrome, Hercules monochrome, VGA, MCGA, 
     IBM 3270 PC et AT&T 6400/Olivetti).

  EXPLICATIONS :

    BGILINK.PAS rfrence BGIDRIV.TPU et BGIFONT.TPU dans sa clause USES :

      USES BGIDriv, BGIFont;

    Plus loin, il enregistre (Registers) TOUS les pilotes puis TOUTES les 
    polices. Il termine en effectuant quelques oprations graphiques pour 
    contrle.

    Vous pouvez aisment adapter BGILINK.PAS  vos besoins en dsactivant 
    (plaant en commentaires) les appels  RegisterBGIdriver et RegisterBGIfont
    inutiles  votre programme.

    Pour une explication dtaille de la prise en compte et du lien avec les 
    pilotes et fontes, consultez la description de RegisterBGIdriver et 
    RegisterBGIfont contenue dans le fichier GRAPH.DOC.
}

USES Graph,   { Bibliothque de routines graphiques }
     BGIDriv, { Tous les pilotes BGI }
     BGIFont; { Toutes les polices BGI }
VAR
  GraphDriver, GraphMode, Error : INTEGER;

PROCEDURE Abort(Msg : STRING);
BEGIN
  Writeln(Msg, ': ', GraphErrorMsg(GraphResult));
  Halt(1);
END;

BEGIN
  { Enregistrement des pilotes de priphrique graphiques. }
  IF RegisterBGIdriver(@CGADriverProc)    < 0 THEN
    Abort('CGA');
  IF RegisterBGIdriver(@EGAVGADriverProc) < 0 THEN
    Abort('EGA/VGA');
  IF RegisterBGIdriver(@HercDriverProc)   < 0 THEN
    Abort('Herc');
  IF RegisterBGIdriver(@ATTDriverProc)    < 0 THEN
    Abort('AT&T');
  IF RegisterBGIdriver(@PC3270DriverProc) < 0 THEN
    Abort('PC 3270');


  { Enregistrement des polices de caractres graphiques. }
  IF RegisterBGIfont(@GothicFontProc)    < 0 THEN
    Abort('Gothic');
  IF RegisterBGIfont(@SansSerifFontProc) < 0 THEN
    Abort('SansSerif');
  IF RegisterBGIfont(@SmallFontProc)     < 0 THEN
    Abort('Small');
  IF RegisterBGIfont(@TriplexFontProc)   < 0 THEN
    Abort('Triplex');

  GraphDriver := Detect;                  { Dtection auto de l'adaptateur }
  InitGraph(GraphDriver, GraphMode, '');  { Passage en mode graphique }
  IF GraphResult <> grOk THEN             { Test d'erreur ? }
  BEGIN
    Writeln('Erreur graphique initiale : ', GraphErrorMsg(GraphDriver));
    Halt(1);
  END;

  MoveTo(5, 5);
  OutText('Les pilotes et polices sont ');
  MoveTo(5, 20);
  SetTextStyle(GothicFont, HorizDir, 4);
  OutText('intgrs ');
  SetTextStyle(SmallFont, HorizDir, 4);
  OutText('dans le ');
  SetTextStyle(TriplexFont, HorizDir, 4);
  OutText('fichier ');
  SetTextStyle(SansSerifFont, HorizDir, 4);
  OutText('.EXE !');
  Rectangle(0, 0, GetX, GetY + TextHeight('.EXE !') + 1);
  Readln;
  CloseGraph;
END.

{********** FIN DE BGILINK.PAS                         *** (TP) ***}
