{**************************************************************}
{********** B G I D E M O                          *** (TP) ***}
{**************************************************************}
{ Copyright (c) 1985, 1990 by Borland International, Inc. }

PROGRAM BGIDemo;
(*                DEMONSTRATION DES CAPACITES DE L'UNITE GRAPH 
                         DE TURBO PASCAL                  
 Nouveaut intressante : Les accents franais sont grs.
 NOTE: Pour pouvoir utiliser le pilote IBM8514, il faut spcifier 
 la constante de directive conditionnelle "Use8514" (avec la directive
 {$DEFINE} ou l'option Options\Compiler\Conditional defines) avant de
 recompiler le programme. *)


USES
  Crt, Dos, Graph;

CONST
  { Les cinq polices de caractres graphiques disponibles }
  Fonts : ARRAY[0..4] OF STRING[13] =
  ('DefaultFont', 'TriplexFont', 'SmallFont', 'SansSerifFont', 'GothicFont');

  { Les cinq styles de trac prdfinis }
  LineStyles : ARRAY[0..4] OF STRING[9] =
    ('SolidLn', 'DottedLn', 'CenterLn', 'DashedLn', 'UserBitLn');

  { Les douze styles de remplissage de surface prdfinis }
  FillStyles : ARRAY[0..11] OF STRING[14] =
  ('EmptyFill',   'SolidFill',     'LineFill',  'LtSlashFill', 'SlashFill',
   'BkSlashFill', 'LtBkSlashFill', 'HatchFill', 'XHatchFill',
   'InterleaveFill', 'WideDotFill', 'CloseDotFill');

  { Les deux directions d'criture de texte }
  TextDirect : ARRAY[0..1] OF STRING[8] = ('HorizDir', 'VertDir');

  { Les justifications horizontales du texte }
  HorizJust  : ARRAY[0..2] OF STRING[10] =
    ('LeftText', 'CenterText', 'RightText');

  { Les justifications verticales du texte }
  VertJust   : array[0..2] of string[10] =
    ('BottomText', 'CenterText', 'TopText');

VAR
  GraphDriver : INTEGER;  { Numro du pilote graphique     }
  GraphMode   : INTEGER;  { Numro du mode graphique       }
  MaxX, MaxY  : WORD;     { Rsolution maximale de l'cran }
  ErrorCode   : INTEGER;  { Rcupration des erreurs graphiques     }
  MaxColor    : WORD;     { Plus grand numro de couleur accessible }
  OldExitProc : POINTER;  { Sauvegarde adresse de procdure de sortie }

{$F+}
PROCEDURE MyExitProc;
BEGIN
  ExitProc := OldExitProc; { Restaure adresse procdure de sortie }
  CloseGraph;              { Dsactive le systme graphique       }
END; { MyExitProc }
{$F-}

PROCEDURE Initialize;
{ Initialise le mode graphique et indique une erreur ventuelle }
VAR
  InGraphicsMode : BOOLEAN; { Indique le passage en mode graphique }
  PathToDriver   : STRING;  { Chemin d'accs DOS aux fichiers *.BGI & *.CHR }
BEGIN
  { Si utilisation de Crt et de graphiques, dsactive les critures 
    directes en mmoire de Crt }
  DirectVideo := False;
  OldExitProc := ExitProc;                { Sauve Proc de sortie prcdente }
  ExitProc    := @MyExitProc;             { Insrons notre procdure de sortie }
  PathToDriver := '';

  REPEAT
{$IFDEF Use8514}                          { Voir si $DEFINE Use8514 }
    GraphDriver := IBM8514;
    GraphMode := IBM8514Hi;
{$ELSE}
    GraphDriver := Detect;                { Sinon autodtection }
{$ENDIF}

  InitGraph(GraphDriver, GraphMode, PathToDriver);  { Dmarrage du systme graphique }
  ErrorCode := GraphResult;               { Erreur ? }
  IF ErrorCode <> grOk THEN
  BEGIN
    Writeln('Erreur graphique : ', GraphErrorMsg(ErrorCode));
      IF ErrorCode = grFileNotFound THEN { Ne trouve pas le fichier de pilote}
      BEGIN
        Writeln('Spcifiez le chemin d''accs au pilote ou <Ctrl-Break> pour sortir:');
        Readln(PathToDriver);
        Writeln;
      END
      ELSE
    Halt(1);   { Autre erreur : nous arrtons les frais }
  END;
  UNTIL ErrorCode = grOK;

  Randomize;                { Init gnrateur de nombres alatoire     }
  MaxColor := GetMaxColor;  { Rcup + grand numro de couleur de trac }
  MaxX := GetMaxX;          { Rcup coordonnes maxi }
  MaxY := GetMaxY;
END; { De Initialize }

FUNCTION Int2Str(L : LONGINT) : STRING;
{ Conversion d'un entier vers une chane pour OutText et OutTextXY }
VAR
  S : STRING;
BEGIN
  Str(L, S);
  Int2Str := S;
END; { Int2Str }

FUNCTION RandColor : WORD;
{ Renvoi d'une couleur alatoire valide suprieure  0, comprise dans
  l'intervalle de valeurs de couleurs pour le pilote et le mode graphique.
  Initialize attribue la valeur GetMaxColor  MaxColor. 
  }
BEGIN
  RandColor := Random(MaxColor)+1;
END; { RandColor }

PROCEDURE DefaultColors;
{ Positionne la dernire couleur de trac dans la palette }
BEGIN
  SetColor(MaxColor);
END; { DefaultColors }

PROCEDURE DrawBorder;
{ Trace une bordure autour de la fentre active }
VAR
  ViewPort : ViewPortType;
BEGIN
  DefaultColors;
  SetLineStyle(SolidLn, 0, NormWidth);
  GetViewSettings(ViewPort);
  WITH ViewPort DO
    Rectangle(0, 0, x2-x1, y2-y1);
END; { DrawBorder }

PROCEDURE FullPort;
{ Donne  la fentre active les dimnsions de l'cran complet }
BEGIN
  SetViewPort(0, 0, MaxX, MaxY, ClipOn);
END; { FullPort }

PROCEDURE MainWindow(Header : STRING);
{ Cration d'une fentre principale }
BEGIN
  DefaultColors;                           { Reset des couleurs }
  ClearDevice;                             { Efface l'cran     }
  SetTextStyle(DefaultFont, HorizDir, 1);  { Police par dfaut  }
  SetTextJustify(CenterText, TopText);     { Justifie  gauche }
  FullPort;                                { Ecran total        }
  OutTextXY(MaxX DIV 2, 2, Header);        { Affichage du titre }
  { Trace fentre }
  SetViewPort(0, TextHeight('M')+4, MaxX, MaxY-(TextHeight('M')+4), ClipOn);
  DrawBorder;                              { Trac de bordure }
  { Ecarte les bords de 1 pixel afin qu'ils soient hors de la fentre }
  SetViewPort(1, TextHeight('M')+5, MaxX-1, MaxY-(TextHeight('M')+5), ClipOn);
END; { MainWindow }

PROCEDURE StatusLine(Msg : STRING);
{ Affiche une ligne d'tat en bas d'cran }
BEGIN
  FullPort;
  DefaultColors;
  SetTextStyle(DefaultFont, HorizDir, 1);
  SetTextJustify(CenterText, TopText);
  SetLineStyle(SolidLn, 0, NormWidth);
  SetFillStyle(EmptyFill, 0);
  Bar(0, MaxY-(TextHeight('M')+4), MaxX, MaxY);      { Efface ligne statut }
  Rectangle(0, MaxY-(TextHeight('M')+4), MaxX, MaxY);
  OutTextXY(MaxX DIV 2, MaxY-(TextHeight('M')+2), Msg);
  { Retour  la fentre principale }
  SetViewPort(1, TextHeight('M')+5, MaxX-1, MaxY-(TextHeight('M')+5), ClipOn);
END; { StatusLine }

PROCEDURE KomanSortir;
{ Affiche le message classique "Frappez ... ESC... " en bas d'cran }
BEGIN
  StatusLine('Frappez une touche pour poursuivre (ESC=Abandon)');
END;

PROCEDURE WaitToGo;
{ Attend la frappe de l'utilisateur (continuer ou abandonner) }
CONST
  Esc = #27;
VAR
  Ch : CHAR;
BEGIN
  StatusLine('Frappez une touche pour poursuivre (ESC=Abandon)');
  REPEAT UNTIL KeyPressed;
    Ch := ReadKey;
  IF Ch = #0 THEN Ch := ReadKey;      { Pas de touche de fonction }
  IF Ch = Esc THEN
    Halt(0)                           { Fin du programme }
  ELSE
    ClearDevice;                      { On nettoie l'cran et on dmarre }
END; { WaitToGo }

PROCEDURE GetDriverAndMode(VAR DriveStr, ModeStr : STRING);
{ Renvoie des chanes dcrivant le pilote et le mode actifs }
BEGIN
  DriveStr := GetDriverName;
  ModeStr  := GetModeName(GetGraphMode);
    { Economise 40 lignes environ par rapport  TP4.0 grce  }
    { GetDriverName et GetModeName !!! }
END; { GetDriverAndMode }

PROCEDURE ReportStatus;
{ Affiche le statut de toutes les fonctions d'info aprs InitGraph }
CONST
  X = 10;
VAR
  ViewInfo   : ViewPortType;     { Paramtres pour procdures d'info }
  LineInfo   : LineSettingsType;
  FillInfo   : FillSettingsType;
  TextInfo   : TextSettingsType;
  Palette    : PaletteType;
  DriverStr  : STRING;           { Chanes pour pilote et mode }
  ModeStr    : STRING;
  Y          : WORD;

PROCEDURE WriteOut(S : STRING);
{ Affiche une chane et passe  la ligne suivante }
BEGIN
  OutTextXY(X, Y, S);
  Inc(Y, TextHeight('M')+2);
END; { WriteOut }

BEGIN { ReportStatus }
  GetDriverAndMode(DriverStr, ModeStr);   { Lecture valeurs courantes }
  GetViewSettings(ViewInfo);
  GetLineSettings(LineInfo);
  GetFillSettings(FillInfo);
  GetTextSettings(TextInfo);
  GetPalette(Palette);

  Y := 4;
  MainWindow('Statut aprs InitGraph');
  SetTextJustify(LeftText, TopText);
  WriteOut('Pilote graphique   : '+DriverStr);
  WriteOut('Mode graphique     : '+ModeStr);
  WriteOut('Coordonnes d''cran: (0, 0, '+Int2Str(GetMaxX)+', '+Int2Str(GetMaxY)+')');
  WITH ViewInfo DO
  BEGIN
    WriteOut('Fentre active     : ('+Int2Str(x1)+', '+Int2Str(y1)+', '+Int2Str(x2)+', '+Int2Str(y2)+')');
    IF ClipOn THEN
      WriteOut('Clip sur bordures  : OUI')
    ELSE
      WriteOut('Clip sur bordures  : NON');
  END;
  WriteOut('Position courante  : ('+Int2Str(GetX)+', '+Int2Str(GetY)+')');
  WriteOut('Entres de palette : '+Int2Str(Palette.Size));
  WriteOut('Dernire couleur   : '+Int2Str(GetMaxColor));
  WriteOut('Couleur courante   : '+Int2Str(GetColor));
  WITH LineInfo DO
  BEGIN
    WriteOut('Style de trac     : '+LineStyles[LineStyle]);
    WriteOut('Epaisseur de trac : '+Int2Str(Thickness));
  END;
  WITH FillInfo DO
  BEGIN
    WriteOut('Style   remplissage: '+FillStyles[Pattern]);
    WriteOut('Couleur remplissage: '+Int2Str(Color));
  END;
  WITH TextInfo DO
  BEGIN
    WriteOut('Police active      : '+Fonts[Font]);
    WriteOut('Direction de texte : '+TextDirect[Direction]);
    WriteOut('Taille de caractre: '+Int2Str(CharSize));
    WriteOut('Justif Horizontale : '+HorizJust[Horiz]);
    WriteOut('Justif Verticale   : '+VertJust[Vert]);
  END;
  WaitToGo;
END; { ReportStatus }

PROCEDURE FillEllipsePlay;
{ Gnration alatoire d'ellipses avec remplissage }
CONST
  MaxFillStyles = 12;       { Motifs 0..11 }
VAR
  MaxRadius : WORD;
  FillColor : INTEGER;
BEGIN
  MainWindow('DEMO de FillEllipse');
  KomanSortir;
  MaxRadius := MaxY DIV 10;
  SetLineStyle(SolidLn, 0, NormWidth);
  REPEAT
    FillColor := RandColor;
    SetColor(FillColor);
    SetFillStyle(Random(MaxFillStyles), FillColor);
    FillEllipse(Random(MaxX), Random(MaxY),
                Random(MaxRadius), Random(MaxRadius));
  UNTIL KeyPressed;
  WaitToGo;
END; { De FillEllipsePlay }

PROCEDURE SectorPlay;
{ Trac de secteurs alatoires }
CONST
  MaxFillStyles = 12; { Motifs 0..11 }
VAR
  MaxRadius : WORD;
  FillColor : INTEGER;
  EndAngle  : INTEGER;
BEGIN
  MainWindow('DEMO de Sector');
  KomanSortir;
  MaxRadius := MaxY DIV 10;
  SetLineStyle(SolidLn, 0, NormWidth);
  REPEAT
    FillColor := RandColor;
    SetColor(FillColor);
    SetFillStyle(Random(MaxFillStyles), FillColor);
    EndAngle := Random(360);
    Sector(Random(MaxX), Random(MaxY), Random(EndAngle), EndAngle,
           Random(MaxRadius), Random(MaxRadius));
  UNTIL KeyPressed;
  WaitToGo;
END; { De SectorPlay }

PROCEDURE WriteModePlay;
{ Dmonstration de la procdure SetWriteMode pour des lignes XOR }
CONST
  DelayValue = 50;  { Dlai en millisecondes (sinon trop rapide !) }
VAR
  ViewInfo      : ViewPortType;
  Color         : WORD;
  Left, Top     : INTEGER;
  Right, Bottom : INTEGER;
  Step          : INTEGER; { Intervalle pour disparition du rectangle }
BEGIN
  MainWindow('DEMO de SetWriteMode');
  KomanSortir;
  GetViewSettings(ViewInfo);
  Left := 0;
  Top  := 0;
  WITH ViewInfo DO
  BEGIN
    Right  := x2-x1;
    Bottom := y2-y1;
  END;
  Step := Bottom DIV 50;
  SetColor(GetMaxColor);
  Line(Left, Top, Right, Bottom);
  Line(Left, Bottom, Right, Top);
  SetWriteMode(XORPut);                    { Dfinit le mode de trac XOR }
  REPEAT
    Line(Left, Top, Right, Bottom);        { Trace lignes XOR }
    Line(Left, Bottom, Right, Top);
    Rectangle(Left, Top, Right, Bottom);   { Trace rectangle XOR }
    Delay(DelayValue);                     { Attente }
    Line(Left, Top, Right, Bottom);        { Effacement de lignes }
    Line(Left, Bottom, Right, Top);
    Rectangle(Left, Top, Right, Bottom);   { Effacement du rectangle }
    IF (Left+Step < Right) AND (Top+Step < Bottom) THEN
      BEGIN
        Inc(Left, Step);               { Le rectangle disparat par tapes }
        Inc(Top,  Step);
        Dec(Right,  Step);
        Dec(Bottom, Step);
      END
    ELSE
      BEGIN
        Color := RandColor;         { Nouvelle couleur }
        SetColor(Color);
        Left := 0;                  { Grand rectangle initial }
        Top  := 0;
        WITH ViewInfo DO
        BEGIN
          Right  := x2-x1;
          Bottom := y2-y1;
        END;
      END;
  UNTIL KeyPressed;
  SetWriteMode(CopyPut);                   { Retour en mode Surcharge }
  WaitToGo;
END; { De WriteModePlay }

PROCEDURE AspectRatioPlay;
{ Dmonstration de SetAspectRatio }
VAR
  ViewInfo   : ViewPortType;
  CenterX    : INTEGER;
  CenterY    : INTEGER;
  Radius     : WORD;
  Xasp, Yasp : WORD;
  i          : INTEGER;
  RadiusStep : WORD;
BEGIN
  MainWindow('DEMO de SetAspectRatio');
  GetViewSettings(ViewInfo);
  WITH ViewInfo DO
  BEGIN
    CenterX :=    (x2-x1) DIV 2;
    CenterY :=    (y2-y1) DIV 2;
    Radius  := 3*((y2-y1) DIV 5);
  END;
  RadiusStep := (Radius DIV 30);
  Circle(CenterX, CenterY, Radius);
  GetAspectRatio(Xasp, Yasp);
  FOR i := 1 TO 30 DO
  BEGIN
    SetAspectRatio(Xasp, Yasp+(I*GetMaxX));  { Augmente les proportions en Y }
    Circle(CenterX, CenterY, Radius);
    Dec(Radius, RadiusStep);                 { Diminue le rayon }
  END;
  Inc(Radius, RadiusStep*30);
  FOR i := 1 TO 30 DO
  BEGIN
    SetAspectRatio(Xasp+(I*GetMaxX), Yasp);  { Augmente les proportions en X }
    IF Radius > RadiusStep THEN
      Dec(Radius, RadiusStep);               { Diminution du rayon }
    Circle(CenterX, CenterY, Radius);
  END;
  SetAspectRatio(Xasp, Yasp);                { Retour  l'aspect antrieur }
  WaitToGo;
END; { De AspectRatioPlay }


PROCEDURE TextPlay;
{ Montre la justification de texte et le changement de taille }
VAR
  Size : WORD;
  W, H, X, Y : WORD;
  ViewInfo : ViewPortType;
BEGIN
  MainWindow('DEMO pour SettTextJustify / SetUserCharSize ');
  GetViewSettings(ViewInfo);
  WITH ViewInfo DO
  BEGIN
    SetTextStyle(TriplexFont, VertDir, 4);
    Y := (y2-y1) - 2;
    SetTextJustify(CenterText, BottomText);
    OutTextXY(2*TextWidth('M'), Y, 'Vertical');
    SetTextStyle(TriplexFont, HorizDir, 4);
    SetTextJustify(LeftText, TopText);
    OutTextXY(2*TextWidth('M'), 2, 'Horizontal');
    SetTextJustify(CenterText, CenterText);
    X := (x2-x1) DIV 2;
    Y := TextHeight('H');
    FOR Size := 1 TO 4 DO
    BEGIN
      SetTextStyle(TriplexFont, HorizDir, Size);
      H := TextHeight('M');
      W := TextWidth('M');
      Inc(Y, H);
      OutTextXY(X, Y, 'Taille '+Int2Str(Size));
    END;
    Inc(Y, H DIV 2);
    SetTextJustify(CenterText, TopText);
    SetUserCharSize(5, 6, 3, 2);
    SetTextStyle(TriplexFont, HorizDir, UserCharSize);
    OutTextXY((x2-x1) DIV 2, Y, 'Taille utilisateur');
  END;
  WaitToGo;
END; { De TextPlay }

PROCEDURE TextDump;
{ Affiche l'ensemble du jeu de caractres }
CONST
  CGASizes  : ARRAY[0..4] OF WORD = (1, 3, 7, 3, 3);
  NormSizes : ARRAY[0..4] OF WORD = (1, 4, 7, 4, 4);
VAR
  Font : WORD;
  ViewInfo : ViewPortType;
  Ch   : CHAR;
BEGIN
  FOR Font := 0 TO 4 DO
  BEGIN
    MainWindow(' Police de caractres '+Fonts[Font]);
    GetViewSettings(ViewInfo);
    WITH ViewInfo DO
    BEGIN
      SetTextJustify(LeftText, TopText);
      MoveTo(2, 3);
      IF Font = DefaultFont THEN
        BEGIN
          SetTextStyle(Font, HorizDir, 1);
          Ch := #0;
          REPEAT
            OutText(Ch);
            IF (GetX + TextWidth('M')) > (x2-x1) THEN
              MoveTo(2, GetY + TextHeight('M')+3);
            Ch := Succ(Ch);
          UNTIL (Ch >= #255);
        END
      ELSE
        BEGIN
          IF MaxY < 200 THEN
            SetTextStyle(Font, HorizDir, CGASizes[Font])
          ELSE
            SetTextStyle(Font, HorizDir, NormSizes[Font]);
          Ch := '!';
          REPEAT
            OutText(Ch);
            IF (GetX + TextWidth('M')) > (x2-x1) THEN
              MoveTo(2, GetY + TextHeight('M')+3);
            Ch := Succ(Ch);
          UNTIL (Ch >= #255);
        END;
    END; { de l'environnement with }
    WaitToGo;
  END; { de la boucle for }
END; { TextDump }

PROCEDURE LineToPlay;
{ Illustre les tracs de lignes avec MoveTo et LineTo }
CONST
  MaxPoints = 15;
VAR
  Points     : ARRAY[0..MaxPoints] OF PointType;
  ViewInfo   : ViewPortType;
  I, J       : INTEGER;
  CenterX    : INTEGER;   { Centre du cercle }
  CenterY    : INTEGER;
  Radius     : WORD;
  StepAngle  : WORD;
  Xasp, Yasp : WORD;
  Radians    : REAL;

FUNCTION AdjAsp(Value : INTEGER) : INTEGER;
{ Ajuste une valeur en fonction du rapport hauteur/largeur de l'cran }
BEGIN
  AdjAsp := (LONGINT(Value) * Xasp) DIV Yasp;
END; { AdjAsp }

BEGIN
  MainWindow('DEMO de MoveTo/LineTo ');
  GetAspectRatio(Xasp, Yasp);
  GetViewSettings(ViewInfo);
  WITH ViewInfo DO
  BEGIN
    CenterX := (x2-x1) DIV 2;
    CenterY := (y2-y1) DIV 2;
    Radius := CenterY;
    WHILE (CenterY+AdjAsp(Radius)) < (y2-y1)-20 DO
      Inc(Radius);
  END;
  StepAngle := 360 DIV MaxPoints;
  FOR I := 0 TO MaxPoints - 1 DO
  BEGIN
    Radians := (StepAngle * I) * Pi / 180;
    Points[I].X := CenterX + round(Cos(Radians) * Radius);
    Points[I].Y := CenterY - AdjAsp(round(Sin(Radians) * Radius));
  END;
  Circle(CenterX, CenterY, Radius);
  FOR I := 0 TO MaxPoints - 1 DO
  BEGIN
    FOR J := I TO MaxPoints - 1 DO
    BEGIN
      MoveTo(Points[I].X, Points[I].Y);
      LineTo(Points[J].X, Points[J].Y);
    END;
  END;
  WaitToGo;
END; { LineToPlay }

PROCEDURE LineRelPlay;
{ MoveRel et LineRel }
CONST
  MaxPoints = 12;
VAR
  Poly     : ARRAY[1..MaxPoints] OF PointType; { Stocke un polygone  remplir }
  CurrPort : ViewPortType;

PROCEDURE DrawTesseract;
{ Dessine un objet impossible sur un fond  motif
  avec dplacement relatif, trac relatif, cration d'un polygone  remplir }
CONST
  CheckerBoard : FillPatternType = (0, $10, $28, $44, $28, $10, 0, 0);
VAR
  X, Y, W, H   : INTEGER;

BEGIN
  GetViewSettings(CurrPort);
  WITH CurrPort DO
  BEGIN
    W := (x2-x1) DIV 9;
    H := (y2-y1) DIV 8;
    X := ((x2-x1) DIV 2) - Round(2.5 * W);
    Y := ((y2-y1) DIV 2) - (3 * H);

    Poly[1].X := 0;     Poly[1].Y := 0;
    Poly[2].X := x2-x1; Poly[2].Y := 0;
    Poly[3].X := x2-x1; Poly[3].Y := y2-y1;
    Poly[4].X := 0;     Poly[4].Y := y2-y1;
    Poly[5].X := 0;     Poly[5].Y := 0;
    MoveTo(X, Y);

    { Le cadre de la fentre be fait pas partie du polygone }
    MoveRel(0, H);      Poly[6].X := GetX;  Poly[6].Y := GetY;
    MoveRel(W, -H);     Poly[7].X := GetX;  Poly[7].Y := GetY;
    MoveRel(4*W, 0);    Poly[8].X := GetX;  Poly[8].Y := GetY;
    MoveRel(0, 5*H);    Poly[9].X := GetX;  Poly[9].Y := GetY;
    MoveRel(-W, H);     Poly[10].X := GetX; Poly[10].Y := GetY;
    MoveRel(-4*W, 0);   Poly[11].X := GetX; Poly[11].Y := GetY;
    MoveRel(0, -5*H);   Poly[12].X := GetX; Poly[12].Y := GetY;

    { Remplissage du polygone avec un motif dfini par l'utilisateur }
    SetFillPattern(CheckerBoard, MaxColor);
    FillPoly(12, Poly);

    MoveRel(W,  -H);
    LineRel(0, 5*H);  LineRel(2*W, 0);    LineRel(0, -3*H);
    LineRel(W,  -H);  LineRel(0, 5*H);    MoveRel(0, -5*H);
    LineRel(-2*W,0);  LineRel(0, 3*H);    LineRel(-W, H);
    MoveRel(W,  -H);  LineRel(W, 0);      MoveRel(0, -2*H);
    LineRel(-W,  0);

    { Remplissage flood du centre }
    FloodFill((x2-x1) DIV 2, (y2-y1) DIV 2, MaxColor);
  END;
END; { De DrawTesseract }

BEGIN
  MainWindow('DEMO de LineRel/MoveRel ');
  GetViewSettings(CurrPort);
  WITH CurrPort DO
    { Elargit le fentre active de 1 pixel }
    SetViewPort(x1-1, y1-1, x2+1, y2+1, ClipOn);
  DrawTesseract;
  WaitToGo;
END; { De LineRelPlay }

PROCEDURE PiePlay;
{ Dmonstration de PieSlice, GetAspectRatio  }
VAR
  ViewInfo   : ViewPortType;
  CenterX    : INTEGER;
  CenterY    : INTEGER;
  Radius     : WORD;
  Xasp, Yasp : WORD;
  X, Y       : INTEGER;

FUNCTION AdjAsp(Value : INTEGER) : INTEGER;
{ Ajuste les proportions }
BEGIN
  AdjAsp := (LONGINT(Value) * Xasp) DIV Yasp;
END; { AdjAsp }

PROCEDURE GetTextCoords(AngleInDegrees, Radius : WORD; VAR X, Y : INTEGER);
{ Lecture des coordonnes des textes des camemberts }
VAR
  Radians : REAL;
BEGIN
  Radians := AngleInDegrees * Pi / 180;
  X := Round(Cos(Radians) * Radius);
  Y := Round(Sin(Radians) * Radius);
END; { GetTextCoords }

BEGIN
  MainWindow('DEMO de PieSlice/GetAspectRatio');
  GetAspectRatio(Xasp, Yasp);
  GetViewSettings(ViewInfo);
  WITH ViewInfo DO
  BEGIN
    CenterX := (x2-x1)  DIV 2;
    CenterY := ((y2-y1) DIV 2) + 20;
    Radius  := (y2-y1)  DIV 3;
    WHILE AdjAsp(Radius) < Round((y2-y1) / 3.6) DO
      Inc(Radius);
  END;
  SetTextStyle(TriplexFont, HorizDir, 4);
  SetTextJustify(CenterText, TopText);
  OutTextXY(CenterX, 0, 'Voici un camembert !');

  SetTextStyle(TriplexFont, HorizDir, 3);

  SetFillStyle(SolidFill, RandColor);
  PieSlice(CenterX+10, CenterY-AdjAsp(10), 0, 90, Radius);
  GetTextCoords(45, Radius, X, Y);
  SetTextJustify(LeftText, BottomText);
  OutTextXY(CenterX+10+X+TextWidth('H'), CenterY-AdjAsp(10+Y), '25 %');

  SetFillStyle(HatchFill, RandColor);
  PieSlice(CenterX, CenterY, 225, 360, Radius);
  GetTextCoords(293, Radius, X, Y);
  SetTextJustify(LeftText, TopText);
  OutTextXY(CenterX+X+TextWidth('H'), CenterY-AdjAsp(Y), '37.5 %');

  SetFillStyle(InterleaveFill, RandColor);
  PieSlice(CenterX-10, CenterY, 135, 225, Radius);
  GetTextCoords(180, Radius, X, Y);
  SetTextJustify(RightText, CenterText);
  OutTextXY(CenterX-10+X-TextWidth('H'), CenterY-AdjAsp(Y), '25 %');

  SetFillStyle(WideDotFill, RandColor);
  PieSlice(CenterX, CenterY, 90, 135, Radius);
  GetTextCoords(112, Radius, X, Y);
  SetTextJustify(RightText, BottomText);
  OutTextXY(CenterX+X-TextWidth('H'), CenterY-AdjAsp(Y), '12.5 %');

  WaitToGo;
END; { De PiePlay }

PROCEDURE Bar3DPlay;
{ Histogrammes avec effet de relief - Bar3D }
CONST
  NumBars   = 7;  { Nombre de barres }
  BarHeight : ARRAY[1..NumBars] OF BYTE = (1, 3, 2, 5, 4, 2, 1);
  YTicks    = 5;  { Nombre de graduations en Y }
VAR
  ViewInfo : ViewPortType;
  H        : WORD;
  XStep    : REAL;
  YStep    : REAL;
  I, J     : INTEGER;
  Depth    : WORD;
  Color    : WORD;
BEGIN
  MainWindow('DEMO de Bar3D/Rectangle');
  H := 3*TextHeight('M');
  GetViewSettings(ViewInfo);
  SetTextJustify(CenterText, TopText);
  SetTextStyle(TriplexFont, HorizDir, 4);
  OutTextXY(MaxX DIV 2, 6, 'Voici des barres en 3D !');
  SetTextStyle(DefaultFont, HorizDir, 1);
  WITH ViewInfo DO
    SetViewPort(x1+50, y1+40, x2-50, y2-10, ClipOn);
  GetViewSettings(ViewInfo);
  WITH ViewInfo DO
  BEGIN
    Line(H, H, H, (y2-y1)-H);
    Line(H, (y2-y1)-H, (x2-x1)-H, (y2-y1)-H);
    YStep := ((y2-y1)-(2*H)) / YTicks;
    XStep := ((x2-x1)-(2*H)) / NumBars;
    J := (y2-y1)-H;
    SetTextJustify(CenterText, CenterText);

    { Trac de l'axe Y et des graduations }
    FOR I := 0 TO Yticks DO
    BEGIN
      Line(H DIV 2, J, H, J);
      OutTextXY(0, J, Int2Str(I));
      J := Round(J-Ystep);
    END;

    Depth := Trunc(0.25 * XStep);    { Calcule l'paisseur des barres }
    { Trac de l'axe X et des graduations }
    SetTextJustify(CenterText, TopText);
    J := H;
    FOR I := 1 TO Succ(NumBars) DO
    BEGIN
      SetColor(MaxColor);
      Line(J, (y2-y1)-H, J, (y2-y1-3)-(H DIV 2));
      OutTextXY(J, (y2-y1)-(H DIV 2), Int2Str(I-1));
      IF I <> Succ(NumBars) THEN
      BEGIN
        Color := RandColor;
        SetFillStyle(I, Color);
        SetColor(Color);
        Bar3D(J, Round((y2-y1-H)-(BarHeight[I] * Ystep)),
                 Round(J+Xstep-Depth), round((y2-y1)-H-1), Depth, TopOn);
        J := Round(J+Xstep);
      END;
    END;
  END;
  WaitToGo;
END; { De Bar3DPlay }

PROCEDURE BarPlay;
CONST
  NumBars   = 5;
  BarHeight : ARRAY[1..NumBars] OF BYTE = (1, 3, 5, 2, 4);
  Styles    : ARRAY[1..NumBars] OF BYTE = (1, 3, 10, 5, 9);
VAR
  ViewInfo  : ViewPortType;
  BarNum    : WORD;
  H         : WORD;
  XStep     : REAL;
  YStep     : REAL;
  I, J      : INTEGER;
  Color     : WORD;
BEGIN
  MainWindow('DEMO de Bar/Rectangle');
  H := 3*TextHeight('M');
  GetViewSettings(ViewInfo);
  SetTextJustify(CenterText, TopText);
  SetTextStyle(TriplexFont, HorizDir, 4);
  OutTextXY(MaxX DIV 2, 6, 'Voici des barres en 2D !');
  SetTextStyle(DefaultFont, HorizDir, 1);
  WITH ViewInfo DO
    SetViewPort(x1+50, y1+30, x2-50, y2-10, ClipOn);
  GetViewSettings(ViewInfo);
  WITH ViewInfo DO
  BEGIN
    Line(H, H, H, (y2-y1)-H);
    Line(H, (y2-y1)-H, (x2-x1)-H, (y2-y1)-H);
    YStep := ((y2-y1)-(2*H)) / NumBars;
    XStep := ((x2-x1)-(2*H)) / NumBars;
    J := (y2-y1)-H;
    SetTextJustify(CenterText, CenterText);

    { Axe Y et graduations }
    FOR I := 0 TO NumBars DO
    BEGIN
      Line(H DIV 2, J, H, J);
      OutTextXY(0, J, Int2Str(i));
      J := Round(J-Ystep);
    END;
    { Axe X et graduations }
    J := H;
    SetTextJustify(CenterText, TopText);
    FOR I := 1 TO Succ(NumBars) DO
    BEGIN
      SetColor(MaxColor);
      Line(J, (y2-y1)-H, J, (y2-y1-3)-(H DIV 2));
      OutTextXY(J, (y2-y1)-(H DIV 2), Int2Str(I));
      IF I <> Succ(NumBars) THEN
      BEGIN
        Color := RandColor;
        SetFillStyle(Styles[I], Color);
        SetColor(Color);
        Bar(J, Round((y2-y1-H)-(BarHeight[I] * Ystep)), 
            Round(J+Xstep), (y2-y1)-H-1);
        Rectangle(J, Round((y2-y1-H)-(BarHeight[I] * Ystep)), 
            Round(J+Xstep), (y2-y1)-H-1);
      END;
      J := Round(J+Xstep);
    END;

  END;
  WaitToGo;
END; { BarPlay }

PROCEDURE CirclePlay;
{ Cercles de tailles, couleurs et positions alatoires (Pschitt) }
VAR
  MaxRadius : WORD;
BEGIN
  MainWindow('DEMO de Circle ');
  KomanSortir;
  MaxRadius := MaxY DIV 10;
  SetLineStyle(SolidLn, 0, NormWidth);
  REPEAT
    SetColor(RandColor);
    Circle(Random(MaxX), Random(MaxY), Random(MaxRadius));
  UNTIL KeyPressed;
  WaitToGo;
END; { CirclePlay }

PROCEDURE RandBarPlay;
{ Rectangles de tailles, motifs et positions alatoires }
VAR
  MaxWidth  : INTEGER;
  MaxHeight : INTEGER;
  ViewInfo  : ViewPortType;
  Color     : WORD;
BEGIN
  MainWindow('Surfaces alatoires');
  KomanSortir;
  GetViewSettings(ViewInfo);
  WITH ViewInfo DO
  BEGIN
    MaxWidth  := x2-x1;
    MaxHeight := y2-y1;
  END;
  REPEAT
    Color := RandColor;
    SetColor(Color);
    SetFillStyle(Random(CloseDotFill)+1, Color);
    Bar3D(Random(MaxWidth), Random(MaxHeight),
          Random(MaxWidth), Random(MaxHeight), 0, TopOff);
  UNTIL KeyPressed;
  WaitToGo;
END; { RandBarPlay }

PROCEDURE ArcPlay;
{ Arcs de cercles alatoires faon PACMAN }
VAR
  MaxRadius : WORD;
  EndAngle  : WORD;
  ArcInfo   : ArcCoordsType;
BEGIN
  MainWindow('DEMO de Arc/GetArcCoords');
  KomanSortir;
  MaxRadius := MaxY DIV 10;
  REPEAT
    SetColor(RandColor);
    EndAngle := Random(360);
    SetLineStyle(SolidLn, 0, NormWidth);
    Arc(Random(MaxX), Random(MaxY), 
        Random(EndAngle), EndAngle, Random(MaxRadius));
    GetArcCoords(ArcInfo);
    WITH ArcInfo DO
    BEGIN
      Line(X, Y, XStart, YStart);
      Line(X, Y, Xend, Yend);
    END;
  UNTIL KeyPressed;
  WaitToGo;
END; { ArcPlay }

PROCEDURE PutPixelPlay;
{ Dmonstration de PutPixel/GetPixel }
CONST
  Seed   = 1958; { Valeur semence du gnrateur alatoire }
  NumPts = 2000; { Quantit de pixels  traiter           }
  Esc    = #27;
VAR
  I : WORD;
  X, Y, Color : WORD;
  XMax, YMax  : INTEGER;
  ViewInfo    : ViewPortType;
BEGIN
  MainWindow('DEMO de PutPixel/GetPixel');
  KomanSortir;
  GetViewSettings(ViewInfo);
  WITH ViewInfo DO
  BEGIN
    XMax := (x2-x1-1);
    YMax := (y2-y1-1);
  END;

  WHILE NOT KeyPressed DO
  BEGIN
    { Pose pixels alatoires }
    RandSeed := Seed;
    I := 0;
    WHILE (NOT KeyPressed) AND (I < NumPts) DO
    BEGIN
      Inc(I);
      PutPixel(Random(XMax)+1, Random(YMax)+1, RandColor);
    END;

    { Efface pixels }
    RandSeed := Seed;
    I := 0;
    WHILE (NOT KeyPressed) AND (I < NumPts) DO
    BEGIN
      Inc(I);
      X     := Random(XMax)+1;
      Y     := Random(YMax)+1;
      Color := GetPixel(X, Y);
      IF Color = RandColor THEN
        PutPixel(X, Y, 0);
    END;
  END;
  WaitToGo;
END; { PutPixelPlay }

PROCEDURE PutImagePlay;
{ Insertion/extraction d'images (GetImage et PutImage) }

CONST
  r     = 20;
  StartX = 100;
  StartY = 50;

VAR
  CurPort : ViewPortType;

{ Pour dplacer la soucoupe volante }
PROCEDURE MoveSaucer(VAR X, Y : INTEGER; Width, Height : INTEGER);
VAR
  Step : INTEGER;
BEGIN
  Step := Random(2*r);
  IF Odd(Step) THEN
    Step := -Step;
  X := X + Step;
  Step := Random(r);
  IF Odd(Step) THEN
    Step := -Step;
  Y := Y + Step;

  { Fait rebondir la soucoupe sur les bords de l'univers cathodique }
  WITH CurPort DO
  BEGIN
    IF (x1 + X + Width - 1 > x2) THEN
      X := x2-x1 - Width + 1
    ELSE
      IF (X < 0) THEN
        X := 0;
    IF (y1 + Y + Height - 1 > y2) THEN
      Y := y2-y1 - Height + 1
    ELSE
      IF (Y < 0) THEN
        Y := 0;
  END;
END; { De MoveSaucer }

VAR
  Pausetime : WORD;
  Saucer    : POINTER;
  X, Y      : INTEGER;
  ulx, uly  : WORD;
  lrx, lry  : WORD;
  Size      : WORD;
  I         : WORD;
BEGIN
  ClearDevice;
  FullPort;

  { Affichage de l'cran }
  ClearDevice;
  MainWindow('DEMO intersidrale de GetImage/PutImage');
  KomanSortir;
  GetViewSettings(CurPort);

  { Dessin de la soucoupe }
  Ellipse(StartX, StartY, 0, 360, r, (r DIV 3)+2);
  Ellipse(StartX, StartY-4, 190, 357, r, r DIV 3);
  Line(StartX+7, StartY-6, StartX+10, StartY-12);
  Circle(StartX+10, StartY-12, 2);
  Line(StartX-7, StartY-6, StartX-10, StartY-12);
  Circle(StartX-10, StartY-12, 2);
  SetFillStyle(SolidFill, MaxColor);
  FloodFill(StartX+1, StartY+4, GetColor);

  { Lecture de l'image de la soucoupe }
  ulx := StartX-(r+1);
  uly := StartY-14;
  lrx := StartX+(r+1);
  lry := StartY+(r DIV 3)+3;

  Size := ImageSize(ulx, uly, lrx, lry);
  GetMem(Saucer, Size);
  GetImage(ulx, uly, lrx, lry, Saucer^);
  PutImage(ulx, uly, Saucer^, XORput);               { Efface l'image }

  { Pose quelques toiles dans le dcor... }
  FOR I := 1 TO 1000 DO
    PutPixel(Random(MaxX), Random(MaxY), RandColor);
  X := MaxX DIV 2;
  Y := MaxY DIV 2;
  PauseTime := 70;

  { Effectue la promenade en soucoupe }
  REPEAT
    PutImage(X, Y, Saucer^, XORput);                 { Dessine }
    Delay(PauseTime);
    PutImage(X, Y, Saucer^, XORput);                 { Efface }
    MoveSaucer(X, Y, lrx - ulx + 1, lry - uly + 1);  { hauteur/largeur }
  UNTIL KeyPressed;
  FreeMem(Saucer, size);
  WaitToGo;
END; { PutImagePlay }

PROCEDURE PolyPlay;
{ Trac de polygones alatoires (beaucoup de triangles) }
CONST
  MaxPts = 5;
TYPE
  PolygonType = ARRAY[1..MaxPts] OF PointType;
VAR
  Poly : PolygonType;
  I, Color : WORD;
BEGIN
  MainWindow('DEMO de FillPoly');
  KomanSortir;
  REPEAT
    Color := RandColor;
    SetFillStyle(Random(11)+1, Color);
    SetColor(Color);
    FOR I := 1 TO MaxPts DO
      WITH Poly[I] DO
      BEGIN
        X := Random(MaxX);
        Y := Random(MaxY);
      END;
    FillPoly(MaxPts, Poly);
  UNTIL KeyPressed;
  WaitToGo;
END; { PolyPlay }

PROCEDURE FillStylePlay;
{ Styles de remplissage prdfinis }
VAR
  Style    : WORD;
  Width    : WORD;
  Height   : WORD;
  X, Y     : WORD;
  I, J     : WORD;
  ViewInfo : ViewPortType;

PROCEDURE DrawBox(X, Y : WORD);
BEGIN
  SetFillStyle(Style, MaxColor);
  WITH ViewInfo DO
    Bar(X, Y, X+Width, Y+Height);
  Rectangle(X, Y, X+Width, Y+Height);
  OutTextXY(X+(Width DIV 2), Y+Height+4, Int2Str(Style));
  Inc(Style);
END; { DrawBox }

BEGIN
  MainWindow('Styles de remplissage prdfinis');
  GetViewSettings(ViewInfo);
  WITH ViewInfo DO
  BEGIN
    Width  := 2 * ((x2+1)  DIV 13);
    Height := 2 * ((y2-10) DIV 10);
  END;
  X := Width  DIV 2;
  Y := Height DIV 2;
  Style := 0;
  FOR J := 1 TO 3 DO
  BEGIN
    FOR I := 1 TO 4 DO
    BEGIN
      DrawBox(X, Y);
      Inc(X, (Width DIV 2) * 3);
    END;
    X := Width DIV 2;
    Inc(Y, (Height DIV 2) * 3);
  END;
  SetTextJustify(LeftText, TopText);
  WaitToGo;
END; { FillStylePlay }

PROCEDURE FillPatternPlay;
{ Quelques motifs de remplissage dfinis par le programmeur }
CONST
  Patterns : ARRAY[0..11] OF FillPatternType = (
  ($AA, $55, $AA, $55, $AA, $55, $AA, $55),
  ($33, $33, $CC, $CC, $33, $33, $CC, $CC),
  ($F0, $F0, $F0, $F0, $F, $F, $F, $F),
  (0, $10, $28, $44, $28, $10, 0, 0),
  (0, $70, $20, $27, $25, $27, $4, $4),
  (0, 0, 0, $18, $18, 0, 0, 0),
  (0, 0, $3C, $3C, $3C, $3C, 0, 0),
  (0, $7E, $7E, $7E, $7E, $7E, $7E, 0),
  (0, 0, $22, $8, 0, $22, $1C, 0),
  ($FF, $7E, $3C, $18, $18, $3C, $7E, $FF),
  (0, $10, $10, $7C, $10, $10, 0, 0),
  (0, $42, $24, $18, $18, $24, $42, 0));
VAR
  Style    : WORD;
  Width    : WORD;
  Height   : WORD;
  X, Y     : WORD;
  I, J     : WORD;
  ViewInfo : ViewPortType;

PROCEDURE DrawBox(X, Y : WORD);
BEGIN
  SetFillPattern(Patterns[Style], MaxColor);
  WITH ViewInfo DO
    Bar(X, Y, X+Width, Y+Height);
  Rectangle(X, Y, X+Width, Y+Height);
  Inc(Style);
END; { DrawBox }

BEGIN
  MainWindow('Styles de remplissage dfinis par le programmeur');
  GetViewSettings(ViewInfo);
  WITH ViewInfo DO
  BEGIN
    Width  := 2 * ((x2+ 1) DIV 13);
    Height := 2 * ((y2-10) DIV 10);
  END;
  X := Width  DIV 2;
  Y := Height DIV 2;
  Style := 0;
  FOR J := 1 TO 3 DO
  BEGIN
    FOR I := 1 TO 4 DO
    BEGIN
      DrawBox(X, Y);
      Inc(X, (Width DIV 2) * 3);
    END;
    X := Width DIV 2;
    Inc(Y, (Height DIV 2) * 3);
  END;
  SetTextJustify(LeftText, TopText);
  WaitToGo;
END; { FillPatternPlay }

PROCEDURE ColorPlay;
{ Affiche toutes les couleurs utilisables avec le pilote et le mode choisis }
VAR
  Color    : WORD;
  Width    : WORD;
  Height   : WORD;
  X, Y     : WORD;
  I, J     : WORD;
  ViewInfo : ViewPortType;

PROCEDURE DrawBox(X, Y : WORD);
BEGIN
  SetFillStyle(SolidFill, Color);
  SetColor(Color);
  WITH ViewInfo DO
    Bar(X, Y, X+Width, Y+Height);
  Rectangle(X, Y, X+Width, Y+Height);
  Color := GetColor;
  IF Color = 0 THEN
    BEGIN
      SetColor(MaxColor);
      Rectangle(X, Y, X+Width, Y+Height);
    END;
  OutTextXY(X+(Width DIV 2), Y+Height+4, Int2Str(Color));
  Color := Succ(Color) MOD (MaxColor + 1);
END; { DrawBox }

BEGIN   { De ColorPlay }
  MainWindow('DEMO des couleurs');
  Color := 1;
  GetViewSettings(ViewInfo);
  WITH ViewInfo DO
    BEGIN
      Width  := 2 * ((x2+ 1) DIV 16);
      Height := 2 * ((y2-10) DIV 10);
    END;
  X := Width  DIV 2;
  Y := Height DIV 2;
  FOR J := 1 TO 3 DO
    BEGIN
      FOR I := 1 TO 5 DO
        BEGIN
          DrawBox(X, Y);
          Inc(X, (Width DIV 2) * 3);
        END;
      X := Width DIV 2;
      Inc(Y, (Height DIV 2) * 3);
    END;
  WaitToGo;
END; { ColorPlay }

PROCEDURE PalettePlay;
{ Dmonstration toute en couleurs de la palette avec SetPalette }
CONST
  XBars = 15;
  YBars = 10;
VAR
  I, J     : WORD;
  X, Y     : WORD;
  Color    : WORD;
  ViewInfo : ViewPortType;
  Width    : WORD;
  Height   : WORD;
  OldPal   : PaletteType;
BEGIN
  GetPalette(OldPal);
  MainWindow('DEMO de SetPalette');
  StatusLine('Frappez une touche...');
  GetViewSettings(ViewInfo);
  WITH ViewInfo DO
    BEGIN
      Width := (x2-x1) DIV XBars;
      Height := (y2-y1) DIV YBars;
    END;
  X := 0; Y := 0;
  Color := 0;
  FOR J := 1 TO YBars DO
    BEGIN
      FOR I := 1 TO XBars DO
        BEGIN
          SetFillStyle(SolidFill, Color);
          Bar(X, Y, X+Width, Y+Height);
          Inc(X, Width+1);
          Inc(Color);
          Color := Color MOD (MaxColor+1);
        END;
      X := 0;
      Inc(Y, Height+1);
    END;
  REPEAT
    SetPalette(Random(GetMaxColor + 1), Random(65));
  UNTIL KeyPressed;
  SetAllPalette(OldPal);
  WaitToGo;
END; { PalettePlay }

PROCEDURE CrtModePlay;
{ Passage en mode texte et retour avec RestoreCrtMode et SetGraphMode }
VAR
  ViewInfo : ViewPortType;
  Ch       : CHAR;
BEGIN
  MainWindow('DEMO de SetGraphMode/RestoreCrtMode');
  GetViewSettings(ViewInfo);
  SetTextJustify(CenterText, CenterText);
  WITH ViewInfo DO
  BEGIN
    OutTextXY((x2-x1) DIV 2, (y2-y1) DIV 2, 'Nous sommes en mode graphique ');
    StatusLine('Frappez une touche pour passer en mode texte');
    REPEAT UNTIL KeyPressed;
      Ch := ReadKey;
    IF Ch = #0 THEN Ch := ReadKey;    { 2me octet de touche de fonction }
    RestoreCrtmode;
    Writeln('Nous sommes passs en mode texte (Notez les accents : e.)');
    Write('Frappez une touche pour retourner en mode graphique ...');
    REPEAT UNTIL KeyPressed;
      Ch := ReadKey;
    IF Ch = #0 THEN Ch := ReadKey;    { 2me octet de touche de fonction }
    SetGraphMode(GetGraphMode);
    MainWindow('DEMO de SetGraphMode/RestoreCrtMode');
    SetTextJustify(CenterText, CenterText);
    OutTextXY((x2-x1) DIV 2, (y2-y1) DIV 2,
      'Et Hop! De retour en mode graphique... avec les accents : ');
  END; { De WITH ViewInfo }
  WaitToGo;
END; { CrtModePlay }

PROCEDURE LineStylePlay;
VAR
  Style    : WORD;
  Step     : WORD;
  X, Y     : WORD;
  ViewInfo : ViewPortType;

BEGIN
  ClearDevice;
  DefaultColors;
  MainWindow('Styles de ligne prdfinis');
  GetViewSettings(ViewInfo);
  WITH ViewInfo DO
  BEGIN
    X := 35;
    Y := 10;
    Step := (x2-x1) DIV 11;
    SetTextJustify(LeftText, TopText);
    OutTextXY(X, Y, 'Epaisseur normale');
    SetTextJustify(CenterText, TopText);
    FOR Style := 0 TO 3 DO
      BEGIN
        SetLineStyle(Style, 0, NormWidth);
        Line(X, Y+20, X, Y2-40);
        OutTextXY(X, Y2-30, Int2Str(Style));
        Inc(X, Step);
      END;
    Inc(X, 2*Step);
    SetTextJustify(LeftText, TopText);
    OutTextXY(X, Y, ' Grande paisseur');
    SetTextJustify(CenterText, TopText);
    FOR Style := 0 TO 3 DO
      BEGIN
        SetLineStyle(Style, 0, ThickWidth);
        Line(X, Y+20, X, Y2-40);
        OutTextXY(X, Y2-30, Int2Str(Style));
        Inc(X, Step);
      END;
  END; { De WITH ViewInfo }
  SetTextJustify(LeftText, TopText);
  WaitToGo;
END; { LineStylePlay }

PROCEDURE UserLineStylePlay;
{ Dmonstration des styles de ligne dfinis par l'utilisateur }
VAR
  Style    : WORD;
  X, Y, I  : WORD;
  ViewInfo : ViewPortType;
BEGIN
  MainWindow('Styles de ligne dfinis par le programmeur');
  GetViewSettings(ViewInfo);
  WITH ViewInfo DO
  BEGIN
    X     := 4;
    Y     := 10;
    Style := 0;
    I     := 0;
    WHILE X < X2-4 DO
      BEGIN
          {$B+}
        Style := Style OR (1 SHL (I MOD 16));
          {$B-}
        SetLineStyle(UserBitLn, Style, NormWidth);
        Line(X, Y, X, (y2-y1)-Y);
        Inc(X, 5);
        Inc(I);
        IF Style = 65535 THEN
          BEGIN
          I     := 0;
          Style := 0;
          END;
      END;
  END;
  WaitToGo;
END; { UserLineStylePlay }

PROCEDURE SayGoodbye;
{ Dire au revoir et Merci ! }
VAR
  ViewInfo : ViewPortType;
BEGIN
  MainWindow('');
  GetViewSettings(ViewInfo);
  SetTextStyle(TriplexFont, HorizDir, 4);
  SetTextJustify(CenterText, CenterText);
  WITH ViewInfo DO
    OutTextXY((x2-x1) DIV 2, (y2-y1) DIV 2, 'Et voil, c''est tout ! MERCI');
  StatusLine('Frappez une dernire touche pour sortir...');
  REPEAT UNTIL KeyPressed;
END; { SayGoodbye }

{ ************* CORPS PRINCIPAL DE BGIDEMO.PAS ************ }
BEGIN         
  Initialize;
  ReportStatus;

  AspectRatioPlay;
  FillEllipsePlay;
  SectorPlay;
  WriteModePlay;

  ColorPlay;
  { PalettePlay n'est activ que dans le cas des pilotes suivants : }
  IF (GraphDriver = EGA)   OR
     (GraphDriver = EGA64) OR
     (GraphDriver = VGA) THEN
     PalettePlay;
  PutPixelPlay;
  PutImagePlay;
  RandBarPlay;
  BarPlay;
  Bar3DPlay;
  ArcPlay;
  CirclePlay;
  PiePlay;
  LineToPlay;
  LineRelPlay;
  LineStylePlay;
  UserLineStylePlay;
  TextDump;
  TextPlay;
  CrtModePlay;
  FillStylePlay;
  FillPatternPlay;
  PolyPlay;
  SayGoodbye;
  CloseGraph;
END.

{********** FIN DE BGIDEMO.PAS                         *** (TP) ***}
