{**************************************************************}
{********** A R T Y . P A S                          *** (TP)**}
{**************************************************************}
{   Copyright (c) 1985-1990 Borland International, Inc.        }

PROGRAM Arty;
{ Dmonstration de l'interface graphique Borland Graphics Interface (BGI)
  livre avec Turbo Pascal

  Fichiers ncessaires :
    TURBO.EXE - (ou TPC.EXE)
    TURBO.TPL - Units standard
    GRAPH.TPU - L'unit graphique indpendante
    *.BGI     - Les pilotes graphiques (device drivers)

  Commandes utilisables pendant le droulement de ARTY
  ----------------------------------------------------
  <B>   - Change la couleur de fond d'cran
  <C>   - Change la couleur de trac
  <ESC> - Sortie du programme
  Toute autre touche provoque une pause puis un raffichage

  Note: Si l'option de ligne de commande /H est spcifie, la meilleure
  rsolution d'cran possible sera recherche.

}

USES
  Crt, Graph;

CONST
   Memory  = 100;
   Windows =   4;

TYPE
  ResolutionPreference = (Lower, Higher);
  ColorList = ARRAY [1..Windows] OF INTEGER;

VAR
  Xmax,
  Ymax,
  ViewXmax,
  ViewYmax : INTEGER;

  Line:  ARRAY [1..Memory] OF RECORD
                    LX1,LY1: INTEGER;
                    LX2,LY2: INTEGER;
                    LColor : ColorList;
         END;
  X1,X2,Y1,Y2,
  CurrentLine,
  ColorCount,
  IncrementCount,
  DeltaX1,DeltaY1,DeltaX2,DeltaY2: INTEGER;
  Colors       : ColorList;
  Ch           : CHAR;
  BackColor    : INTEGER;
  GraphDriver,
  GraphMode    : INTEGER;
  MaxColors    : WORD;
  MaxDelta     : INTEGER;
  ChangeColors : BOOLEAN;

PROCEDURE Frame;
BEGIN
  SetViewPort(0, 0, Xmax, Ymax-(TextHeight('M')+4)-1,ClipOn);
  SetColor(MaxColors);
  Rectangle(0, 0, Xmax-1, (Ymax-(TextHeight('M')+4)-1)-1);
  SetViewPort(1, 1, Xmax-2, (Ymax-(TextHeight('M')+4)-1)-2,ClipOn);
END;  { De Frame }

PROCEDURE FullPort;
{ Dfinit l'cran complet comme fentre active (ViewPort) }
BEGIN
  SetViewPort(0, 0, Xmax, Ymax, ClipOn);
END; { De FullPort }

PROCEDURE MessageFrame(Msg:STRING);
BEGIN
  FullPort;
  SetColor(MaxColors);
  SetTextStyle(DefaultFont, HorizDir, 1);
  SetTextJustify(CenterText, TopText);
  SetLineStyle(SolidLn, 0, NormWidth);
  SetFillStyle(EmptyFill, 0);
  Bar(0, Ymax-(TextHeight('M')+4), Xmax, Ymax);
  Rectangle(0, Ymax-(TextHeight('M')+4), Xmax, Ymax);
  OutTextXY(Xmax DIV 2, Ymax-(TextHeight('M')+2), Msg);
  { Retour  la fentre principale }
  Frame;
END; { De MessageFrame }

PROCEDURE WaitToGo;
VAR
  Ch : CHAR;
BEGIN
  MessageFrame('(Touche = Reprendre) (Esc = Sortie)');
  REPEAT UNTIL KeyPressed;
  Ch := ReadKey;
  IF Ch = #27 THEN
    BEGIN
      CloseGraph;
      Writeln('Termin...');
      Halt(1);
    END
  ELSE
    ClearViewPort;
  MessageFrame('(Touche = Pause) (Esc = Sortie )');
END; { De WaitToGo }

PROCEDURE TestGraphError(GraphErr: INTEGER);
BEGIN
  IF GraphErr <> grOk THEN
    BEGIN
      Writeln('Erreur graphique : ', GraphErrorMsg(GraphErr));
      REPEAT UNTIL KeyPressed;
      Ch := ReadKey;
      Halt(1);
    END;
END;

PROCEDURE Init;
VAR
  Err, I : INTEGER;
  StartX, StartY: INTEGER;
  Resolution    : ResolutionPreference;
  s : STRING;
BEGIN
  Resolution := Lower;
  IF ParamCount > 0 THEN
    BEGIN
      s := ParamStr(1);
      IF s[1] = '/' THEN
      IF Upcase(s[2]) = 'H' THEN
      Resolution := Higher;
    END;

  CurrentLine    := 1;
  ColorCount     := 0;
  IncrementCount := 0;
  Ch := ' ';
  GraphDriver := Detect;
  DetectGraph(GraphDriver, GraphMode);
  TestGraphError(GraphResult);
  CASE GraphDriver OF
    CGA        : BEGIN
                   MaxDelta    := 7;
                   GraphDriver := CGA;
                   GraphMode   := CGAC1;
                 END;

    MCGA       : BEGIN
                   MaxDelta := 7;
                   CASE GraphMode OF
                   MCGAMed, MCGAHi: GraphMode := MCGAC1;
                   END;
                 END;

    EGA       : BEGIN
                  MaxDelta := 16;
                  IF Resolution = Lower THEN
                  GraphMode := EGALo
                  ELSE
                  GraphMode := EGAHi;
                END;

    EGA64    : BEGIN
                 MaxDelta := 16;
                 IF Resolution = Lower THEN
                 GraphMode := EGA64Lo
                 ELSE
                 GraphMode := EGA64Hi;
               END;

     HercMono  : MaxDelta := 16;
     EGAMono   : MaxDelta := 16;
     PC3270    : BEGIN
                   MaxDelta := 7;
                   GraphDriver := CGA;
                   GraphMode   := CGAC1;
                 END;


     ATT400   : CASE GraphMode OF
                ATT400C1,
                ATT400C2,
                ATT400Med,
                ATT400Hi  :
                BEGIN
                  MaxDelta  := 7;
                  GraphMode := ATT400C1;
                END;
               END;

     VGA   : BEGIN
               MaxDelta := 16;
             END;
  END; { Du case GraphDriver }
  InitGraph(GraphDriver, GraphMode, '');
  TestGraphError(GraphResult);
  SetTextStyle(DefaultFont, HorizDir, 1);
  SetTextJustify(CenterText, TopText);

  MaxColors := GetMaxColor;
  BackColor := 0;
  ChangeColors := TRUE;
  Xmax := GetMaxX;
  Ymax := GetMaxY;
  ViewXmax := Xmax-2;
  ViewYmax := (Ymax-(TextHeight('M')+4)-1)-2;
  StartX := Xmax DIV 2;
  StartY := Ymax DIV 2;
  FOR I := 1 TO Memory DO WITH Line[I] DO BEGIN
      LX1 := StartX; LX2 := StartX;
      LY1 := StartY; LY2 := StartY;
    END;

   X1 := StartX;
   X2 := StartX;
   Y1 := StartY;
   Y2 := StartY;
END; { De Procdure Init}

PROCEDURE AdjustX(VAR X,DeltaX: INTEGER);
VAR
  TestX: INTEGER;
BEGIN
  TestX := X+DeltaX;
  IF (TestX<1) OR (TestX>ViewXmax) THEN
    BEGIN
      TestX := X;
      DeltaX := -DeltaX;
    END;
  X := TestX;
END;

PROCEDURE AdjustY(var Y,DeltaY: INTEGER);
VAR
  TestY: INTEGER;
BEGIN
  TestY := Y+DeltaY;
  IF (TestY<1) OR (TestY>ViewYmax) THEN
    BEGIN
      TestY := Y;
      DeltaY := -DeltaY;
    END;
  Y := TestY;
END;

PROCEDURE SelectNewColors;
BEGIN
  IF NOT ChangeColors THEN exit;
  Colors[1] := Random(MaxColors)+1;
  Colors[2] := Random(MaxColors)+1;
  Colors[3] := Random(MaxColors)+1;
  Colors[4] := Random(MaxColors)+1;
  ColorCount := 3*(1+Random(5));
END;

PROCEDURE SelectNewDeltaValues;
BEGIN
  DeltaX1 := Random(MaxDelta)-(MaxDelta DIV 2);
  DeltaX2 := Random(MaxDelta)-(MaxDelta DIV 2);
  DeltaY1 := Random(MaxDelta)-(MaxDelta DIV 2);
  DeltaY2 := Random(MaxDelta)-(MaxDelta DIV 2);
  IncrementCount := 2*(1+Random(4));
END;


PROCEDURE SaveCurrentLine(CurrentColors: ColorList);
BEGIN
  WITH Line[CurrentLine] DO
  BEGIN
    LX1 := X1;
    LY1 := Y1;
    LX2 := X2;
    LY2 := Y2;
    LColor := CurrentColors;
  END;
END;

PROCEDURE Draw(x1,y1,x2,y2,color:WORD);
BEGIN
  SetColor(color);
  Graph.Line(x1,y1,x2,y2);
END;

PROCEDURE Regenerate;
VAR
  I: INTEGER;
BEGIN
  Frame;
  FOR I := 1 TO Memory DO
    WITH Line[I] DO
    BEGIN
      Draw(LX1,LY1,LX2,LY2,LColor[1]);
      Draw(ViewXmax-LX1,LY1,ViewXmax-LX2,LY2,LColor[2]);
      Draw(LX1,ViewYmax-LY1,LX2,ViewYmax-LY2,LColor[3]);
      Draw(ViewXmax-LX1,ViewYmax-LY1,ViewXmax-LX2,ViewYmax-LY2,LColor[4]);
    END;
  WaitToGo;
  Frame;
END;

PROCEDURE Updateline;
BEGIN
  Inc(CurrentLine);
  IF CurrentLine > Memory THEN CurrentLine := 1;
  Dec(ColorCount);
  Dec(IncrementCount);
END;

PROCEDURE CheckForUserInput;
BEGIN
  IF KeyPressed THEN
    BEGIN
      Ch := ReadKey;
      IF Upcase(Ch) = 'B' THEN
      BEGIN
        IF BackColor > MaxColors THEN BackColor := 0
        ELSE Inc(BackColor);
        SetBkColor(BackColor);
     END
       ELSE
       IF Upcase(Ch) = 'C' THEN
       BEGIN
        IF ChangeColors THEN ChangeColors := FALSE
        ELSE ChangeColors := TRUE;
        ColorCount := 0;
      END
      ELSE IF Ch<>#27 THEN Regenerate;
    END;
END;

PROCEDURE DrawCurrentLine;
VAR c1,c2,c3,c4: INTEGER;
BEGIN
  c1 := Colors[1];
  c2 := Colors[2];
  c3 := Colors[3];
  c4 := Colors[4];
  IF MaxColors = 1 THEN
    BEGIN
      c2 := c1; c3 := c1; c4 := c1;
    END;

  Draw(X1,Y1,X2,Y2,c1);
  Draw(ViewXmax-X1,Y1,ViewXmax-X2,Y2,c2);
  Draw(X1,ViewYmax-Y1,X2,ViewYmax-Y2,c3);
  IF MaxColors = 3 THEN c4 := Random(3)+1; { Couleurs alternes }
  Draw(ViewXmax-X1,ViewYmax-Y1,ViewXmax-X2,ViewYmax-Y2,c4);
  SaveCurrentLine(Colors);
END;

PROCEDURE EraseCurrentLine;
BEGIN
  WITH Line[CurrentLine] DO
  BEGIN
    Draw(LX1,LY1,LX2,LY2,0);
    Draw(ViewXmax-LX1,LY1,ViewXmax-LX2,LY2,0);
    Draw(LX1,ViewYmax-LY1,LX2,ViewYmax-LY2,0);
    Draw(ViewXmax-LX1,ViewYmax-LY1,ViewXmax-LX2,ViewYmax-LY2,0);
  END;
END;

PROCEDURE DoArt;
BEGIN
  SelectNewColors;
  REPEAT
    EraseCurrentLine;
    IF ColorCount = 0
      THEN SelectNewColors;
    IF IncrementCount=0
      THEN SelectNewDeltaValues;
    AdjustX(X1,DeltaX1); AdjustX(X2,DeltaX2);
    AdjustY(Y1,DeltaY1); AdjustY(Y2,DeltaY2);
    IF Random(5)=3 THEN
      BEGIN
      x1 := (x1+x2) DIV 2; { Raccourcit les lignes }
      y2 := (y1+y2) DIV 2;
      END;
    DrawCurrentLine;
    Updateline;
    CheckForUserInput;
  UNTIL Ch=#27;
END;

BEGIN
   Init;
   Frame;
   MessageFrame('Frappez une touche. (Esc = sortie).');
   DoArt;
   CloseGraph;
   RestoreCrtMode;
   Writeln('C''est fini.');
END.

{******** Fin de ARTY.PAS - TP    ***********}
