
Unit Vecteur;
{ (c) Copyright 1996 GSoft computing & Laurent GREGOIRE }
{ e-Mail : Cyber2Casa@aol.com                           }
{          Laurent.Gregoire@f109.n176.fm.alphanet.ch    }
{ BBS Xenakys : (+033)  02.40.48.76.85                  }
{ ----------------------------------------              }
{ This program belong to the public domain              }
{ ----------------------------------------              }
{ Gestion des vecteurs 3d, version complete             }

Interface

Type
 Coord = Record
  X,Y,Z : Real;
 End;

Const
 X0 : Coord = (X:1;Y:0;Z:0);
 Y0 : Coord = (X:0;Y:1;Z:0);
 Z0 : Coord = (X:0;Y:0;Z:1);  { Base de repre (X0,Y0,Z0) }
 VNul:Coord = (X:0;Y:0;Z:0);  { Vecteur nul               }
 Epsilon = 1e-10;             { Petit nombre pour les test de nullite }

Function Scalaire(U,V:Coord):Real;       { Produit scalaire U par V }
Function Norme2(V:Coord):Real;           { Norme au carr de V  }
Function Norme(V:Coord):Real;            { Norme de V }
Procedure Unitaire(U:Coord;VAR N:Coord); { Vecteur unitaire de U ds N }
Procedure PrVect(U,V:Coord;VAR W:Coord); { Produit vectoriel U^V=W }
Function Colineaire(U,V:Coord):Boolean;  { True si U = k.V  }
Procedure Lineaire(U:Coord;A:Real;V:Coord;B:Real;VAR W:Coord); { W=A*U+B*V }
Procedure Rotation(VAR U:Coord;VAR V:Coord;Ang:Real);  { Tourne U,V de Ang dans le plan (U,V) }
Procedure ScMult(U:Coord;A:Real;VAR V:Coord); { V=A*U }
Procedure Addi(U,V:Coord;VAR W:Coord);        { W=U+V }
Procedure Sous(U,V:Coord;VAR W:Coord);        { W=U-V }
{ Racines d'un polynome (A,B,C) dans (S1,S2) }
Function Polynome(A,B,C:Real; VAR S1,S2:Real):Boolean;
{ Intersection droite-sphre }
Function InterSphereDroite (u,O:Coord; C:Coord; R:Real; VAR I1,I2:Coord):Boolean;
Function Egal (U,V:Coord):Boolean;  { True si U gal  V  Epsilon prs}
Function Distance (A,B:Coord):Real; { Distance entre A et B }
{ Intersection droite-plan }
Function InterPlanDroite (u,A:Coord; O,n:Coord;VAR I:Coord):Boolean;
Procedure Reflechie(A,N:Coord;VAR B:Coord); { B : symtrique de A / N }

Implementation

Function Scalaire(U,V:Coord):Real;
Begin
 Scalaire:=U.X*V.X+U.Y*V.Y+U.Z*V.Z;
End;

Function Norme2(V:Coord):Real;
Begin
 Norme2:=Sqr(V.X)+Sqr(V.Y)+Sqr(V.Z);
End;

Function Norme(V:Coord):Real;
Begin
 Norme:=Sqrt(Norme2(V));
End;

Procedure Unitaire(U:Coord;VAR N:Coord);
Var USN:Real;
    No:Real;
Begin
 No:=Norme(U);
 If (No<Epsilon)
  Then N:=VNul
  Else
   Begin
    USN:=1/No;
    N.X:=U.X*USN;
    N.Y:=U.Y*USN;
    N.Z:=U.Z*USN;
   End;
End;

Procedure PrVect(U,V:Coord;VAR W:Coord);
Begin
 W.X:=U.Y*V.Z-U.Z*V.Y;
 W.Y:=U.Z*V.X-U.X*V.Z;
 W.Z:=U.X*V.Y-U.Y*V.X;
End;

Function Colineaire(U,V:Coord):Boolean;
Var W:Coord;
Begin
 PrVect(U,V,W);
 Colineaire:=(Norme2(W)<Epsilon);
End;

Procedure Lineaire(U:Coord;A:Real;V:Coord;B:Real;VAR W:Coord);
Begin
 W.X:=A*U.X+B*V.X;
 W.Y:=A*U.Y+B*V.Y;
 W.Z:=A*U.Z+B*V.Z;
End;

Procedure Rotation(VAR U:Coord;VAR V:Coord;Ang:Real);
Var
 Cs,Sn:Real;
 W,X:Coord;
Begin
 Cs:=Cos(Ang);
 Sn:=Sin(Ang);
 Lineaire(U,Cs,V,Sn,W);
 Lineaire(U,-Sn,V,Cs,X);
 U:=W;
 V:=X;
End;

Procedure ScMult(U:Coord;A:Real;VAR V:Coord);
Begin
 V.X:=A*U.X;
 V.Y:=A*U.Y;
 V.Z:=A*U.Z;
End;

Procedure Addi(U,V:Coord;VAR W:Coord);
Begin
 W.X:=U.X+V.X;
 W.Y:=U.Y+V.Y;
 W.Z:=U.Z+V.Z;
End;

Procedure Sous(U,V:Coord;VAR W:Coord);
Begin
 W.X:=U.X-V.X;
 W.Y:=U.Y-V.Y;
 W.Z:=U.Z-V.Z;
End;

{ Renvoi les racines d'un polynme de degr 2 : ax+bx+c=0 }

Function Polynome(A,B,C:Real; VAR S1,S2:Real):Boolean;
Var
 Ok : Boolean;
 D  : Real;
Begin
 D:=Sqr(B)-4*A*C;
 If (D>=0) Then
  Begin
   Ok:=True;
   S1:=(-B-Sqrt(D))/(2*A);
   S2:=(-B+Sqrt(D))/(2*A);
  End
 Else
  Ok:=False;
 Polynome:=Ok;
End;

{ Calcul l'intersection entre une droite (u,O) et une sphre (C,r) }
{ Renvoit le rsultat dans I1,I2                                   }

Function InterSphereDroite (u,O:Coord; C:Coord; R:Real;
                            VAR I1,I2:Coord):Boolean;
Var
 Ok    : Boolean;
 I,J,K : Real;
 S1,S2 : Real;
Begin
 I:=Sqr(u.X)+Sqr(u.Y)+Sqr(u.Z);
 J:=2*( u.X*(O.X-C.X) + u.Y*(O.Y-C.Y) + u.Z*(O.Z-C.Z) );
 K:=Sqr(O.X)+Sqr(O.Y)+Sqr(O.Z)+Sqr(C.X)+Sqr(C.Y)+Sqr(C.Z)
    -2*( O.X*C.X + O.Y*C.Y + O.Z*C.Z ) - Sqr(r);
 If Polynome(I,J,K,S1,S2) Then
  Begin
   Ok:=True;
   I1.X:=O.X + S1*u.X;
   I1.Y:=O.Y + S1*u.Y;
   I1.Z:=O.Z + S1*u.Z;
   I2.X:=O.X + S2*u.X;
   I2.Y:=O.Y + S2*u.Y;
   I2.Z:=O.Z + S2*u.Z;
  End
 Else Ok:=False;
 InterSphereDroite:=Ok;
End;

Function Egal (U,V:Coord):Boolean;
Begin
 Egal:=(Abs(U.X-V.X)<Epsilon) And
       (Abs(U.Y-V.Y)<Epsilon) And
       (Abs(U.Z-V.Z)<Epsilon);
End;

Function Distance (A,B:Coord):Real;
Begin
 Distance:=Sqrt(Sqr(A.X-B.X)+Sqr(A.Y-B.Y)+Sqr(A.Z-B.Z));
End;

Function InterPlanDroite (u,A:Coord; O,n:Coord;VAR I:Coord):Boolean;
Var
 Sc1,Sc2:Real;
 AO:Coord;  { Origine plan - Origine droite }
 L:Real;    { Paramtre intersection de la droite }
Begin
 Sc1:=Scalaire(n,u);
 If (Abs(Sc1)<Epsilon) Then Begin; InterPlanDroite:=False; Exit; End;
 Sous(O,A,AO);
 Sc2:=Scalaire(AO,n);
 L:=Sc2/Sc1;
 Lineaire(A,1,u,L,I);  { I = A + Lambda.u }
 InterPlanDroite:=True;
End;

Procedure Reflechie(A,N:Coord;VAR B:Coord);
Var
 Sc  : Real;
 Vec : Coord; { Dummy ! }
Begin
 Sc:=Scalaire(N,A);
 ScMult(A,-1/Sc,A);      { Trouv le vecteur A de bonne longueur        }
 Addi(A,N,Vec);
 Addi(N,Vec,B);          { Et hop ! Vecteur directeur rflchi trouv ! }
 Unitaire(B,B);          { Normalisation de B                           }
End;

Begin
End.