
Unit Vect3d;
{ (c) Copyright 1996 Laurent GREGOIRE                   }
{ e-Mail : Cyber2Casa@aol.com                           }
{          Laurent.Gregoire@f109.n176.fm.alphanet.ch    }
{ BBS support Xenakys : (+033)  02.40.48.76.85          }
{-------------------------------------------------------}
{ This program belong to the public domain              }
{ Ce programme fait partie du domaine public            }
{-------------------------------------------------------}
{ Gestion des vecteurs en 3 dimensions                  }
{ Cette unit n'est pas complete et devrait tre        }
{ complt de plusieurs routines de base                }

Interface

Type
 TpCoord = Record
  X,Y,Z : Real;
 End;

Const
 V3_Nul : TpCoord = (X:0; Y:0; Z:0);
 V3_i   : TpCoord = (X:1; Y:0; Z:0);
 V3_j   : TpCoord = (X:0; Y:1; Z:0);
 V3_k   : TpCoord = (X:0; Y:0; Z:1);

{ Norme au carr du vecteur V }
Function  V3_Norme2   (V:TpCoord)     :Real;
{ Norme simple du vecteur V }
Function  V3_Norme    (V:TpCoord)     :Real;
{ Vecteur unitaire du vecteur V }
Procedure V3_Unitaire (VAR V:TpCoord);
{ Produit scalaire des deux vecteurs }
Function  V3_Scalaire (V1,V2:TpCoord) :Real;

Implementation

Uses
 Erreur,Maths;

Function V3_Norme2(V:TpCoord):Real;
Begin
 V3_Norme2:=Sqr(V.X)+Sqr(V.Y)+Sqr(V.Z);
End;

Function V3_Norme(V:TpCoord):Real;
Begin
 V3_Norme:=RAC(V3_Norme2(V));
End;

Procedure V3_Unitaire(VAR V:TpCoord);
Var N:Real;
Begin
 N:=V3_Norme(V);
 If (N=0) Then Begin; ER_Creer(ER_MathsCapacite); V:=V3_Nul; End
 Else
  Begin
   V.X:=V.X/N;
   V.Y:=V.Y/N;
   V.Z:=V.Z/N;
  End;
End;

Function V3_Scalaire(V1,V2:TpCoord):Real;
Begin
 V3_Scalaire:=V1.X*V2.X+V1.Y*V2.Y+V1.Z*V2.Z;
End;

Begin
End.
