
Unit Souris;
{ (c) Copyright 1996 Laurent GREGOIRE                   }
{ e-Mail : Cyber2Casa@aol.com                           }
{          Laurent.Gregoire@f109.n176.fm.alphanet.ch    }
{ BBS support Xenakys : (+033)  02.40.48.76.85          }
{-------------------------------------------------------}
{ This program belong to the public domain              }
{ Ce programme fait partie du domaine public            }
{-------------------------------------------------------}
{ Gestion de la souris                                  }

Interface

Type
 { Type d'un masque de pointeur de souris }
 S_TpDessin   = Array[0..1,0..15] Of Integer;
 { Type d'un pointeur de souris, avec masque (dessin) et position "hot spot" }
 S_CursGraph  = Record
  Dessin      : S_TpDessin;
  X,Y         : Integer;
 End;
 S_TypeSouris = Record
  VerEnt      : Byte;
  VerDec      : Byte;
  Typ         : Byte;
  IRQ         : Byte;
 End;

Const
 S_Bus      = 1;
 S_Serielle = 2;
 S_InPort   = 3;
 S_PS2      = 4;
 S_HP       = 5;
 S_IRQ_PS2  = 0;
 S_Freq0    = 1;
 S_Freq30   = 2;
 S_Freq50   = 4;
 S_Freq100  = 8;
 S_Freq200  = 16;
 S_Sablier  : S_CursGraph
            = (Dessin:((-32767,-12277,-12277,-10213,-10213,-9157,-8581,-8581,
                        -8581,-8581,-9157,-10213,-10213,-12277,-12277,-32767),
                       (0,2016,2016,960,960,384,0,0,0,0,384,960,960,2016,2016,0));
                       X:7;Y:7);
 S_Fleche   : S_CursGraph
            = (Dessin:((32767,16383,8191,4095,2047,1023,511,255,127,63,31,31,2047,4095,8191,16383),
                       (0,0,16384,24576,28672,30720,31744,32256,32512,32640,32704,30720,28672,24576,16384,0));
                       X:0;Y:0);
 S_Main     : S_CursGraph
            = (Dessin:((-3073,-7681,-7681,-7681,-7681,-8065,-8177,-8185,-16377,-16377,-16377,-16377,-8177,-4065,-1985,-897),
                       (0,3072,3072,3072,3072,3072,3456,3504,7600,8112,8176,8176,4064,1984,896,0));
                       X:4;Y:0);

Var
 { Bouton Droit, Bouton Gauche }
 S_BDs,S_BGs:Boolean;
 { Bouton Droit et Gauche de la lecture prcdente }
 S_BDa,S_BGa:Boolean;
 { Position X et Y }
 S_Xs,S_Ys:Integer;
 { Position X et Y de la lecture prcdente }
 S_Xa,S_Ya:Integer;

{ Initialise la souris }
Procedure S_Init;

{ Affiche le pointeur de souris (i=i+1; pointeur affich si i>0 }
Procedure S_Affiche;

{ Efface le pointeur de souris (i=i-1; pointeur efface si i<=0 }
Procedure S_Efface;

{ Position X du pointeur de souris }
Function  S_X                 :Integer;

{ Position Y du pointeur de souris}
Function  S_Y                 :Integer;

{ Bouton Droit }
Function  S_BD                :Boolean;

{ Bouton gauche }
Function  S_BG                :Boolean;

{ Dplacement X }
Function  S_DX                :Integer;

{ Dplacement Y }
Function  S_DY                :Integer;

{ Est-ce que la souris bouge en ce moment ? }
Function  S_Bouge             :Boolean;

{ Est-ce que le bouton Droit vient d'tre relach ? }
Function  S_BDRelache         :Boolean;

{ Idem avec le gauche ? }
Function  S_BGRelache         :Boolean;

{ Est-ce que le bouton Droit vient d'tre enfonc ? }
Function  S_BDAppuie          :Boolean;

{ Idem avec le bouton gauche }
Function  S_BGAppuie          :Boolean;

{ Place le pointeur de souris  la position X,Y }
Procedure S_PlacePointeur      (X,Y:Integer);

{ Autorise le dplacement du pointeur uniquement dans la zone rectangulaire }
Procedure S_Deplacement        (Xd,Yd,Xf,Yf:Integer);

{ Affiche le pointeur de souris partout, sauf dans la zone rectangulaire }
Procedure S_Exclusion          (Xd,Yd,Xf,Yf:Integer);

{ Supprime la zone d'exclusion prcdemment mise en route }
Procedure S_DelExclusion;

{ Dfinit un nouveau pointeur de souris }
Procedure S_FormePointeur      (Desc:S_CursGraph);

{ Dfinit un nouveau pointeur de souris en mode texte }
Procedure S_PointeurTexte      (Couleur,Forme:Byte);

{ Dfinit un nouveau ratio de dplacement de la souris }
Procedure S_RatioPixel         (X,Y:Integer);

{ Double la vitesse (ne marche pas avec tous les drivers }
Procedure S_DoubleVitesse      (L:Integer);

{ Met la vitesse maxi (ne marche pas avec tous les drivers }
Procedure S_Vitesse            (Vx,Vy:Integer);

{ Dfinit la frquence d'interruption du drivers de souris }
{ Cad la prcision du scan }
Procedure S_FrequenceIntr      (Freq:Integer);

{ Renvoit un descripteur de la souris (enfin, de son driver) }
Procedure S_QuelType           (VAR TpS:S_TypeSouris);

{ A appeller  chaque fois, si on veut utiliser les fonctions S_Bouge, }
{ S_BGAppui, S_BGRelache... }
Procedure S_Scrute;

{ True si S_X,S_Y dans le rectangle }
Function  S_In                 (Xd,Yd,Xf,Yf:Integer)    :Boolean;

{ True si (X,Y) dans le rectangle }
Function  S_PtIn               (X,Y,Xd,Yd,Xf,Yf:Integer):Boolean;

{ True si la souris vient d'entrer dans la zone rectangle }
Function  S_EntreZone          (Xd,Yd,Xf,Yf:Integer)    :Boolean;

{ True si la souris vient d'en sortir }
Function  S_SortZone           (Xd,Yd,Xf,Yf:Integer)    :Boolean;

{ True si un clic vient d'tre opr dans la zone }
Function  S_DebutClicZone      (Xd,Yd,Xf,Yf:Integer)    :Boolean;

{ True si un clic vient d'tre enlev de la zone (fin de la pression du }
{ bouton ou la souris sort ) }
Function  S_FinClicZone        (Xd,Yd,Xf,Yf:Integer)    :Boolean;

Implementation

Uses
 Dos,Crt,Erreur;

Var
 Reg:Registers;

Procedure S_Init;
Begin
 Reg.Ax:=$00;
 Intr($33,Reg);
 If (Reg.Ax=$00) Then ER_Creer(ER_DriverSouris);
End;

Procedure S_Affiche;
Begin
 Reg.Ax:=$01;
 Intr($33,Reg);
End;

Procedure S_Efface;
Begin
 Reg.Ax:=$02;
 Intr($33,Reg);
End;

Function S_X:Integer;
Begin
 Reg.Ax:=$03;
 Intr($33,Reg);
 S_X:=Reg.Cx;
End;

Function S_Y:Integer;
Begin
 Reg.Ax:=$03;
 Intr($33,Reg);
 S_Y:=Reg.Dx;
End;

Function S_BD:Boolean;
Begin
 Reg.Ax:=$03;
 Intr($33,Reg);
 S_BD:=(Reg.Bx And 2)<>0;
End;

Function S_BG:Boolean;
Begin
 Reg.Ax:=$03;
 Intr($33,Reg);
 S_BG:=(Reg.Bx And 1)<>0;
End;

Function S_Bouge:Boolean;
Begin
 S_Bouge:=((S_Xs<>S_Xa) Or (S_Ys<>S_Ya));
End;

Function S_BDRelache:Boolean;
Begin
 S_BDRelache:=(S_BDa And Not(S_BDs));
End;

Function S_BGRelache:Boolean;
Begin
 S_BGRelache:=(S_BGa And Not(S_BGs));
End;

Function S_BDAppuie:Boolean;
Begin
 S_BDAppuie:=(Not(S_BDa) And S_BDs);
End;

Function S_BGAppuie:Boolean;
Begin
 S_BGAppuie:=(Not(S_BGa) And S_BGs);
End;

Procedure S_PlacePointeur(X,Y:Integer);
Begin
 Reg.Ax:=4;
 Reg.Cx:=X;
 Reg.Dx:=Y;
 Intr($33,Reg);
End;

Procedure S_Deplacement(Xd,Yd,Xf,Yf:Integer);
Begin
 Reg.Ax:=7;
 Reg.Cx:=Xd;
 Reg.Dx:=Xf;
 Intr($33,Reg);
 Reg.Ax:=8;
 Reg.Cx:=Yd;
 Reg.Dx:=Yf;
 Intr($33,Reg);
End;

Procedure S_Exclusion          (Xd,Yd,Xf,Yf:Integer);
Begin
 Reg.Ax:=$10;
 Reg.Cx:=Xd;
 Reg.Dx:=Yd;
 Reg.Si:=Xf;
 Reg.Di:=Yf;
 Intr($33,Reg);
End;

Procedure S_DelExclusion;
Begin
 S_Exclusion(0,0,0,0);
End;

Procedure S_FormePointeur(Desc:S_CursGraph);
Begin
 Reg.Ax:=9;
 Reg.Bx:=Desc.X;
 Reg.Cx:=Desc.Y;
 Reg.Dx:=Ofs(Desc.Dessin);
 Reg.Es:=Seg(Desc.Dessin);
 Intr($33,Reg);
End;

Procedure S_PointeurTexte(Couleur,Forme:Byte);
Begin
 Reg.Ax:=10;
 Reg.Bx:=0;
 Reg.Cx:=Couleur;
 Reg.Dx:=Forme;
 Intr($33,Reg);
End;

Function S_DX:Integer;
Begin
 Reg.Ax:=11;
 Intr($33,Reg);
 S_DX:=Reg.Cx;
End;

Function S_DY:Integer;
Begin
 Reg.Ax:=11;
 Intr($33,Reg);
 S_DY:=Reg.Dx;
End;

Procedure S_RatioPixel(X,Y:Integer);
Begin
 Reg.Ax:=15;
 Reg.Cx:=X;
 Reg.Dx:=Y;
 Intr($33,Reg);
End;

Procedure S_DoubleVitesse(L:Integer);
Begin
 Reg.Ax:=$13;
 Reg.Dx:=L;
 Intr($33,Reg);
End;

Procedure S_Vitesse(Vx,Vy:Integer);
Begin
 Reg.Ax:=$0F;
 Reg.Cx:=Vx;
 Reg.Dx:=Vy;
 Intr($33,Reg);
End;

Procedure S_FrequenceIntr(Freq:Integer);
Begin
 Reg.Ax:=$1C;
 Reg.Bx:=Freq;
 Intr($33,Reg);
End;

Procedure S_QuelType(VAR TpS:S_TypeSouris);
Begin
 Reg.Ax:=$24;
 Intr($33,Reg);
 TpS.VerEnt:=Reg.Bh;
 TpS.VerDec:=Reg.Bl;
 TpS.Typ:=Reg.Ch;
 TpS.IRQ:=Reg.Cl;
End;

Procedure S_Scrute;
Begin
 Reg.Ax:=$03;
 Intr($33,Reg);
 S_Xa:=S_Xs;
 S_Ya:=S_Ys;
 S_Xs:=Reg.Cx;
 S_Ys:=Reg.Dx;
 S_BGa:=S_BGs;
 S_BDa:=S_BDs;
 S_BGs:=(Reg.Bx And $01)<>0;
 S_BDs:=(Reg.Bx And $02)<>0;
End;

Function S_In (Xd,Yd,Xf,Yf:Integer):Boolean;
Begin
 S_In:=((S_Xs>=Xd) And (S_Xs<=Xf) And (S_Ys>=Yd) And (S_Ys<=Yf));
End;

Function S_PtIn (X,Y,Xd,Yd,Xf,Yf:Integer):Boolean;
Begin
 S_PtIn:=((X>=Xd) And (X<=Xf) And (Y>=Yd) And (Y<=Yf));
End;

Function S_EntreZone (Xd,Yd,Xf,Yf:Integer):Boolean;
Begin
 S_EntreZone:=(S_PtIn(S_Xs,S_Ys,Xd,Yd,Xf,Yf)
           And Not(S_PtIn(S_Xa,S_Ya,Xd,Yd,Xf,Yf)));
End;

Function S_SortZone (Xd,Yd,Xf,Yf:Integer):Boolean;
Begin
 S_SortZone:=(S_PtIn(S_Xa,S_Ya,Xd,Yd,Xf,Yf)
          And Not(S_PtIn(S_Xs,S_Ys,Xd,Yd,Xf,Yf)));
End;

Function S_DebutClicZone(Xd,Yd,Xf,Yf:Integer):Boolean;
Begin
 S_DebutClicZone:=(S_EntreZone(Xd,Yd,Xf,Yf) And S_BGs)
               Or (S_In(Xd,Yd,Xf,Yf) And S_BGAppuie);
End;

Function S_FinClicZone(Xd,Yd,Xf,Yf:Integer):Boolean;
Begin
 S_FinClicZone:=(S_SortZone(Xd,Yd,Xf,Yf) And S_BGs)
             Or (S_In(Xd,Yd,Xf,Yf) And S_BGRelache);
End;

Begin
 S_Init;
 S_Xs:=0;
 S_Ys:=0;
 S_BGs:=False;
 S_BDs:=False;
 S_Scrute;
 S_FormePointeur(S_Fleche);
End.
