
Unit MCGA;
{ (c) Copyright 1995 GSoft computing & Laurent Grgoire }
{ e-Mail : Cyber2Casa@aol.com                           }
{          Laurent.Gregoire@f109.n176.fm.alphanet.ch    }
{ BBS support Xenakys : (+033)  02.40.48.76.85          }
{-------------------------------------------------------}
{ This program belong to the public domain              }
{ Ce programme fait partie du domaine public            }
{-------------------------------------------------------}
{ Gestion du mode MCGA (320x200x256) de base            }

Interface

Type
 { Type d'une palette }
 MCGA_Pal = Array[0..2,0..255] Of Byte;
 { Type d'une image-cran }
 MCGA_Pic = Array[0..63999]    Of Byte;
 { Type d'un pointeur sur une image-cran }
 MCGA_Ptr = ^MCGA_Pic;

{ Active le mode MCGA, False si pas russi }
Function  MCGA_Active      : Boolean;
{ Revient en mode texte }
Procedure MCGA_Texte;
{ Attend le retour de trame }
Procedure MCGA_Synchro;
{ Affiche un pixel sur l'cran  la position (X,Y) de couleur Couleur }
Procedure MCGA_Pixel       (X,Y:Word;Couleur:Byte);
{ Renvoit la couleur d'un pixel  la position (X,Y) de l'cran }
Function  MCGA_GetPix      (X,Y:Word):Byte;
{ Fait un zoom matriel sur l'cran, ResY: nb de lignes pour une ligne en mmoire }
Procedure MCGA_Zoom        (ResY:Byte);
{ Met dans les registres la palette PAL }
Procedure MCGA_Palette     (Pal:MCGA_Pal);
{ Dfile l'cran de Dec*4 pixel  Dec=1, dcalage suivant X, Dec=80, suivant Y }
Procedure MCGA_Defile      (Dec:Byte);
{ Copie un bitmap depuis (Xd,Yd) de dim. Larg*Haut, vers (Xf,Yf) }
{ Depuis la page Orig vers la page Dest }
{ Avec l'cran = $A000;  et Orig=Ofs(PageOrig^)+Seg(PageOrig^) }
{ Pareil pour Dest=Ofs(PageDest^)+Seg(PageDest^)  }
{ Attention! La copie est en 16bits, donc Larg doit tre un multiple de 2 ! }
Procedure MCGA_CB          (Xd,Yd,Larg:Word;Haut:Byte;Xf,Yf,Orig,Dest:Word);
{ Copie avec masque (copie seulement les pixels diffrents de 0 }
{ Ici la largeur peut tre impaire }
Procedure MCGA_CB2         (Xd,Yd,Larg:Word;Haut:Byte;Xf,Yf,Orig,Dest:Word);
{ Copie avec masque et incrment de toutes les couleurs de Incre }
Procedure MCGA_CB3         (Xd,Yd,Larg:Word;Haut:Byte;Xf,Yf,Orig,Dest:Word;Incre:Byte);
{ Copie avec masque et clipping sur les bords d'cran }
Procedure MCGA_CB4         (Xd,Yd,Larg,Haut,Xf,Yf:Integer;Orig,Dest:Word);
{ Copie sans masque et clipping sur les bords d'cran }
Procedure MCGA_CB5         (Xd,Yd,Larg,Haut,Xf,Yf:Integer;Orig,Dest:Word);

Implementation

Function MCGA_Active;
 Begin
  Asm
   Mov  Ah,0
   Mov  Al,13h
   Int  10h
   Mov  Ah,0Fh
   Int  10h
   Cmp  Al,13h
   Je   @Ok
   Mov  Al,0
   Jmp  @Fin
   @Ok:
   Mov  Al,1
   @Fin:
   Mov  @Result,Al
  End;
 End;

Procedure MCGA_Texte; Assembler;
 Asm
  Mov  Ah,0
  Mov  Al,3
  Int  10h
 End;

Procedure MCGA_Synchro; Assembler;
 Asm
  Mov  Dx,3DAh
  @Debut:
  In   Al,Dx
  Test Al,8
  Jne  @Debut
  @Debut2:
  In   Al,Dx
  Test Al,8
  Je   @Debut2
 End;

Procedure MCGA_Pixel(X,Y:Word;Couleur:Byte); Assembler;
 Asm
  Mov  Ax,Y
  Mov  Bx,X
  Mov  Cl,Couleur
  XChg Ah,Al
  Add  Bx,Ax
  Shr  Ax,1
  Shr  Ax,1
  Add  Bx,Ax
  Mov  Ax,0A000h
  Mov  Es,Ax
  Mov  Es:[Bx],Cl
 End;

Function MCGA_GetPix(X,Y:Word):Byte;
Begin
 MCGA_GetPix:=Mem[$A000:X+(Y Shl 8)+(Y Shl 6)];
End;

Procedure MCGA_Zoom(ResY:Byte); Assembler;
 Asm
  Mov  Dx,3D4h
  Mov  Al,09h
  Out  Dx,Al
  Inc  Dl
  Mov  Al,ResY
  Out  Dx,Al
 End;

Procedure MCGA_Palette (Pal:MCGA_Pal);
Var I,J : Byte;
Begin
 For I:=0 To 255 Do
  Begin
   Port[$3C8]:=I;
   For J:=0 To 2 Do Port[$3C9]:=Pal[J,I];
  End;
End;

Procedure MCGA_Defile (Dec:Byte); Assembler;
 Asm
  Mov  Dx,3D4h
  Mov  Al,0Dh
  Out  Dx,Al
  Inc  Dl
  Mov  Al,Dec
  Out  Dx,Al
 End;

Procedure MCGA_CB (Xd,Yd,Larg:Word;Haut:Byte;Xf,Yf,Orig,Dest:Word); Assembler;
 Asm
  Push Ds
  Mov  Ds,Orig
  Mov  Es,Dest
  Mov  Bx,Xd
  Mov  Ax,Yd
  XChg Ah,Al
  Add  Bx,Ax
  Shr  Ax,1
  Shr  Ax,1
  Add  Bx,Ax
  Mov  Si,Bx
  Mov  Bx,Xf
  Mov  Ax,Yf
  XChg Ah,Al
  Add  Bx,Ax
  Shr  Ax,1
  Shr  Ax,1
  Add  Bx,Ax
  Mov  Di,Bx
  Mov  Dl,0
  Mov  Dh,Haut
  Mov  Ax,Larg
  Mov  Bx,320
  Sub  Bx,Ax
  Shr  Ax,1
  Cld
  @Boucle:
  Inc  Dl
  Mov  Cx,Ax
  Rep  MovSw
  Add  Si,Bx
  Add  Di,Bx
  Cmp  Dl,Dh
  Jne  @Boucle
  Pop  Ds
 End;

Procedure MCGA_CB2 (Xd,Yd,Larg:Word;Haut:Byte;Xf,Yf,Orig,Dest:Word); Assembler;
 Asm
  Push Ds
  Mov  Ds,Orig
  Mov  Es,Dest
  Mov  Bx,Xd
  Mov  Ax,Yd
  XChg Ah,Al
  Add  Bx,Ax
  Shr  Ax,1
  Shr  Ax,1
  Add  Bx,Ax
  Mov  Si,Bx
  Mov  Bx,Xf
  Mov  Ax,Yf
  XChg Ah,Al
  Add  Bx,Ax
  Shr  Ax,1
  Shr  Ax,1
  Add  Bx,Ax
  Mov  Di,Bx
  Mov  Dx,0
  Mov  Ax,Larg
  Mov  Bx,320
  Sub  Bx,Ax
  Cld
  @Boucle1:
  Inc  Dh
  Mov  Cx,Ax
  @Boucle2:
  Mov  Dl,[Si]
  And  Dl,Dl
  Jz   @Suite
  MovSb
  Loop @Boucle2
  Add  Si,Bx
  Add  Di,Bx
  Cmp  Dh,Haut
  Jne  @Boucle1
  Jmp  @Fin
  @Suite:
  Inc  Si
  Inc  Di
  Loop @Boucle2
  Add  Si,Bx
  Add  Di,Bx
  Cmp  Dh,Haut
  Jne  @Boucle1
  @Fin:
  Pop  Ds
 End;

Procedure MCGA_CB3 (Xd,Yd,Larg:Word;Haut:Byte;Xf,Yf,Orig,Dest:Word;Incre:Byte); Assembler;
 Asm
  Push Ds
  Mov  Ds,Orig
  Mov  Es,Dest
  Mov  Bx,Xd
  Mov  Ax,Yd
  XChg Ah,Al
  Add  Bx,Ax
  Shr  Ax,1
  Shr  Ax,1
  Add  Bx,Ax
  Mov  Si,Bx
  Mov  Bx,Xf
  Mov  Ax,Yf
  XChg Ah,Al
  Add  Bx,Ax
  Shr  Ax,1
  Shr  Ax,1
  Add  Bx,Ax
  Mov  Di,Bx
  Mov  Dx,0
  Mov  Ax,Larg
  Mov  Bx,320
  Sub  Bx,Ax
  Cld
  @Boucle1:
  Inc  Dh
  Mov  Cx,Ax
  @Boucle2:
  Mov  Dl,[Si]
  And  Dl,Dl
  Jz   @Suite
  Add  Dl,Incre
  MovSb
  Mov  Es:[Di-1],Dl
  Loop @Boucle2
  Add  Si,Bx
  Add  Di,Bx
  Cmp  Dh,Haut
  Jne  @Boucle1
  Jmp  @Fin
  @Suite:
  Inc  Si
  Inc  Di
  Loop @Boucle2
  Add  Si,Bx
  Add  Di,Bx
  Cmp  Dh,Haut
  Jne  @Boucle1
  @Fin:
  Pop  Ds
 End;

 { Copie masque avec clipping sur bord d'cran cible }
Procedure MCGA_CB4 (Xd,Yd,Larg,Haut,Xf,Yf:Integer;Orig,Dest:Word);
Begin
 If (Xf+Larg<0) Then Exit;
 If (Yf+Haut<0) Then Exit;
 If (Xf>=320) Then Exit;
 If (Yf>=200) Then Exit;
 If (Xf<0) Then Begin; Inc(Larg,Xf); Dec(Xd,Xf); Xf:=0; End;
 If (Xf+Larg>320) Then Larg:=320-Xf;
 If (Yf<0) Then Begin; Inc(Haut,Yf); Dec(Yd,Yf); Yf:=0; End;
 If (Yf+Haut>200)
  Then Haut:=200-Yf;
 Mcga_CB2(Xd,Yd,Larg,Haut,Xf,Yf,Orig,Dest);
End;

 { Copie NON masque avec clipping sur bord d'cran cible }
Procedure MCGA_CB5 (Xd,Yd,Larg,Haut,Xf,Yf:Integer;Orig,Dest:Word);
Begin
 If (Xf+Larg<0) Then Exit;
 If (Yf+Haut<0) Then Exit;
 If (Xf>=320) Then Exit;
 If (Yf>=200) Then Exit;
 If (Xf<0) Then Begin; Inc(Larg,Xf); Dec(Xd,Xf); Xf:=0; End;
 If (Xf+Larg>320) Then Larg:=320-Xf;
 If (Yf<0) Then Begin; Inc(Haut,Yf); Dec(Yd,Yf); Yf:=0; End;
 If (Yf+Haut>200) Then Haut:=200-Yf;
 Mcga_CB(Xd,Yd,Larg,Haut,Xf,Yf,Orig,Dest);
End;

End.