
Unit Maths;
{ Gestion des fonctions mathmatiques avances }
{ Advanced maths functions computing           }
{ (c) Copyright 1996 Laurent GREGOIRE                   }
{ e-Mail : Cyber2Casa@aol.com                           }
{          Laurent.Gregoire@f109.n176.fm.alphanet.ch    }
{ BBS support Xenakys : (+033)  02.40.48.76.85          }
{-------------------------------------------------------}
{ This program belong to the public domain              }
{ Ce programme fait partie du domaine public            }
{-------------------------------------------------------}

Interface

Const
 M_e   = 2.71828182846; { e, base du logarithme naturel ou nprien }
 M_ln2 = 0.69314718056; { Ln(2) }
 M_ln10= 2.30258509299; { Ln(10) }
 M_Log2= 0.30102999566; { Log(2) }
 M_Pi2 = 1.57079632679; { Pi/2 }
 M_Pi3 = 1.0471975512;  { Pi/3 }
 M_Pi4 = 0.785398163397;{ Pi/4 }
 M_Eps = 1.0e-30;       { A little small tiny number }

{ True si X fait partie du domaine des entiers et est un entier }
Function PETITENTIER (X: Real): Boolean;

{ Multiplie A et B }
Function MULTIPLIE (A,B:Real): Real;

{ Puissance entire : Base puissance "N", N entier }
Function INTPOW (Base: Real; N: Integer): Real;

{ Puissance relle : Base puissance E, E rel }
Function POW (Base, E: Real): Real;

{ ArcSinus }
Function ASIN (Ratio: Real): Real;

{ ArcCosinus }
Function ACOS (Ratio: Real): Real;

{ ArcTangente }
Function ATAN (Ratio: Real): Real;

{ Tangente }
Function TAN (Angle: Real): Real;

{ Cotangente }
Function COT (Angle: Real): Real;

{ -1 Si R<0, 0 Si R=0, +1 Si R>0 }
Function SIGN (R: Real): Real;

{ Factorielle de N =1*2*3... *(N-1)*N }
Function FACT (N: Real): Real;

{ Puissance de 10 : 10^E }
Function POW10 (E: Real): Real;

{ Inverse : 1/X }
Function INV (X:Real): Real;

{ Racine carr  : X^(.5) }
Function RAC (X:Real): Real;

{ Et logique }
Function ET (A,B:Real): Real;

{ Non logique }
Function NON (A:Real): Real;

{ Ou exclusif logique }
Function XOU (A,B:Real): Real;

{ Ou logique }
Function OU (A,B:Real): Real;

{ Cosinus Hyperbolique }
Function COSH (Angle:Real): Real;

{ Sinus hyperbolique }
Function SINH (Angle:Real): Real;

{ Tangente hyperbolique }
Function TANH (Angle:Real): Real;

{ Cotangente hyperbolique }
Function COTANH (Angle:Real): Real;

{ Arc sinus hyperbolique }
Function ASINH (Ratio:Real): Real;

{ Arc cosinus hyperbolique }
Function ACOSH (Ratio:Real): Real;

{ Arc tangente hyperbolique }
Function ATANH (Ratio:Real): Real;

{ Logarithme nprien }
Function LOGNEP (X:Real): Real;

{ Logarithme de base BASE }
Function LOGBASE (Base,X:Real): Real;

{ Logarithme dcimal }
Function LOG10 (X:Real): Real;

{ Transforme de degr en radians }
Function RAD (Angle:Real): Real;

{ Transforme de radians en degrs }
Function DEG (Angle:Real): Real;

{ X+1 }
Function INCR (X:Real): Real;

{ X-1 }
Function DECR (X:Real): Real;

{ Racine "nime" }
Function RACN (X,N:Real): Real;

{ Egalit, 1 si A=B }
Function EGAL (A,B:Real): Real;

{ Diffrent de, 1 Si A<>B }
Function DIFF (A,B:Real): Real;

{ Suprieur strictement }
Function SUPE (A,B:Real): Real;

{ Infrieur strictement }
Function INFE (A,B:Real): Real;

{ Suprieur ou gal }
Function SUPEGAL (A,B:Real): Real;

{ Infrieur ou gal }
Function INFEGAL (A,B:Real): Real;

{ Renvoit l'angle tq Cos(Angle)=Dx, Sin(Angle)=Dy }
{ Sert aux transformations des coordonnes cartsiennes aux polaires }
Function ANGLE (Dx,Dy:Real): Real;

{ Division entire }
Function DIVENT (A,B:Real): Real;

{ Modulo }
Function MODENT (A,B:Real): Real;

{ Minimum de X et Y }
Function MIN (A,B:Real): Real;

{ Maximum de X et Y }
Function MAX (A,B:Real): Real;

{ Partie fractionnaire de A }
Function FRACTPART (A:Real): Real;

{ Partie entire de A }
Function INTEGPART (A:Real): Real;

{ Nombre de combinaisons de A dans B }
Function NBCOMB (A,B:Real): Real;

{ Nombre d'arrangements de A dans B }
Function NBARR (A,B:Real): Real;

{ Division de A par B }
Function DIVISE (A,B:Real): Real;

Implementation

Uses
 Erreur;

Function PETITENTIER (X: Real): Boolean;
{ Dtermine si X est un entier compris entre -maxlongint et +maxlongint }
Begin
  If (Abs(X)<MaxLongint) Then PetitEntier:=(X=Trunc(X))
  Else PetitEntier:=False;
End;

Function MULTIPLIE (A,B:Real): Real;
{ Multiplie A par B avec correction de domaine }
Var T:Double;
Begin
 T:=A*B;
 If (Abs(T)>1e38) Then Begin; ER_Creer(ER_MathsCapacite); MULTIPLIE:=0; End
 Else MULTIPLIE:=T;
End;

Function INV (X:Real): Real;
{ Renvoie l'inverse de X }
Begin
 If (Abs(X)<M_Eps) Then Begin; ER_Creer(ER_MathsCapacite); INV:=0; End
 Else INV:=1/X;
End;

Function DIVISE (A,B:Real): Real;
{ Renvois la division de A par B }
Begin
 DIVISE:=A*INV(B);
End;

Function INTPOW (Base: real; N: Integer): Real;
{ Renvoie Base lev  la puissance entire positive N }
Begin
  If N<0 Then ER_Creer(ER_MathsPuissance)
  Else If N=0 Then IntPow:=1
  Else If Odd(N) Then IntPow:=Base*IntPow(Base,N-1)
  Else IntPow:=Sqr(IntPow(Base,N Div 2));
End;

Function EXP2 (A:Real): Real;
{ Renvoie l'exponentielle de l'argument avec correction de domaine }
Begin
 If (A>87) Then Begin; ER_Creer(ER_MathsCapacite); EXP2:=0; End
 Else EXP2:=Exp(A);
End;

Function SQR2 (A:Real): Real;
{ Renvoie le carr de l'argument avec correction de domaine }
Begin
 If (A>1e19) Then Begin; ER_Creer(ER_MathsPuissance); SQR2:=0; End
 Else SQR2:=SQR(A);
End;

Function POW (Base, E: Real): Real;
{ Renvoie Base lev  la puissance relle E }
Begin
  POW:=0;
  If E<0 Then POW:=1/POW(Base,-E)
  Else If (Base=1) Or (E=0) Then POW:=1
  Else If Base=0 Then POW:=0
  Else If PetitEntier(E) Then POW:=IntPow(Base,Trunc(E))
  Else If Base<=0 Then ER_Creer(ER_MathsPuissance)
  Else POW:=Exp2(E*Ln(Base));
End;

Function ASIN (Ratio: Real): Real;
{ Renvoie l'arc sinus de ratio en radian }
Begin
  If (Ratio<=-1) Or (Ratio>=1) Then Begin; ER_Creer(ER_MathsTrigo); ASIN:=0; End
  Else ASIN:=ArcTan(DIVISE(Ratio,Sqrt(MULTIPLIE((1-Ratio),(1+Ratio)))));
End;

Function ACOS (Ratio: Real): Real;
{ Renvoie l'arc cosinus de ratio en radian }
Begin
  If (Ratio<=-1) Or (Ratio>=1) Then Begin; ER_Creer(ER_MathsTrigo); ACOS:=0; End
  Else ACOS:=ArcTan(DIVISE(Sqrt(MULTIPLIE((1-Ratio),(1+Ratio))),Ratio));
End;

Function ATAN (Ratio: Real): Real;
{ Renvoie l'arc tangente de ratio en radian }
Begin
  ATAN:=ARCTAN (Ratio);
End;

Function TAN (Angle: Real): Real;
{ Renvoie la tangente de angle en radian }
Begin
 TAN:=DIVISE(SIN(Angle),COS(Angle));
End;

Function COT (Angle: Real): Real;
{ Renvoie la cotangente de angle en radian }
Var S:Real;
Begin
 COT:=INV(TAN(Angle));
End;

Function SIGN (R: Real): Real;
{ Renvoie -1 si R<0, 0 si R=0, +1 si R>0 }
Begin
  If R>0 Then SIGN:=1
  Else If R<0 Then SIGN:=-1
  Else SIGN:=0;
End;

Function FACT (N: Real): Real;
{ Renvois la factorielle de n, entier positif }
Var K: Integer;
    Ans: Real;
Begin
  FACT:=0;
  Ans:=1.0;
  If ((N<0) Or (N>33)) Then ER_Creer(ER_MathsFactorielle)
  Else For K:=2 to Trunc(N) Do Ans:=K*Ans;
  FACT:=Ans;
End;

Function POW10 (E:Real): Real;
{ Renvoie la puissance de 10 de E }
Begin
 POW10:=POW(10,E);
End;

Function RAC (X:Real): Real;
{ Renvoie la racine carr de X }
Begin
 If (X<0) Then Begin; RAC:=0; ER_Creer(ER_MathsPuissance); End
 Else RAC:=Sqrt(X);
End;

Function TG (A:Real): Boolean;
{ Renvoie si A est trop grand en tant qu'entier }
Begin
 TG:=NOT(PETITENTIER(A));
End;

Function ET (A,B:Real): Real;
{ Renvoie A Et B: oprateur logique }
Begin
 If (TG(A) Or TG(B)) Then Begin; ET:=0; ER_Creer(ER_MathsCapacite); End
 Else ET:=Trunc(A) AND Trunc(B);
End;

Function NON (A:Real): Real;
{ Renvoie Non A: oprateur logique }
Begin
 If TG(A) Then Begin; NON:=0; ER_Creer(ER_MathsCapacite); End
 Else NON:=Not(Trunc(A));
End;

Function XOU (A,B:Real): Real;
{ Renvoie A XOu B: oprateur logique }
Begin
 If (TG(A) Or TG(B)) Then Begin; XOU:=0; ER_Creer(ER_MathsCapacite); End
 Else XOU:=Trunc(A) XOr Trunc(B);
End;

Function OU (A,B:Real): Real;
{ Renvoie A Ou B: oprateur logique }
Begin
 If (TG(A) Or TG(B)) Then Begin; OU:=0; ER_Creer(ER_MathsCapacite); End
 Else OU:=Trunc(A) Or Trunc(B);
End;

Function COSH (Angle:Real): Real;
{ Renvoie le Cosinus Hyperbolique de Angle en radian }
Begin
 COSH:=(Exp2(Angle)+Exp2(-Angle))/2;
End;

Function SINH (Angle:Real): Real;
{ Renvoie le sinus Hyperbolique de Angle en radian }
Begin
 SINH:=(Exp2(Angle)-Exp2(-Angle))/2;
End;

Function TANH (Angle:Real): Real;
{ Renvoie la tangente hyperbolique de Angle en radian }
Begin
 TANH:=DIVISE(SINH(Angle),COSH(Angle));
End;

Function COTANH (Angle:Real): Real;
{ Renvoie la cotangente hyperbolique de Angle en radian }
Begin
 COTANH:=INV(TANH(Angle));
End;

Function ASINH (Ratio:Real): Real;
{ Renvoie l'arc sinus hyperbolique de ratio, en radian }
Begin
 ASINH:=Ln(Ratio+Sqrt(1+SQR2(Ratio)));
End;

Function ACOSH (Ratio:Real): Real;
{ Renvoie l'arc cosinus hyperbolique de ratio, en radian }
Begin
 If (Ratio<1) Then Begin; ACOSH:=0; ER_Creer(ER_MathsTrigo); End
 Else ACOSH:=Ln(Ratio+Sqrt(SQR2(Ratio)-1));
End;

Function ATANH (Ratio:Real): Real;
{ Renvoie l'argument tangente hyperbolique de ratio, en radians }
Begin
 If ((Ratio<-1) Or (Ratio>1)) Then Begin; ATANH:=0; ER_Creer(ER_MathsTrigo); End
 Else ATANH:=0.5*Ln(DIVISE((1+Ratio),(1-Ratio)));
End;

Function LOGNEP (X:Real): Real;
{ Renvoie le logarithme nprien de X }
Begin
 If (X<=0) Then Begin; LOGNEP:=0; ER_Creer(ER_MathsLog); End
 Else LOGNEP:= LN(X);
End;

Function LOGBASE (Base,X:Real): Real;
{ Renvoie le logarithme de base Base de X }
Begin
 LOGBASE:=DIVISE(LOGNEP(X),LOGNEP(Base));
End;

Function LOG10 (X:Real): Real;
{ Renvoie le logarithme dcimal ( de base 10) de X }
Begin
 LOG10:=DIVISE(LOGNEP(X),M_Ln10);
End;

Function RAD (Angle:Real): Real;
{ Renvoie l'angle correspondant en radian  Angle en degr }
Const F=0.01745329252;
Begin
 RAD:=Angle*F;
End;

Function DEG (Angle:Real): Real;
{ Renvoie l'angle correspondant en degr  Angle en radian }
Const F=57.2957795131;
Begin
 DEG:=Angle*F;
End;

Function INCR (X:Real): Real;
{ Renvoie le nombre X incrment de 1 }
Begin
 INCR:=X+1;
End;

Function DECR (X:Real): Real;
{ Renvoie le nombre X dcrment de 1 }
Begin
 DECR:=X-1;
End;

Function RACN (X,N:Real): Real;
{ Renvoie la racine N-ime de X }
Begin
 RACN:=POW(X,INV(N));
End;

Function EGAL (A,B:Real): Real;
{ Renvoie 1 si A=B, 0 sinon }
Begin
 EGAL:=Ord(A=B);
End;

Function DIFF (A,B:Real): Real;
{ Renvoie 1 si A<>B, 0 sinon }
Begin
 DIFF:=Ord(A<>B);
End;

Function SUPE (A,B:Real): Real;
{ Renvoie 1 si A>B, 0 sinon }
Begin
 SUPE:=Ord(A>B);
End;

Function INFE (A,B:Real): Real;
{ Renvoie 1 si A<B, 0 sinon }
Begin
 INFE:=Ord(A<B);
End;

Function SUPEGAL (A,B:Real): Real;
{ Renvoie 1 si A>=B, 0 sinon }
Begin
 SUPEGAL:=Ord(A>=B);
End;

Function INFEGAL (A,B:Real): Real;
{ Renvoie 1 si A<=B, 0 sinon }
Begin
 INFEGAL:=Ord(A<=B);
End;

Function ANGLE (Dx,Dy:Real): Real;
{ Renvoie Angle tel que cos(Angle)=Dx/D, sin(Angle)=Dy/D }
Var
 Ang:Real;
Begin
 If (Abs(Dx)<1e-10) Then
  If (Dy>0) Then Ang:=Pi/2
            Else Ang:=-Pi/2
 Else
  Begin
   Ang:=Arctan(DIVISE(Dy,Dx));
   If (Dx<0) Then Ang:=Ang+Pi;
  End;
 If (Ang>=2*Pi) Then Ang:=Ang-2*Pi
               Else If (Ang<0) Then Ang:=Ang+2*Pi;
 ANGLE:=Ang;
End;

Function DIVENT (A,B:Real): Real;
{ Effectue la division entire de A par B }
Begin
 If (TG(A) Or TG(B)) Then Begin; DIVENT:=0; ER_Creer(ER_MathsCapacite); End
 Else DIVENT:=Trunc(A) DIV Trunc(B);
End;

Function MIN (A,B:Real): Real;
{ Renvoie le minimum de A et B }
Begin
 If (A<B) Then Min:=A
          Else Min:=B;
End;

Function MAX (A,B:Real): Real;
{ Renvoie le maximum de A et B }
Begin
 If (A>B) Then Max:=A
          Else Max:=B;
End;

Function MODENT (A,B:Real): Real;
{ Renvois Ent(b) Mod Ent(a) }
Begin
 If (TG(A) Or TG(B)) Then Begin; MODENT:=0; ER_Creer(ER_MathsCapacite); End
 Else MODENT := Trunc(A) Mod Trunc(B);
End;

Function INTEGPART (A:Real): Real;
{ Renvois la partie entire de A }
Begin
 INTEGPART:=Int(A);
End;

Function FRACTPART (A:Real): Real;
{ Renvois la partie fractionnaire de A }
Begin
 FRACTPART:=A-INTEGPART(A);
End;

Function NBCOMB (A,B:Real): Real;
{ Renvois le nombre de combinaisons de B objets parmis A }
Begin
 NBCOMB:=DIVISE(FACT(A),MULTIPLIE(FACT(B),FACT(A-B)));
End;

Function NBARR (A,B:Real): Real;
{ Renvois le nombre d'arrangement de B objets parmis A }
Begin
 NBARR:=DIVISE(FACT(A),FACT(A-B));
End;

Begin
End.