
Unit
 INIFiles;
{ (c) Copyright 1995 GSoft computing & Laurent Grgoire }
{ e-Mail : Cyber2Casa@aol.com                           }
{          Laurent.Gregoire@f109.n176.fm.alphanet.ch    }
{ BBS support Xenakys : (+033)  02.40.48.76.85          }
{-------------------------------------------------------}
{ This program belong to the public domain              }
{ Ce programme fait partie du domaine public            }
{-------------------------------------------------------}
{ Gestion des fichiers configuration de type INI comme  }
{ Windows                                               }
{ Exemple :                                             }
{ [MAIN]                                                }
{ Description=102                                       }

Interface

Var
 TxtConfig:Array[0..99] Of String[80];

{ A faire avant tout READ ou WRITE }
Procedure IniReadConfig(FileName:String);
{ A faire aprs tout WRITE }
Function IniWriteConfig(FileName:String):Integer;

{ Ecrit le paramtre VALUE dans la ligne PARAM dans la section SECTION }
Procedure IniWriteString(Section,Param,Value:String);
{ Pareil avec un entier }
Procedure IniWriteInteger(Section,Param:String;Value:LongInt);
{ Pareil avec un boolen }
Procedure IniWriteBoolean(Section,Param:String;Value:Boolean);

{ Lit le paramtre de la ligne PARAM dans la section SECTION, si pas trouv }
{ Met la valeur DEFAULTVALUE }
Function IniReadString(Section,Param,DefaultValue:String):String;
{ Idem avec un entier }
Function IniReadInteger(Section,Param:String;DefaultValue,BI,BS:LongInt):LongInt;
{ Idem avec un boolen }
Function IniReadBoolean(Section,Param:String;DefaultValue:Boolean):Boolean;

Implementation

Procedure RazConfig;
Var
 I:Byte;
Begin
 For I:=0 To 99 Do TxtConfig[I]:='';
End;

Procedure IniReadConfig(FileName:String);
Var
 I:Byte;
 F:Text;
Begin
 RazConfig;
 Assign(F,FileName+'.INI');
 Reset(F);
 If (IoResult<>0) Then Exit;
 I:=0;
 While Not(Eof(F)) And (I<=99) Do
  Begin
   ReadLn(F,TxtConfig[I]);
   Inc(I);
  End;
 Close(F);
End;

Function IniWriteConfig(FileName:String):Integer;
Var
 I,Last:Byte;
 F:Text;
Begin
 IniWriteConfig:=0;
 Last:=0;
 For I:=0 To 99 Do
  If (Length(TxtConfig[I])>0) Then Last:=I;
 Assign(F,FileName+'.INI');
 ReWrite(F);
 If (IoResult<>0) Then
  Begin; IniWriteConfig:=1; Exit; End;
 For I:=0 To Last Do
  Begin
   WriteLn(F,TxtConfig[I]);
   If (IoResult<>0) Then
    Begin; IniWriteConfig:=2; Exit; End;
  End;
 Close(F);
End;

Procedure InsertLineConfig(Line:Byte);
Var I:Byte;
Begin
 For I:=99 DownTo Line+1 Do
  TxtConfig[I]:=TxtConfig[I-1];
 TxtConfig[Line]:='';
End;

Function Majuscule(S:String):String;
Var I:Byte;
 Begin
  For I:=1 To Length(S) Do
   S[I]:=UpCase(S[I]);
  Majuscule:=S;
 End;

Procedure IniWriteString(Section,Param,Value:String);
Var
 I,Deb,Fin:ShortInt;
 Ok:Boolean;
Begin
 Deb:=127;
 For I:=0 To 99 Do  { Cherche le dbut de la section }
  If (Majuscule(Section)=Majuscule(TxtConfig[I])) Then Deb:=I;
 If (Deb=127) Then { Pas trouv la section correspondante, on la cre }
  Begin
   Fin:=-1;
   For I:=0 To 99 Do { Cherche la fin de la config. }
    If (Length(TxtConfig[I])>0) Then Fin:=I;
   If (Fin>97) Then Exit;  { Erreur ! on s'en va }
   Inc(Fin); TxtConfig[Fin]:=Section;
   Inc(Fin); TxtConfig[Fin]:=Param+'='+Value;
   Exit;
  End;
 Fin:=99;
 For I:=99 DownTo Deb+1 Do
  If (TxtConfig[I,1]='[') Then Fin:=I;  { Cherche la fin de la section }
 Ok:=False;
 For I:=Deb To Fin Do
  If (Majuscule(Copy(TxtConfig[I],1,Pos('=',TxtConfig[I])-1))=
      Majuscule(Param)) Then
   Begin
    Ok:=True;  { On a trouv }
    Delete(TxtConfig[I],Pos('=',TxtConfig[I])+1,255); { Supp. la valeur existante }
    TxtConfig[I]:=TxtConfig[I]+Value;                 { Ajoute la nouvelle }
   End;
 If Not(Ok) Then { On a pas trouv le paramtre dans la section correspond. }
  Begin
   InsertLineConfig(Deb+1); { Insre une ligne  la position Deb +1 }
   TxtConfig[Deb+1]:=Param+'='+Value; { Ajoute le paramtre }
  End;
End;

Procedure IniWriteInteger(Section,Param:String;Value:LongInt);
Var
 Txt:String;
Begin
 Str(Value,Txt);
 IniWriteString(Section,Param,Txt);
End;

Procedure IniWriteBoolean(Section,Param:String;Value:Boolean);
Const Txt:Array[0..1] Of String[3]=('NON','OUI');
Begin
 IniWriteString(Section,Param,Txt[Ord(Value)]);
End;

Function IniReadString(Section,Param,DefaultValue:String):String;
Var
 I,Deb:Byte;
Begin
 IniReadString:=DefaultValue;
 Deb:=255;
 For I:=0 To 99 Do
  If (Majuscule(Section)=Majuscule(TxtConfig[I])) Then Deb:=I;
 If (Deb=255) Then Exit; { Pas trouv la section correspondante dans INI }
 I:=Deb;
 Repeat
  If (Majuscule(Copy(TxtConfig[I],1,Pos('=',TxtConfig[I])-1))=
      Majuscule(Param)) Then
   { Si on a trouv le nom du paramtre identique avant '=' alors... }
   Begin
    IniReadString:=Copy(TxtConfig[I],Pos('=',TxtConfig[I])+1,255);
    Exit;
   End;
  Inc(I);
 Until (I>99) Or (TxtConfig[I,1]='[');
 { Pas trouv le paramtre, fin du fichier / section suivante, on s'en va }
End;

Function IniReadInteger(Section,Param:String;DefaultValue,BI,BS:LongInt):LongInt;
Var
 Temp:LongInt;
 ErrorCode:Integer;
 Txt:String;
Begin
 IniReadInteger:=DefaultValue;
 Txt:=IniReadString(Section,Param,'Shit, not found! (I)');
 If (Txt='Shit, not found! (I)') Then Exit;  { Pas trouv le paramtre ! }
 Val(Txt,Temp,ErrorCode);
 If (ErrorCode<>0) Then Exit; { Pas bon format numrique }
 If (Temp<BI) Then Temp:=BI;
 If (Temp>BS) Then Temp:=BS;  { Dans les bornes ? }
 IniReadInteger:=Temp;  { Ok, ca baigne }
End;

Function IniReadBoolean(Section,Param:String;DefaultValue:Boolean):Boolean;
Var
 Txt:String;
Begin
 IniReadBoolean:=DefaultValue;
 Txt:=IniReadString(Section,Param,'Shit, not found! (B)');
 If (Txt='Shit, not found! (B)') Then Exit; { Pas trouv le paramtre ! }
 Txt:=Majuscule(Txt);
 If ((Txt='OUI') Or (Txt='O')) Then IniReadBoolean:=True
 Else If ((Txt='NON') Or (Txt='N')) Then IniReadBoolean:=False;
 { Sinon ca chie }
End;

End.