
Unit GrafMCGA;
{ (c) Copyright 1995 GSoft computing & Laurent Grgoire }
{ e-Mail : Cyber2Casa@aol.com                           }
{          Laurent.Gregoire@f109.n176.fm.alphanet.ch    }
{ BBS support Xenakys : (+033)  02.40.48.76.85          }
{-------------------------------------------------------}
{ This program belong to the public domain              }
{ Ce programme fait partie du domaine public            }
{-------------------------------------------------------}
{ Unit graphique diverses pour le mode MCGA 320x200x256}

{$R-}

Interface

Uses Crt,MCGA;

Var
 Palette : MCGA_Pal;
 P       : MCGA_Pal;
 PNoir   : MCGA_Pal;
 PBlanc  : MCGA_Pal;

{ Trace une ligne entre les points (X1,Y1) et (X2,Y2) de couleur Couleur }
Procedure GM_Ligne            (X1,Y1,X2,Y2:Integer; Couleur:Byte);

{ Place une palette standard dans les registres VGA }
Procedure GM_PalStd;

{ Transforme une palette Couleur vers une palette N&B }
Procedure GM_PaletteNB        (PalCol:MCGA_Pal;VAR PalNB:MCGA_Pal);

{ A appeller en initialisation dans un fade out en continu dans vos procdures }
Procedure GM_FOutInit;

{ idem, mais pour un fade in (--> du noir vers votre palette PALSTD (Cf MCGA.PAS) }
Procedure GM_FInInit;

{ A appeller chaque cycle TRC pour faire le fade out }
Procedure GM_FOut;

{ Idem pour le fade in }
Procedure GM_FIn;

{ Fade in total }
Procedure GM_FInTotal;

{ Fade out total }
Procedure GM_FOutTotal;

{ Fade out rapide, sans attendre le retour de trame }
Procedure GM_FOutRapide;

{ Fading gnral : Fade d'une palette Pdeb vers PFin par pas de Pas et de tempo Tempo }
Procedure GM_FPal12           (PDeb,PFin:MCGA_Pal;Pas:Byte;Tempo:Integer);

{ Avance la palette, cad fait un dcalage d'une couleur depuis la couleur }
{ deb jusqua la couleur Fin }
Procedure GM_PalAvance        (Deb,Fin:Byte);

{ Idem mais a reculons }
Procedure GM_PalRecule        (Deb,Fin:Byte);

{ Remplit un rectangle depuis les points (Xd,Yd) vers (Xf,Yf) en couleur Couleur }
Procedure GM_RectRemp         (Xd,Yd,Xf,Yf:Integer; Couleur:Byte);

{ Ligne verticale }
Procedure GM_LigneV           (X,Yd,Yf:Integer; Couleur:Byte);

{ Ligne horizontale }
Procedure GM_LigneH           (Y,Xd,Xf:Integer; Couleur:Byte);

{ Rectangle non remplit }
Procedure GM_Rectangle        (Xd,Yd,Xf,Yf:Integer;Couleur:Byte);

{ Obtient la palette des registres vers la variable Pal }
Procedure GM_GetPalette       (Var Pal:MCGA_Pal);

Implementation

Procedure SwapInt(VAR I1,I2:Integer);
Var dummy : integer;
 Begin
  dummy := i2;
  i2    := i1;
  i1    := dummy;
 End;

Procedure GM_Ligne(X1,Y1,X2,Y2:Integer;Couleur:Byte);
Var d, dx, dy,
    aincr, bincr,
    xincr, yincr,
    x, y          : integer;
 Begin
  If ( Abs(x2-x1) < Abs(y2-y1) ) Then
   Begin
    If ( y1 > y2 ) Then
     Begin
      SwapInt( x1, x2 );
      SwapInt( y1, y2 );
     End;
    If ( x2 > x1 ) then xincr := 1
                   else xincr := -1;
    dy := y2 - y1;
    dx := abs( x2-x1 );
    d  := 2 * dx - dy;
    aincr := 2 * (dx - dy);
    bincr := 2 * dx;
    x := x1;
    y := y1;
    If ((x>=0) And (x<=319) And (y In [0..199])) Then MCGA_Pixel(x,y,Couleur);
    For y:=y1+1 to y2 Do
     Begin
      If ( d >= 0 ) Then
       Begin
        Inc( x, xincr );
        Inc( d, aincr );
       End
      Else Inc( d, bincr );
      If ((x>=0) And (x<=319) And (y In [0..199])) Then MCGA_Pixel(x,y,Couleur);
     End;
   End
  Else
   Begin
    If ( x1 > x2 ) Then
     Begin
      SwapInt( x1, x2 );                   { Oui, change X1 et X2 }
      SwapInt( y1, y2 );                                { Y1 et Y2 }
     End;
    If ( y2 > y1 ) Then yincr := 1            { Fixe le pas vertical }
                   Else yincr := -1;
    dx := x2 - x1;
    dy := abs( y2-y1 );
    d  := 2 * dy - dx;
    aincr := 2 * (dy - dx);
    bincr := 2 * dy;
    x := x1;
    y := y1;
    If ((x>=0) And (x<=319) And (y In [0..199])) Then MCGA_Pixel(x,y,Couleur);
    For x:=x1+1 To x2 Do
     Begin
      If ( d >= 0 ) Then
       Begin
        Inc( y, yincr );
        Inc( d, aincr );
       End
      Else inc( d, bincr );
      If ((x>=0) And (x<=319) And (y In [0..199])) Then MCGA_Pixel(x,y,Couleur);
     End;
   End;
 End;

Procedure GM_PalStd;
Var I,J,K:Byte;
 Begin
  For I:=0 To 39 Do
   Begin
    Palette[0,I]:=Round(I/39*63);
    Palette[1,I]:=Round(I/39*63);
    Palette[2,I]:=Round(I/39*63);
   End;
  For I:=0 To 5 Do For J:=0 To 5 Do For K:=0 To 5 Do
   Begin
    Palette[0,(I*36+J*6+K+40)]:=I*12;
    Palette[1,(I*36+J*6+K+40)]:=J*12;
    Palette[2,(I*36+J*6+K+40)]:=K*12;
   End;
  MCGA_Palette(Palette);
 End;

Procedure GM_PaletteNB        (PalCol:MCGA_Pal;VAR PalNB:MCGA_Pal);
Var
 I,Moy:Byte;
Begin
 For I:=0 To 255 Do
  Begin
   Moy:=Round(PalCol[0,I]*0.3+PalCol[1,I]*0.59+PalCol[2,I]*0.11);
   PalNB[0,I]:=Moy;
   PalNB[1,I]:=Moy;
   PalNB[2,I]:=Moy;
  End;
End;

Procedure GM_FOutInit;
Var J:Word;
 Begin
  P:=Palette;
 End;

Procedure GM_FOut;
Var I,J:Word;
 Begin
  For I:=0 To 2 Do
   For J:=0 To 255 Do
    If (P[I,J]>0) Then Dec(P[I,J]);
  MCGA_Palette(P);
 End;

Procedure GM_FInInit;
Var I,J:Word;
 Begin
  For I:=0 To 2 Do
   For J:=0 To 255 Do P[I,J]:=0;
 End;

Procedure GM_FIn;
Var I,J:Word;
 Begin
  For I:=0 To 2 Do
   For J:=0 To 255 Do
    If (P[I,J]<Palette[I,J]) Then Inc(P[I,J]);
  MCGA_Palette(P);
 End;

Procedure GM_FOutTotal;
Var I:Byte;
 Begin
  GM_FOutInit;
  For I:=0 To 63 Do GM_FOut;
 End;

Procedure GM_FOutRapide;
Var I,J:Integer;
 Begin
  GM_FOutInit;
  For I:=0 To 2 Do
   For J:=0 To 255 Do P[I,J]:=0;
  MCGA_Palette(P);
 End;

Function SGN(X:Integer):ShortInt;
Begin
 If (X=0) Then SGN:=0
 Else If (X>0) Then SGN:=1
 Else SGN:=-1;
End;

Procedure GM_FPal12           (PDeb,PFin:MCGA_Pal;Pas:Byte;Tempo:Integer);
Var I,J,K:Byte;
 Begin
  P:=PDeb;
  MCGA_Palette(P);
  For K:=0 To Pas Do
   Begin
    For I:=0 To 2 Do
     For J:=0 To 255 Do
      P[I,J]:=((PFin[I,J]*K+PDeb[I,J]*(Pas-K)) Div Pas);
    Mcga_Synchro;
    MCGA_Palette(P);
   End;
 End;

Procedure GM_FInTotal;
Var I:Byte;
 Begin
  GM_FInInit;
  For I:=0 To 63 Do GM_FIn;
 End;

Procedure GM_PalAvance(Deb,Fin:Byte);
Var I,T1,T2,T3:Byte;
 Begin
  T1:=Palette[2,Fin];
  T2:=Palette[1,Fin];
  T3:=Palette[0,Fin];
  For I:=Fin DownTo Deb+1 Do
   Begin
    Palette[I*3]:=Palette[I*3-3];
    Palette[I*3+1]:=Palette[I*3-2];
    Palette[I*3+2]:=Palette[I*3-1];
   End;
  Palette[2,Deb]:=T1;
  Palette[1,Deb]:=T2;
  Palette[0,Deb]:=T3;
  MCGA_Palette(Palette);
 End;

Procedure GM_PalRecule(Deb,Fin:Byte);
Var I,T1,T2,T3:Byte;
 Begin
  T1:=Palette[2,Deb];
  T2:=Palette[1,Deb];
  T3:=Palette[0,Deb];
  For I:=Deb+1 To Fin Do
   Begin
    Palette[I*3-3]:=Palette[I*3];
    Palette[I*3-2]:=Palette[I*3+1];
    Palette[I*3-1]:=Palette[I*3+2];
   End;
  Palette[2,Fin]:=T1;
  Palette[1,Fin]:=T2;
  Palette[0,Fin]:=T3;
  MCGA_Palette(Palette);
 End;

Procedure GM_RectRemp(Xd,Yd,Xf,Yf:Integer;Couleur:Byte);
Var I,J,Long:Integer;
 Begin
  If (Xd>Xf) Then SwapInt(Xd,Xf);
  If (Yd>Yf) Then SwapInt(Yd,Yf);
  If (Xd<0) Then Xd:=0;
  If (Yd<0) Then Yd:=0;
  If (Xf>319) Then Xf:=319;
  If (Yf>199) Then Yf:=199;
  Long:=(Xf-Xd)+1;
  For J:=Yd To Yf Do
   FillChar(Mem[$A000:J*320+Xd],Long,Couleur);
 End;

Procedure GM_LigneV (X,Yd,Yf:Integer;Couleur:Byte);
Var I:Integer;
 Begin
  For I:=Yd To Yf Do
   MCGA_Pixel(X,I,Couleur);
 End;

Procedure GM_LigneH (Y,Xd,Xf:Integer;Couleur:Byte);
Var I:Integer;
 Begin
  For I:=Xd To Xf Do
   MCGA_Pixel(I,Y,Couleur);
 End;

Procedure GM_Rectangle (Xd,Yd,Xf,Yf:Integer;Couleur:Byte);
 Begin
  GM_LigneV(Xd,Yd,Yf,Couleur);
  GM_LigneV(Xf,Yd,Yf,Couleur);
  GM_LigneH(Yd,Xd,Xf,Couleur);
  GM_LigneH(Yf,Xd,Xf,Couleur);
 End;

Procedure Init;
Var
 I,J:Byte;
Begin
 For I:=0 To 2 Do
  For J:=0 To 255 Do
   Begin
    PNoir[I,J]:=0;
    PBlanc[I,J]:=64;
   End;
End;

Procedure GM_GetPalette       (Var Pal:MCGA_Pal);
Var I,J:Byte;
Begin
 For I:=0 To 255 Do
  Begin
   Port[$3C7]:=I;
   For J:=0 To 2 Do
    Pal[J,I]:=Port[$3C9];
  End;
End;

Begin
 Init;
End.