
Unit
 EvalF;

{ (c) Copyright 1995 GSoft computing & Laurent Grgoire }
{ e-Mail : Cyber2Casa@aol.com                           }
{          Laurent.Gregoire@f109.n176.fm.alphanet.ch    }
{ BBS support Xenakys : (+033)  02.40.48.76.85          }
{-------------------------------------------------------}
{ This program belong to the public domain              }
{ Ce programme fait partie du domaine public            }
{-------------------------------------------------------}
{ Une autre unit d'interprtation de formules          }
{ Avec trois variables : X,Y,T, (on peut en ajouter)    }
{ Syntaxe standard                                      }
{ Respect de la priorit, des parenthses, des constantes }
{ ... }

Interface

Var
 X,Y,T:Extended;

Const
 Infinited:Extended=1.03216546546E+4932;
 Undefined:Extended=1.03216546545E+4932;
 SyntaxErr:Extended=1.03216546544E+4932;
 Ct_e     :Extended=2.718281828459045235;
 Ct_Pi    :Extended=3.141592653589793238;

Function Compute(S:String):Extended;
Function woBlanck(S:String):String;

Implementation

Const
 NbOp = 6;
 PrOp : Array[1..NbOp] Of Byte
      = (4,4,5,5,8,10);
 IdOp : Array[1..NbOp] Of Char
      = ('+','-','*','/','^','!');
 Ops  : Set Of Char
      = ['+','-','*','/','^','!'];  { Nota : IdOp et Ops doivent tre quasi-ident.! }
      { Ne pas oublier de le rajouter dans la proc. wichresult }

Function woBlanck(S:String):String;
Var
 I:Byte;
Begin
 I:=0;
 While (I<Length(S)) Do
  Begin
   While (I<Length(S)) And (S[I]=' ') Do Delete(S,I,1);
   Inc(I);
  End;
 woBlanck:=S;
End;

Function UpC(S:String):String;
Var
 I:Byte;
Begin
 For I:=1 To Length(S) Do
  S[I]:=UpCase(S[I]);
 UpC:=S;
End;

Function Addition(A,B:Extended):Extended;
Begin
 If ((A=SyntaxErr) Or (B=SyntaxErr))
 Then Addition:=SyntaxErr
 Else If ((A=Infinited) Or (B=Infinited))
 Then Addition:=Infinited
 Else If ((A=Undefined) Or (B=Undefined))
 Then Addition:=Undefined
 Else Addition:=A+B;
End;

Function Soustract(A,B:Extended):Extended;
Begin
 If ((A=SyntaxErr) Or (B=SyntaxErr))
 Then Soustract:=SyntaxErr
 Else If ((A=Infinited) Or (B=Infinited))
 Then Soustract:=Infinited
 Else If ((A=Undefined) Or (B=Undefined))
 Then Soustract:=Undefined
 Else Soustract:=A-B;
End;

Function Multiplic(A,B:Extended):Extended;
Begin
 If ((A=SyntaxErr) Or (B=SyntaxErr))
 Then Multiplic:=SyntaxErr
 Else If ((A=Infinited) And (B<>0) Or (B=Infinited) And (A<>0))
 Then Multiplic:=Infinited
 Else If ((A=Infinited) Or (B=Infinited))
 Then Multiplic:=Undefined
 Else If ((A=Undefined) Or (B=Undefined))
 Then Multiplic:=Undefined
 Else Multiplic:=A*B;
End;

Function Division(A,B:Extended):Extended;
Begin
 If ((A=SyntaxErr) Or (B=SyntaxErr))
 Then Division:=SyntaxErr
 Else If (A=Infinited)
 Then Division:=Infinited
 Else If (B=Infinited)
 Then Division:=0
 Else If ((A=Undefined) Or (B=Undefined))
 Then Division:=Undefined
 Else If (B=0) And (A<>0)
 Then Division:=Infinited
 Else If (B=0)
 Then Division:=Undefined
 Else Division:=A/B;
End;

Function PetitEntier(X:Extended):Boolean;
Begin
 If (Abs(X)<MaxLongint) Then PetitEntier:=(X=Trunc(X))
 Else PetitEntier:=False;
End;

Function IntPow(Base:Extended;N:Integer):Extended;
Begin
 If (N<0) Then IntPow:=Undefined
 Else If N=0 Then IntPow:=1
 Else If Odd(N) Then IntPow:=Base*IntPow(Base,N-1)
 Else IntPow:=Sqr(IntPow(Base,N Div 2));
End;

Function Pow(Base,E:Extended):Extended;
Begin
 If (Base=SyntaxErr) Or (E=SyntaxErr)
 Then Pow:=SyntaxErr
 Else If (Base=Infinited) Or (E=Infinited)
 Then Pow:=Infinited
 Else If (Base=Undefined) Or (E=Undefined)
 Then Pow:=Undefined
 Else If (E<0) Then Pow:=1/Pow(Base,-E)
 Else If (Base=1) Or (E=0) Then Pow:=1
 Else If (Base=0) Then Pow:=0
 Else If PetitEntier(E) Then Pow:=IntPow(Base,Trunc(E))
 Else If (Base<=0) Then Pow:=Undefined
 Else Pow:=Exp(E*Ln(Base));
End;

Function Fact(N:Extended):Extended;
Var
 I:Integer;
 Ans:Extended;
Begin
 If (N=SyntaxErr)
 Then Fact:=SyntaxErr
 Else If (N=Infinited)
 Then Fact:=Infinited
 Else If (N=Undefined) Or (N<0) Or (N>1753) Or (N<>Round(N))
 Then Fact:=Undefined
 Else
  Begin
   Ans:=1;
   For I:=2 To Round(N) Do
    Ans:=Ans*I;
   Fact:=Ans;
  End;
End;

Function Cosinus(A:Extended):Extended;
Begin
 If (A=SyntaxErr)
 Then Cosinus:=SyntaxErr
 Else If (A=Infinited) Or (A=Undefined)
 Then Cosinus:=Undefined
 Else Cosinus:=Cos(A);
End;

Function Sinus(A:Extended):Extended;
Begin
 If (A=SyntaxErr)
 Then Sinus:=SyntaxErr
 Else If (A=Infinited) Or (A=Undefined)
 Then Sinus:=Undefined
 Else Sinus:=Sin(A);
End;

Function LogNep(A:Extended):Extended;
Begin
 If (A=SyntaxErr)
 Then LogNep:=SyntaxErr
 Else If (A=Infinited) Or (A<0)
 Then LogNep:=Infinited
 Else If (A<0)
 Then LogNep:=Undefined
 Else LogNep:=Ln(A);
End;

Function Exponen(A:Extended):Extended;
Begin
 If (A=SyntaxErr)
 Then Exponen:=SyntaxErr
 Else If (A=Infinited)
 Then Exponen:=Infinited
 Else Exponen:=Exp(A);
End;

{ Renvoit l'oprande  gauche de Ini, sans ini }
Function ParLeft(S:String;Ini:Byte):String;
Begin
 ParLeft:=Copy(S,1,Ini-1);
End;

{ Renvoit l'oprande  droite de Ini, sans ini }
Function ParRight(S:String;Ini:Byte):String;
Begin
 ParRight:=Copy(S,Ini+1,Length(S)-Ini);
End;

Function UnaryOp(S:String):Boolean;
Begin
 If ((Copy(S,1,3)='COS')) Then UnaryOp:=True
 Else If ((Copy(S,1,3)='SIN')) Then UnaryOp:=True
 Else If ((Copy(S,1,2)='LN')) Then UnaryOp:=True
 Else If ((Copy(S,1,3)='EXP')) Then UnaryOp:=True
 Else UnaryOp:=False;
End;

Function WichResult(S:String):Extended;
Var
 PriorityMin:Byte;  { Priorite maximale }
 PlaceOfPr  :Byte;  { Place de la priorite maximale }
 ParLevel   :ShortInt; { Niveau de parenthses }
 I,J:Byte;
 X2:Extended;
 ErrorCode:Integer;
Begin
 PriorityMin:=255;
 ParLevel:=0;
 {*************** SI UNE CHAINE VIDE, ON SAIT PAS CE QUE C'EST ***}
 If (S='') Then
  Begin
   WichResult:=SyntaxErr;
   Exit;
  End;
 {****************** RECHERCHE DE L'OPERATEUR A PLUS FAIBLE PRIORITE DANS *}
 {****************** LE NIVEAU DE PARENTHESE EN COURS *********************}
 For I:=Length(S) DownTo 1 Do
  If ((S[I] In Ops) And (ParLevel=0)) Then
   Begin
    For J:=1 To NbOp Do
     If (S[I]=IdOp[J]) Then
      If (S[I]<>'-') Or
         (S[I]='-') And (I=1) Or
         (S[I]='-') And (I<>1) And (S[I-1]<>'E') Then
      If (S[I]<>'+') Or
         (S[I]='+') And (I=1) Or
         (S[I]='+') And (I<>1) And (S[I-1]<>'E') Then
       If (PrOp[J]<PriorityMin) Then
        Begin
         PriorityMin:=PrOp[J];
         PlaceOfPr:=I;
        End;
   End
  Else If (S[I]='(') Then Inc(ParLevel)
  Else If (S[I]=')') Then Dec(ParLevel);
 {***************************** SI IL Y UN OPERATEUR, ... *****************}
 If (PriorityMin<>255) Then
  Case S[PlaceOfPr] Of
   '+' : WichResult:=Addition (WichResult(ParLeft(S,PlaceOfPr)),
                               WichResult(ParRight(S,PlaceOfPr)));
   '-' : If (PlaceOfPr=1)
          Then WichResult:=Soustract(0,WichResult(ParRight(S,PlaceOfPr)))
          Else WichResult:=Soustract(WichResult(ParLeft(S,PlaceOfPr)),
                                     WichResult(ParRight(S,PlaceOfPr)));
   '*' : WichResult:=Multiplic(WichResult(ParLeft(S,PlaceOfPr)),
                               WichResult(ParRight(S,PlaceOfPr)));
   '/' : WichResult:=Division (WichResult(ParLeft(S,PlaceOfPr)),
                               WichResult(ParRight(S,PlaceOfPr)));
   '^' : WichResult:=Pow      (WichResult(ParLeft(S,PlaceOfPr)),
                               WichResult(ParRight(S,PlaceOfPr)));
   '!' : WichResult:=Fact     (WichResult(ParLeft(S,PlaceOfPr)));
  End
 {************* SINON, PEUT-ETRE EST-CE UNE PARENTHESE, EX: "(3+2)" ******}
 Else
  Begin  { Plus d'oprateurs ? alors c'est soit une constante, soit     }
         { une fonction de type cos(x), soit une variable...            }
   If (S[1]='(') Then  { Une parenthse }
    Begin
     ParLevel:=0;
     J:=Length(S);
     For I:=1 To Length(S) Do
      Case S[I] Of
       ')' : Begin
              Dec(ParLevel);
              If (ParLevel=0) Then
               Begin
                J:=I-1;
                I:=Length(S);  { A VERIFIER !!!!!! }
               End;                     { (Ca y est, Ok...) }
             End;
       '(' : Inc(ParLevel);
      End;
     WichResult:=WichResult(Copy(S,2,J-1));  { A VERIFIER : ",J-1)" } { Oui, oui }
    End
   {************* PEUT-ETRE EST-CE UNE CONSTANTE SEULE ******************}
   Else If (S[1] In ['0'..'9','.']) Then  { Constante ? }
    Begin
     Val(S,X2,ErrorCode);
     If (ErrorCode=0)
      Then WichResult:=X2
      Else WichResult:=SyntaxErr;
    End
   {************** UNE FONCTION UNAIRE, ALORS ??? (COS, SIN, TAN...)******}
   Else If (UnaryOp(S)) Then
    Begin
     If ((Copy(S,1,3)='COS'))
     Then WichResult:=Cosinus(WichResult(ParRight(S,3)))
     Else If ((Copy(S,1,3)='SIN'))
     Then WichResult:=Sinus(WichResult(ParRight(S,3)))
     Else If ((Copy(S,1,2)='LN'))
     Then WichResult:=LogNep(WichResult(ParRight(S,2)))
     Else If ((Copy(S,1,3)='EXP'))
     Then WichResult:=Exponen(WichResult(ParRight(S,3)))
    End
   {*********** ZUT ! ENFIN, UNE VARIABLE ???? ***************************}
   Else If (S[1]='X') Then WichResult:=X
   Else If (S[1]='Y') Then WichResult:=Y
   Else If (S[1]='T') Then WichResult:=T
   {*********** ALORS PEUT-ETRE UN OPERATEUR "SPECIAL" *******************}
   Else If (S[1]='') Then WichResult:=Infinited
   Else If (S[1]='?') Then WichResult:=Undefined
   {*********** UNE CONSTANTE ? ******************************************}
   Else If (S[1]='L') Then WichResult:=Ct_E
   Else If (S[1]='P') Then WichResult:=Ct_Pi
   {********** EH BEN NON. ALORS ON SAIT PAS *****************************}
   Else WichResult:=SyntaxErr;  { On a pas trouv, alors error }
  End;
End;

Function Compute(S:String):Extended;
Begin
 Compute:=WichResult(woBlanck(UpC(S)));
End;

Begin
 X:=Undefined;
 Y:=Undefined;
 T:=Undefined;
End.