
Unit Erreur;
{ Gestion des erreurs, unit MATHS.PAS notament }
{ (c) Copyright 1996 Laurent GREGOIRE }
{ e-Mail : Cyber2Casa@aol.com                           }
{          Laurent.Gregoire@f109.n176.fm.alphanet.ch    }
{ BBS Xenakys : (+033)  02.40.48.76.85                  }

Interface

Const
 ER_RAS                  = 00;
 ER_Graphique            = 10;
 ER_PiloteGraphique      = 11;
 ER_DriverGraphique      = 12;
 ER_ModeGraphique        = 13;
 ER_FonteVectorielle     = 14;
 ER_Souris               = 20;
 ER_DriverSouris         = 21;
 ER_Fichier              = 30;
 ER_OuvertureFichier     = 31;
 ER_FermetureFichier     = 32;
 ER_LectureFichier       = 33;
 ER_EcritureFichier      = 34;
 ER_Maths                = 40;
 ER_MathsCapacite        = 41;
 ER_MathsLog             = 42;
 ER_MathsPuissance       = 43;
 ER_MathsTrigo           = 44;
 ER_MathsFactorielle     = 45;
 ER_Memoire              = 50;
 ER_MemoirePleine        = 51;
 ER_SoundBlaster         = 60;
 ER_SBFichierCTVoice     = 61;
 ER_SBChaineVideCTVoice  = 62;
 ER_SBPiloteCharge       = 63;
 ER_SBVarEnvIntrouvable  = 64;
 ER_SBAdrESIntrouvable   = 65;
 ER_SBNumIntIntrouvable  = 66;
 ER_SBDMAIntrouvable     = 67;
 ER_SBLectureDSP         = 68;
 ER_SBAdrESIncorrecte    = 69;
 ER_SyntheseFM           = 80;
 ER_SBNonTrouvee         = 81;
 ER_CircuitFMNonTrouve   = 82;
 ER_FTPasOperateur       = 100;
 ER_FTPasPar1            = 101;
 ER_FTPasPar2            = 102;
 ER_FTPasPar3            = 103;
 ER_FTNumFormat          = 104;
 ER_Divers               = 10000;

{ Cre l'erreur n (Code) et continue l'xcution }
Procedure ER_Creer    (Code:Word);

{ Efface le code d'erreur de la dernire erreur }
Procedure ER_RAZ;

{ Lit le code d'erreur actuel mais le laisse comme tel }
Function  ER_Lecture                : Integer;

{ Lit le code d'erreur actuel et le remplace par un code ER_Ras }
Function  ER_LectRAZ                : Integer;

{ Renvoit un descriptif sous forme de chane de l'erreur en cours }
Function  ER_Message                : String;

{ Termine l'excution du programme en cours et affiche le message de (Code) }
Procedure ER_Fatale   (Code:Word);

{ Termine l'excution du programme normalement }
Procedure ER_Termine;

Implementation

Uses
 Crt;

Var
 ER_Code         : Integer;
 ER_LastExitProc : Pointer;

Procedure ER_Creer (Code:Word);
Begin
 ER_Code:=Code;
End;

Procedure ER_RAZ;
Begin
 ER_Code:=ER_RAS;
End;

Function ER_Lecture : Integer;
Begin
 ER_Lecture:=ER_Code;
End;

Function ER_LectRAZ : Integer;
Begin
 ER_LectRAZ:=ER_Lecture;
 ER_RAZ;
End;

Function ER_Message : String;
Begin
 Case ER_Code Of
  ER_RAS                   : ER_Message:='Pas d''erreur en cours.';
  ER_Graphique             : ER_Message:='Erreur graphique.';
  ER_PiloteGraphique       : ER_Message:='Erreur pilote graphique.';
  ER_DriverGraphique       : ER_Message:='Erreur driver graphique.';
  ER_ModeGraphique         : ER_Message:='Erreur mode graphique.';
  ER_FonteVectorielle      : ER_Message:='Erreur chargement fonte vectorielle.';
  ER_Souris                : ER_Message:='Erreur de souris.';
  ER_DriverSouris          : ER_Message:='Erreur driver souris.';
  ER_Fichier               : ER_Message:='Erreur E/S fichier.';
  ER_OuvertureFichier      : ER_Message:='Erreur en lecture fichier.';
  ER_FermetureFichier      : ER_Message:='Erreur en fermeture fichier.';
  ER_LectureFichier        : ER_Message:='Erreur en lecture fichier.';
  ER_EcritureFichier       : ER_Message:='Erreur en criture fichier.';
  ER_Maths                 : ER_Message:='Erreur en fonction mathmatique.';
  ER_MathsCapacite         : ER_Message:='Erreur de dpassement de capacit.';
  ER_MathsLog              : ER_Message:='Erreur fonction logarithme dcimal.';
  ER_MathsPuissance        : ER_Message:='Erreur fonction puissance.';
  ER_MathsTrigo            : ER_Message:='Erreur fonction trigonomtrique/hyperbolique.';
  ER_MathsFactorielle      : ER_Message:='Erreur fonction factorielle.';
  ER_Memoire               : ER_Message:='Erreur de mmoire RAM.';
  ER_MemoirePleine         : ER_Message:='Erreur espace mmoire RAM manquant.';
  ER_SoundBlaster          : ER_Message:='Erreur carte SoundBlaster.';
  ER_SBFichierCTVoice      : ER_Message:='Erreur driver Ct-Voice.';
  ER_SBChaineVideCTVoice   : ER_Message:='Erreur chemin driver Ct-Voice vide.';
  ER_SBPiloteCharge        : ER_Message:='Erreur pilote Ct-Voice dj charg.';
  ER_SBVarEnvIntrouvable   : ER_Message:='Erreur variable environnement SoundBlaster.';
  ER_SBAdrESIntrouvable    : ER_Message:='Erreur adresse E/S introuvable SoundBlaster.';
  ER_SBNumIntIntrouvable   : ER_Message:='Erreur numro interruption SoundBlaster.';
  ER_SBDMAIntrouvable      : ER_Message:='Erreur canal DMA SoundBlaster.';
  ER_SBLectureDSP          : ER_Message:='Erreur lecture DSP.';
  ER_SBAdrESIncorrecte     : ER_Message:='Erreur adresse E/S incorrecte SoundBlaster.';
  ER_SyntheseFM            : ER_Message:='Erreur synthse FM SoundBlaster.';
  ER_SBNonTrouvee          : ER_Message:='Erreur carte SoundBlaster non trouve.';
  ER_CircuitFMNonTrouve    : ER_Message:='Erreur circuit synthse FM non trouv.';
  ER_FTPasOperateur        : ER_Message:='Oprateur non trouv dans l''expression.';
  ER_FTPasPar1             : ER_Message:='Premiere oprande non trouve dans l''expression.';
  ER_FTPasPar2             : ER_Message:='Seconde oprande non trouve dans l''expression.';
  ER_FTPasPar3             : ER_Message:='Troisime oprande non trouve dans l''expression.';
  ER_FTNumFormat           : ER_Message:='Format numrique invalide.';
 Else                        ER_Message:='"Errare humanum est"';
 End;
End;

Procedure ER_Fatale (Code:Word);
Begin
 ER_Creer(Code);
 TextMode(Co80);
 ExitProc:=Nil;
 Halt(Word(Code));
End;

Procedure ER_ErreurInconnue;
Begin
 ER_Fatale(ER_Divers);
End;

Procedure ER_Termine;
Begin
 ER_Code:=ER_RAS;
 ExitProc:=ER_LastExitProc;
 Halt(0);
End;

Begin
 ER_Code:=ER_RAS;
 ER_LastExitProc:=ExitProc;
 ExitProc:=@ER_ErreurInconnue;
End.
