
Unit Complexe;
{ (c) Copyright 1996 Laurent GREGOIRE & GSoft computing }
{ e-Mail : Cyber2Casa@aol.com                           }
{          Laurent.Gregoire@f109.n176.fm.alphanet.ch    }
{ BBS Xenakys : (+033)  02.40.48.76.85                  }
{ This program belong to the public domain              }
{ Ce programme fait partie du domaine public            }
{ Gestion des nombres complexes                         }

Interface

Type
 Cmplx=Record
  A,B : Real;
 End;

Const
 C_Zero : Cmplx = (A:0;B:0);
 C_Un   : Cmplx = (A:1;B:0);
 C_i    : Cmplx = (A:0;B:1);
 C_j    : Cmplx = (A:-0.5;B:0.866025403784);

{ Calcule le module d'un nombre complexe au carr }
Function  C_MODULE2      (C:Cmplx):Real;
{ Calcule le module }
Function  C_MODULE       (C:Cmplx):Real;
{ Calcule l'argument, c'est  dire l'angle }
Function  C_ARGUMENT     (C:Cmplx):Real;
{ Multiplie deux nombres complexes }
Procedure C_MULTIPLIE    (C1,C2:Cmplx;VAR R:Cmplx);
{ Multiplication scalaire }
Procedure C_SCMULT       (C1:Cmplx;S:Real;VAR R:Cmplx);
{ Division dans le monde complexe }
Procedure C_DIVISE       (C1,C2:Cmplx;VAR R:Cmplx);
{ Addition }
Procedure C_ADDITIONNE   (C1,C2:Cmplx;VAR R:Cmplx);
{ Soustraction }
Procedure C_SOUSTRAIT    (C1,C2:Cmplx;VAR R:Cmplx);
{ Inverse }
Procedure C_INVERSE      (C:Cmplx;VAR R:Cmplx);
{ Oppos }
Procedure C_OPPOSE       (C:Cmplx;VAR R:Cmplx);
{ Racine }
Procedure C_RACINE       (C:Cmplx;VAR R:Cmplx);
{ Partie relle }
Function  C_REEL         (C:Cmplx):Real;
{ Partie imaginaire }
Function  C_IMAG         (C:Cmplx):Real;
{ Assigne Re(C)=Re, Im(C)=Im }
Procedure C_ASSIGNE      (Re,Im:Real;VAR C:Cmplx);

Implementation

Uses
 Maths;

Function C_MODULE2(C:Cmplx):Real;
Begin
 C_MODULE2:=SQR(C.A)+SQR(C.B);
End;

Function C_MODULE(C:Cmplx):Real;
Begin
 C_MODULE:=RAC(C_MODULE2(C));
End;

Function C_ARGUMENT(C:Cmplx):Real;
Begin
 C_ARGUMENT:=ANGLE(C.A,C.B);
End;

Procedure C_MULTIPLIE(C1,C2:Cmplx;VAR R:Cmplx);
Begin
 R.A:=C1.A*C2.A-C1.B*C2.B;
 R.B:=C1.A*C2.B+C1.B*C2.A;
End;

Procedure C_SCMULT(C1:Cmplx;S:Real;VAR R:Cmplx);
Begin
 R.A:=C1.A*S;
 R.B:=C1.B*S;
End;

Procedure C_DIVISE(C1,C2:Cmplx;VAR R:Cmplx);
Var M:Real;
Begin
 M:=C_MODULE(C2);
 R.A:=DIVISE(C1.A*C2.A+C1.B*C2.B,M);
 R.B:=DIVISE(C1.B*C2.A-C1.A*C2.B,M);
End;

Procedure C_ADDITIONNE(C1,C2:Cmplx;VAR R:Cmplx);
Begin
 R.A:=C1.A+C2.A;
 R.B:=C1.B+C2.B;
End;

Procedure C_SOUSTRAIT(C1,C2:Cmplx;VAR R:Cmplx);
Begin
 R.A:=C1.A-C2.A;
 R.B:=C1.B-C2.B;
End;

Procedure C_INVERSE(C:Cmplx;VAR R:Cmplx);
Begin
 C_DIVISE(C_Un,C,R);
End;

Procedure C_OPPOSE(C:Cmplx;VAR R:Cmplx);
Begin
 C_SOUSTRAIT(C_Zero,C,R);
End;

Procedure C_RACINE(C:Cmplx;VAR R:Cmplx);
Var M:Real;
Begin
 M:=C_MODULE(C);
 R.A:=RAC((C.A+M)/2);
 R.B:=RAC((M-C.A)/2);
End;

Function C_REEL(C:Cmplx):Real;
Begin
 C_REEL:=C.A;
End;

Function C_IMAG(C:Cmplx):Real;
Begin
 C_IMAG:=C.B;
End;

Procedure C_ASSIGNE(Re,Im:Real;VAR C:Cmplx);
Begin
 C.A:=Re;
 C.B:=Im;
End;

Begin
End.