
Unit AnaFor;
{ Gestion des formules et transformation de type standard en type pointeur }
{ (c) Copyright 1996 GSoft computing & Laurent GREGOIRE               }
{ e-Mail : Cyber2Casa@aol.com                           }
{          Laurent.Gregoire@f109.n176.fm.alphanet.ch    }
{ BBS Xenakys : (+033)  02.40.48.76.85                  }
{ ----------------------------------------                            }
{ This program belong to the public domain                            }
{ ----------------------------------------                            }
{ Transforme une formule mathmatique F  "n" variables en mode texte }
{ vers une formule compress F' toujours en mode texte, puis vers un  }
{ pointeur P vers une formule, calculable par une fonction AF_CALCULE }

{ Voir le programme exemple fourni avec }

Interface

{ Transforme la formule F standard en notation chane compress }
{ Entre : F Formule crite en langage clair (ex. cos(x) ) }
{ Sortie : F' Formule compresse }
Function  AF_TRANSFORME    (F:String)                      :String;

{ Renvoie le nombre de variables distinctes dans F' formule compresse }
{ Entre : F' Formule compresse }
{ Sortie : Nombre de variables distinctes dans la formule }
Function  AF_NOMBREVAR     (F:String)                      :Byte;

{ Renvoie le nom de la variable en place (Place) dans F' compresse }
{ Entre : F' Formule compresse }
{        : Index de la variable dans le formule compresse (1  n) }
{ Sortie : Nom de la variable au format 'char' }
Function  AF_NOMVAR        (F:String;Place:Byte)           :Char;

{ Assigne l'emplacement mmoire de (X)  la variable (Name) dans (F) }
{ Entre : F' Formule compresse }
{        : Name Nom de la variable dans la formule }
{        : X Variable assigne (relle) }
Procedure AF_ASSIGNE       (F:String;Name:Char;VAR X:Real);

{ Transforme la formule chane compresse (S) en formule pointeur     }
{ Il est inutile, voire dangereux, d'assigner de la place au pointeur }
{ rsultat qui contiendra la formule, par la fonction Getmem ou autre }
{ Entre : S Formule au format compress }
{ Sortie : P Pointeur sur la formule }
{ Vous pouvez donc ne garder que le pointeur et supprimer la chane }
{ pour des gains de place }
Function  AF_TRANSFORME2   (S:String)                      :Pointer;

{ Calcule la formule (F) pour les valeurs des variables en mmoire }
{ Entre : P Pointeur sur la formule a calculer }
{ Sortie : Valeur du rsultat }
Function  AF_CALCULE       (F:Pointer)                     :Real;

{ Supprime dynamiquement de la mmoire la formule (F) }
{ Entre : F Pointeur sur la formule  supprimer }
Procedure AF_SUPPRIME      (VAR F:Pointer);

{ Parenthse : force la priorit }
{ Les priorits des oprateurs sont dfinis comme partout }

{ Oprateur     Emploi        Type               Rsultat                                         }
{                                                                                                 }
{ +             x+y           Addition           x+y                                              }
{ &             x&y           Et logique         1 si x=1 et y=1, 0 sinon                         }
{              xy           Calcul d'angle     Angle "a" tq cos(a)=x et sin(a)=y                }
{ /             x/y           Division           x/y si y non nul                                 }
{ =             x=y           Egalit            1 si x=y, 0 sinon                                }
{ ^             x^y           Puissance          x puissance y                                    }
{ !             x!            Factorielle        1*2*3 ... *(x-1)*x                               }
{ "ascii 25"    x(...)y       Minimum            x si x<y, y sinon                                }
{ "ascii 24"    x(...)y       Maximum            x si x>y, y sinon                                }
{ '             x'            Inverse            1/x si x non nul                                 }
{ <             x<y           Infrieur strict   1 si x<y, 0 sinon                                }
{              xy           Infrieur ou gal  1 si x<=y, 0 sinon                               }
{ ~             x~y           Modulo             x mod y                                          }
{ *             x*y           Multiplication     x+x+x+x... y fois. :)                            }
{              xy           Nb de combinaisons x NbC y                                          }
{  "ascii 196" x            Ngation           -x                                               }
{              xy           Diffrent de       0 si x=y, 1 sinon                                }
{              xy           Nb d'arrangements  x NbA y                                          }
{ :             x:y           Ou logique         0 si x=0 et y=0, 1 sinon                         }
{ %             x%            Pourcentage        x/100                                            }
{              x            Logarithme np.    Ln(x)                                            }
{              x            Puissance de 10    10^x                                             }
{              xy           Puissance de 10    x* (10^y)                                        }
{              xy           Racine "yme"      x^(1/y)                                          }
{ "ascii 15"    x(...)y       Entier             Partie entire de x                              }
{              x            Racine carr       x^(.5)                                           }
{              x            Carr              x                                               }
{ -             x-y           Soustraction       x-y                                              }
{ _             x_y           Ou exclusif logiq. 0 si (x=0) ou (y=0) mais pas les 2 ensemble      }
{ "ascii 16"    x(...)y       Polaire->Cart.     x*Cos(y)                                         }
{ "ascii 30"    x(...)y       Polaire->Cart.     x*Sin(y)                                         }

Implementation

Uses
 Erreur,
 Maths,
 Crt;

Const
 NbOpN  = 31;
 OpNor  : Array[1..NbOpN] Of Char
        = ('+','&','','/','=','^','!',#25,#24,'''','<','','~','*','','',
           '','',':','%','','','','',#15,'','','-','_',#16,#30);
 PrOpN  : Array[1..NbOpN] Of Byte
        = (12,8,16,14,10,20,22,16,16,22,10,10,16,14,16,18,10,16,6,22,16,18,20,20,16,18,22,12,6,16,16);
 TOpN   : Array[1..NbOpN] Of String[3]
        = ('ADD','AND','ANG','DIV','EQU','POW','FAC','MIN','MAX','INV','INF','IOE','MOD','MUL','NCR',
           'NEG','DIF','NPR','ORR','PRC','LNG','P10','PEE','PON','ROU','SQI','SQR','SOU','XOR','VRX','VRY');
 NoOp   = 0;
 OpNb   = 55;
 OpId   : Array[1..OpNb] Of String[3]
        = ('ADD','AND','ANG','COS','ACS','COH','ACH','DEG','DIV','EXP','EQU','POW',
           'FAC','MIN','MAX','FRP','INV','INP','INF','IOE','LNE','LOG','MOD','MUL',
           'NCR','NEG','NOT','DIF','NPR','ORR','PRC','LNG','P10','PEE','RAD','RND',
           'PON','ROU','SGN','SIN','ASN','SNH','ASH','SQI','SQR','SOU','TAN','ATN',
           'TNH','ATH','XOR','VRX','VRY','COT','IDE');
 NbPar  : Array[1..OpNb] Of Byte
        = (2,2,2,1,1,1,1,1,2,1,2,2,1,2,2,1,1,1,2,2,1,1,2,2,2,1,1,2,2,2,1,2,1,2,1,1,2,2,1,1,1,1,1,1,1,2,1,1,1,1,2,2,2,1,1);
 VarId  = '@';
 CnsId  = '#';
 SpId   = [','];
 POId   = ['(','[','{'];
 PCId   = [')',']','}'];
 PtId   = '.';
 PuId   = '';
 NegId  = '\';
 Number = ['\','0'..'9','','.'];
 OkChar = ['\','0'..'9','-','.','','a'..'z','A'..'Z','@','#','(',')',',','[',']','{','}'];

 NumberOfAdress = 50;

Type
 TpOperation=Record
  Item1:Pointer;
  Item2:Pointer;
  OpCod:Byte;
  TpVar:Byte;
 End;

Type
 TpP=^TpOperation;

Var
 CurrentFunction : String;
 VarAdress       : Array[0..NumberOfAdress] Of Pointer;

{ ****** Procdure excute en cas d'erreur ****** }

Procedure ErreurProc;
Begin
 ER_Creer(ER_Divers);
End;

{ ****** Alloue la place mmoire ncessaire pour la fonction ****** }

Procedure CreateForm
          (VAR F:Pointer);
Begin
 If (MemAvail<100) Then Begin; ER_Creer(ER_MemoirePleine); F:=NIL; End
 Else F:=New(TpP);
End;

{ ****** Supprime la fonction de la mmoire pour gain de place (rcurs.) ****** }

Procedure DeleteObj
          (VAR F:Pointer);
Var
 F2 : ^TpOperation;
Begin
 If (F=Nil) Then Exit;
 F2:=F;
 Case F2^.TpVar Of
  6 : Begin
       If (F2^.Item1<>Nil) Then FreeMem(F2^.Item1,SizeOf(Real));
       If (F2^.Item2<>Nil) Then FreeMem(F2^.Item2,SizeOf(Real));
      End;
  4 : Begin
       If (F2^.Item1<>Nil) Then FreeMem(F2^.Item1,SizeOf(Real));
       If (F2^.Item2<>Nil) Then DeleteObj(F2^.Item2);
      End;
  3 : Begin
       If (F2^.Item1<>Nil) Then DeleteObj(F2^.Item1);
       If (F2^.Item2<>Nil) Then DeleteObj(F2^.Item2);
      End;
  2 : If (F2^.Item2<>Nil) Then DeleteObj(F2^.Item2);
  5 : If (F2^.Item1<>Nil) Then FreeMem(F2^.Item1,SizeOf(Real));
 End;
 FreeMem(F,SizeOf(TpOperation));
End;

{ ****** Procdure de suppression / procdure d'appel ****** }

Procedure AF_SUPPRIME
          (VAR F:Pointer);
Var
 LastExitProc:Pointer;
Begin
 LastExitProc:=ExitProc;
 ExitProc:=@ErreurProc;
 DeleteObj(F);
 ExitProc:=LastExitProc;
End;

{ ****** Initialise une fonction pour sa cration / appel  CreateForm ****** }

Procedure InitForm
          (VAR F:Pointer);
Var
 F2:^TpOperation;
Begin
 CreateForm(F);
 F2:=F;
 F2^.OpCod:=0;
 F2^.TpVar:=0;
 F2^.Item1:=Nil;
 F2^.Item2:=Nil;
End;

{ ****** Renvoi le code de fonction opr par la fonction reprsent par f ****** }

Function _OpCod
         (F:Pointer):Byte;
Var
 F2:TpOperation;
Begin
 F2:=TpOperation(F^);
 _OpCod:=F2.OpCod;
End;

{ ****** Renvoi le type d'objets point par la fonction reprsent par f ****** }

Function _TpVar
         (F:Pointer):Byte;
Var
 F2:TpOperation;
Begin
 F2:=TpOperation(F^);
 _TpVar:=F2.TpVar;
End;

{ ****** Assigne dans un cas gnral la fonction f avec OpC : type         }
{  d'opration ralis, TpV : type d'objets points, It1,It2 : les         }
{  objets points                                                   ****** }

Procedure AssignForm
          (VAR F:Pointer;OpC,TpV:Byte;It1,It2:Pointer);
Var
 F2:^TpOperation;
Begin
 F2:=F;
 F2^.OpCod:=OpC;
 F2^.TpVar:=TpV;
 F2^.Item1:=It1;
 F2^.Item2:=It2;
End;

{ ****** Effectue l'oprateur OpC sur les variables X et Y ****** }

Function Calc(OpC:Byte;X,Y:Real):Real;
Begin
 Case OpC Of
  0  : Calc:=0;
  1  : Calc:=X+Y;
  2  : Calc:=ET(X,Y);
  3  : Calc:=ANGLE(X,Y);
  4  : Calc:=COS(X);
  5  : Calc:=ACOS(X);
  6  : Calc:=COSH(X);
  7  : Calc:=ACOSH(X);
  8  : Calc:=DEG(X);
  9  : Calc:=DIVISE(X,Y);
  10 : Calc:=EXP(X);
  11 : Calc:=EGAL(X,Y);
  12 : Calc:=POW(X,Y);
  13 : Calc:=FACT(X);
  14 : Calc:=MIN(X,Y);
  15 : Calc:=MAX(X,Y);
  16 : Calc:=FRACTPART(X);
  17 : Calc:=INV(X);
  18 : Calc:=INTEGPART(X);
  19 : Calc:=INFE(X,Y);
  20 : Calc:=INFEGAL(X,Y);
  21 : Calc:=LOGNEP(X);
  22 : Calc:=LOG10(X);
  23 : Calc:=MODENT(X,Y);
  24 : Calc:=X*Y;
  25 : Calc:=NBCOMB(X,Y);
  26 : Calc:=-X;
  27 : Calc:=NON(X);
  28 : Calc:=DIFF(X,Y);
  29 : Calc:=NBARR(X,Y);
  30 : Calc:=OU(X,Y);
  31 : Calc:=X/100;
  32 : Calc:=SQRT(SQR(X)+SQR(Y));
  33 : Calc:=INTPOW(X,10);
  34 : Calc:=X*INTPOW(Y,10);
  35 : Calc:=RAD(X);
  36 : Calc:=RANDOM*X;
  37 : Calc:=POW(Y,INV(X));
  38 : Calc:=TRUNC(X);
  39 : Calc:=SIGN(X);
  40 : Calc:=SIN(X);
  41 : Calc:=ASIN(X);
  42 : Calc:=SINH(X);
  43 : Calc:=ASINH(X);
  44 : Calc:=RAC(X);
  45 : Calc:=SQR(X);
  46 : Calc:=X-Y;
  47 : Calc:=TAN(X);
  48 : Calc:=ATAN(X);
  49 : Calc:=TANH(X);
  50 : Calc:=ATANH(X);
  51 : Calc:=XOU(X,Y);
  52 : Calc:=X*COS(Y);
  53 : Calc:=X*SIN(Y);
  54 : Calc:=COT(X);
  55 : Calc:=X;
 End;
End;

{ ****** Calcule la fonction point par f avec les variables en mmoire ****** }

Function ComputeForm
         (F:Pointer):Real;
Var
 F2:TpOperation;
Begin
 If (F=Nil) Then Begin; ComputeForm:=0; Exit; End;
 F2:=TpOperation(F^);
 Case F2.TpVar Of
  3     : ComputeForm:=Calc(F2.OpCod,ComputeForm(F2.Item1),ComputeForm(F2.Item2));
  2,4   : ComputeForm:=Calc(F2.OpCod,Real(F2.Item1^),ComputeForm(F2.Item2));
  6,1,5 : ComputeForm:=Calc(F2.OpCod,Real(F2.Item1^),Real(F2.Item2^));
 Else ComputeForm:=0;
 End;
End;

{ ****** Calcule une fonction en un point / procdure appele ****** }

Function AF_CALCULE
         (F:Pointer):Real;
Var
 LastExitProc:Pointer;
Begin
 ER_RAZ;
 LastExitProc:=ExitProc;
 ExitProc:=@ErreurProc;
 AF_Calcule:=ComputeForm(F);
 ExitProc:=LastExitProc;
End;

{ ****** True si la variable C  t trouv dans F avant la place P ****** }

Function WasFound
         (C:Char;F:String;P:Byte):Boolean;
Var
 I:Byte;
Begin
 WasFound:=False;
 For I:=1 To P-1 Do
  If ((F[I]=VarId) And (F[I+1]=C)) Then Begin; WasFound:=True; Exit; End;
End;

{ ****** Renvoi la forme majuscule de S sans les caractres incorrects ****** }

Function UpS
         (S:String):String;
Var
 I:Byte;
Begin
 I:=1;
 Repeat
  If (S[I] In OkChar) Then
   Begin
    S[I]:=UpCase(S[I]);
    Inc(I);
   End
    Else Delete(S,I,1);
 Until (I>Length(S));
 UpS:=S;
End;

{ ****** Renvoi la forme majuscule de S sans tests ****** }

Function UpS2
         (S:String):String;
Var
 I:Byte;
Begin
 For I:=1 To Length(S) Do S[I]:=UpCase(S[I]);
 UpS2:=S;
End;

{ ****** Renvoi le n d'ordre de la variable Name dans la fonction F ****** }

Function FoundPlaceVar
         (F:String;Name:Char):Byte;
Var
 I:Byte;
 Place:Byte;
Begin
 F:=UpS(F);
 Place:=0;
 FoundPlaceVar:=0;
 For I:=1 To Length(F) Do
  If ((F[I]=VarId)
    And Not(WasFound(F[I+1],F,I))) Then
   Begin
    Inc(Place);
    If (F[I+1]=Name) Then Begin; FoundPlaceVar:=Place; Exit; End;
   End;
End;

{ ****** Renvoi le nom de la variable de n d'ordre Place dans F ****** }

Function AF_NOMVAR
         (F:String;Place:Byte):Char;
Var
 I:Byte;
 J:Byte;
Begin
 F:=UpS(F);
 AF_NomVar:=#255;
 J:=0;
 For I:=1 To Length(F) Do
  If ((F[I]=VarId)

    And Not(WasFound(F[I+1],F,I))) Then
   Begin
    Inc(J);
    If (Place=J) Then Begin; AF_NomVar:=F[I+1]; Exit; End;
   End;
End;

{ ****** Renvoi le nombre total de variable diffrentes dans F ****** }

Function NumberOfVar
         (F:String):Byte;
Var
 I:Byte;
 Nb:Byte;
Begin
 F:=UpS(F);
 Nb:=0;
 For I:=1 To Length(F) Do
  If ((F[I]=VarId)
    And (F[I+1] In ['A'..'Z'])
    And Not(WasFound(F[I+1],F,I))) Then Inc(Nb);
 NumberOfVar:=Nb;
End;

{ ****** Fonction renvoyant le nb de variables / procdure d'appel ****** }

Function AF_NOMBREVAR
         (F:String):Byte;
Var
 LastExitProc:Pointer;
Begin
 LastExitProc:=ExitProc;
 ExitProc:=@ErreurProc;
 AF_NombreVar:=NumberOfVar(F);
 ExitProc:=LastExitProc;
End;

{ ****** Assigne la place mmoire X  la variable Name de la fonction F ****** }

Procedure AF_ASSIGNE
          (F:String;Name:Char;VAR X:Real);
Var
 Place:Byte;
Begin
 Place:=FoundPlaceVar(F,UpCase(Name));
 If (Place>NumberOfAdress) Then Place:=NumberOfAdress;
 VarAdress[Place]:=@X;
End;

{ ****** Echange les deux pointeurs P1 et P2 ****** }

Procedure SwapPointer(VAR P1:Pointer;VAR P2:Pointer);
Var
 PDummy:Pointer;
Begin
 PDummy:=P1;
 P1:=P2;
 P2:=PDummy;
End;

{ ****** Transforme S de la notation "string" compress en notation pascal ****** }

Function Trans(S:String):String;
Var
 I:Byte;
Begin
 Trans:=S;
 For I:=1 To Length(S) Do
  Case S[I] Of
   PuId : Trans[I]:='E';
   PtId : Trans[I]:='.';
   NegId: Trans[I]:='-';
  End;
End;

{ ****** Transforme S de la notation pascal en "string" invers ****** }

Function TransInv(S:String):String;
Var
 I:Byte;
Begin
 TransInv:=S;
 For I:=1 To Length(S) Do
  Case S[I] Of
   'E' : TransInv[I]:=PuId;
   '.' : TransInv[I]:=PtId;
   '\' : TransInv[I]:=NegId;
   '0'..'9' : TransInv[I]:=S[I];
  Else TransInv[I]:=' ';
  End;
End;

{ ****** Fonction renvoyant la valeur numrique d'une chane ****** }

Function Val2
         (S:String):Real;
Var
 I        :Byte;
 Exposant :Real;
 Mantisse :Real;
 SExposant:String;
 SMantisse:String;
 CodErr   :Integer;
 T        :Real;
Begin
 S:=UpS2(S);
 If (Pos('E',S)>0) Then
  Begin
   SExposant:=Copy(S,Pos('E',S)+1,2);
   SMantisse:=Copy(S,1,Pos('E',S)-1);
  End
 Else
  Begin
   SExposant:='0';
   SMantisse:=S;
  End;
 Exposant:=0;
 Mantisse:=0;
 Val(SExposant,Exposant,CodErr);
 Val(SMantisse,Mantisse,CodErr);
 While (Mantisse>=10) Do
  Begin
   Mantisse:=Mantisse/10;
   Exposant:=Exposant+1;
  End;
 If (Exposant>37) Then Exposant:=37;
 If (Exposant=0) Then T:=Mantisse
                 Else T:=Mantisse*POW10(Exposant);
 Val2:=T;
End;

{ ****** Renvoi le pointeur cre par WhatFunction pour stocker S ****** }

Function WhatFunction
         (S:String):Pointer;
Var
 F     :Pointer;
 VarTp :Byte;
 OpCod :Byte;
 P1,P2 :Pointer;
 I     :Byte;
 ParLev:ShortInt;
 Middle:Byte;
 Place :Byte;
 S1,S2 :String;
Begin
 WhatFunction:=Nil;
 If (S='') Then Exit;
 S:=UpS(S);
 If (S[1]=VarId) Then
  Begin
   Place:=FoundPlaceVar(CurrentFunction,S[2]);
   If (Place<>0) Then WhatFunction:=VarAdress[Place]
                 Else WhatFunction:=Nil;
   Exit;
  End;
 If (S[1]=CnsId) Then
  Begin
   I:=2;
   Repeat
    Inc(I);
   Until Not(S[I] In Number);
   Dec(I);
   GetMem(P1,SizeOf(Real));
   Real(P1^):=0;
   Real(P1^):=Val2(Trans(Copy(S,2,I-1)));
   WhatFunction:=P1;
   Exit;
  End;
 InitForm(F);
 OpCod:=0;
 For I:=1 To OpNb Do
  If (OpId[I]=Copy(S,1,3)) Then
   OpCod:=I;
 If (OpCod=0) Then Exit;
 Case NbPar[OpCod] Of
  1 : Begin
       If (S[5]=VarId) Then VarTp:=1
        Else If (S[5]=CnsId) Then VarTp:=6
        Else VarTp:=3;
       P1:=WhatFunction(Copy(S,5,Length(S)-5));
       AssignForm(F,OpCod,VarTp,P1,Nil);
      End;
  2 : Begin
       ParLev:=0;
       Middle:=0;
       For I:=5 To (Length(S)-1) Do
        Begin
         If (S[I] In PoId) Then Inc(ParLev);
         If (S[I] In PCId) Then Dec(ParLev);
         If (S[I] In SpId) Then If (ParLev=0) Then Middle:=I;
        End;
       P1:=WhatFunction(Copy(S,5,Middle-5));
       P2:=WhatFunction(Copy(S,Middle+1,Length(S)-Middle-1));
       If ((S[5]=VarId)
          And (S[Middle+1]=VarId)) Then VarTp:=1;
       If ((S[5]=VarId)
          And Not(S[Middle+1] In [VarId,CnsId])) Then VarTp:=2;
       If (Not(S[5] In [VarId,CnsId])
          And Not(S[Middle+1] In [VarId,CnsId])) Then VarTp:=3;
       If (Not(S[5] In [VarId,CnsId])
          And (S[Middle+1]=VarId)) Then Begin
                                         SwapPointer(P1,P2);
                                         VarTp:=2;
                                        End;
       If ((S[5]=CnsId)
          And (S[Middle+1]=CnsId)) Then VarTp:=6;
       If ((S[5]=CnsId)
          And Not(S[Middle+1] In [VarId,CnsId])) Then VarTp:=4;
       If (Not(S[5] In [VarId,CnsId])
          And (S[Middle+1]=CnsId)) Then Begin
                                         SwapPointer(P1,P2);
                                         VarTp:=4;
                                        End;
       If ((S[5]=CnsId)
          And (S[Middle+1]=VarId)) Then VarTp:=5;
       If ((S[5]=VarId)
          And (S[Middle+1]=CnsId)) Then Begin
                                         SwapPointer(P1,P2);
                                         VarTp:=5;
                                        End;
       AssignForm(F,OpCod,VarTp,P1,P2);
      End;
 Else Exit;
 End;
 WhatFunction:=F;
End;

{ ****** Change S de la notation standard en notation "string" compress ****** }

Function TSS
         (S:String):String;
Var
 PrMin:Byte; { Priorit minimale trouve }
 I,J  :Byte;
 Place:Byte; { Place de l'oprateur  priorit minimale }
 OpS  :Byte; { Type de l'oprateur  priorit minimale }
 ParL :ShortInt; { Niveau de parenthse actuel }
Begin
 TSS:='';
 If (S='') Then Exit;
 S:=UpS2(S);
 If S[1]='(' Then
  Begin
   TSS:=TSS(Copy(S,2,Length(S)-2));
   Exit;
  End;
 Place:=0;
 PrMin:=255;
 OpS:=0;
 ParL:=0;
 For I:=1 To Length(S) Do
  Begin
   If (S[I]='(') Then Inc(ParL);
   If (S[I]=')') Then Dec(ParL);
   If (ParL=0) Then
    For J:=1 To NbOpN Do
     If (S[I]=OpNor[J]) Then
      If (PrMin>PrOpN[J]) Then
       Begin
        PrMin:=PrOpN[J];
        Place:=I;
        OpS:=J;
       End;
  End;
 If (Place=0) Then { Cas aucun oprateur }
  Begin
   If (Copy(S,1,3)='COS') Then TSS:='COS('+TSS(Copy(S,4,Length(S)-3))+')'
   Else If (Copy(S,1,4)='ACOS') Then TSS:='ACS('+TSS(Copy(S,5,Length(S)-4))+')'
   Else If (Copy(S,1,4)='COSH') Then TSS:='CSH('+TSS(Copy(S,5,Length(S)-4))+')'
   Else If (Copy(S,1,5)='ACOSH') Then TSS:='ACH('+TSS(Copy(S,6,Length(S)-5))+')'
   Else If (Copy(S,1,3)='DEG') Then TSS:='DEG('+TSS(Copy(S,4,Length(S)-3))+')'
   Else If (Copy(S,1,3)='EXP') Then TSS:='EXP('+TSS(Copy(S,4,Length(S)-3))+')'
   Else If (Copy(S,1,5)='PFRAC') Then TSS:='FRP('+TSS(Copy(S,6,Length(S)-5))+')'
   Else If (Copy(S,1,4)='PENT') Then TSS:='INP('+TSS(Copy(S,5,Length(S)-4))+')'
   Else If (Copy(S,1,2)='LN') Then TSS:='LNE('+TSS(Copy(S,3,Length(S)-2))+')'
   Else If (Copy(S,1,3)='LOG') Then TSS:='LOG('+TSS(Copy(S,4,Length(S)-3))+')'
   Else If (Copy(S,1,3)='NON') Then TSS:='NOT('+TSS(Copy(S,4,Length(S)-3))+')'
   Else If (Copy(S,1,3)='RAD') Then TSS:='RAD('+TSS(Copy(S,4,Length(S)-3))+')'
   Else If (Copy(S,1,3)='RND') Then TSS:='RND('+TSS(Copy(S,4,Length(S)-3))+')'
   Else If (Copy(S,1,3)='SGN') Then TSS:='SGN('+TSS(Copy(S,4,Length(S)-3))+')'
   Else If (Copy(S,1,3)='SIN') Then TSS:='SIN('+TSS(Copy(S,4,Length(S)-3))+')'
   Else If (Copy(S,1,4)='ASIN') Then TSS:='ASN('+TSS(Copy(S,5,Length(S)-4))+')'
   Else If (Copy(S,1,4)='SINH') Then TSS:='SNH('+TSS(Copy(S,5,Length(S)-4))+')'
   Else If (Copy(S,1,5)='ASINH') Then TSS:='ASH('+TSS(Copy(S,6,Length(S)-5))+')'
   Else If (Copy(S,1,3)='TAN') Then TSS:='TAN('+TSS(Copy(S,4,Length(S)-3))+')'
   Else If (Copy(S,1,4)='ATAN') Then TSS:='ATN('+TSS(Copy(S,5,Length(S)-4))+')'
   Else If (Copy(S,1,4)='TANH') Then TSS:='TNH('+TSS(Copy(S,5,Length(S)-4))+')'
   Else If (Copy(S,1,5)='ATANH') Then TSS:='ATH('+TSS(Copy(S,6,Length(S)-5))+')'
   Else If (Copy(S,1,5)='COTAN') Then TSS:='COT('+TSS(Copy(S,6,Length(S)-5))+')'
   Else If (Copy(S,1,5)='IDENT') Then TSS:='IDE('+TSS(Copy(S,6,Length(S)-5))+')'
   Else If (S[1] In ['\','0'..'9','.']) Then TSS:=CnsId+TransInv(S)
                                        Else TSS:=VarId+S[1];
   Exit;
  End;
 If (OpS In [1,2,3,4,5,6,8,9,11,12,13,14,15,17,18,19,21,23,24,25,28,29,30,31])
      Then TSS:=TOpN[OpS]+'('+TSS(Copy(S,1,Place-1))+','+TSS(Copy(S,Place+1,Length(S)-Place))+')'
 Else If (OpS In [7,10,20,22,27])
      Then TSS:=TOpN[OpS]+'('+TSS(Copy(S,1,Place-1))+')'
 Else If (OpS In [16,26])
      Then TSS:=TOpN[OpS]+'('+TSS(Copy(S,Place+1,Length(S)-Place))+')';
End;

{ ****** Procdure de changement de type de fonction / procdure d'appel ****** }

Function AF_TRANSFORME
         (F:String):String;
Var
 Resultat:String;
Begin
 Resultat:=TSS(F);
 If (Resultat[1]='#') Then Resultat:='IDE('+Resultat+')';
 If (Resultat[1]='@') Then Resultat:='IDE('+Resultat+')';
 AF_TRANSFORME:=Resultat;
End;

{ ****** Change S en notation "string" standard en F fonction pointeur ****** }

Function AF_TRANSFORME2
         (S:String):Pointer;
Var
 LastExitProc:Pointer;
Begin
 LastExitProc:=ExitProc;
 ExitProc:=@ErreurProc;
 CurrentFunction:=S;
 If (S='') Then
  Begin
   AF_Transforme2:=Nil;
  End
 Else AF_Transforme2:=WhatFunction(S);
 ExitProc:=LastExitProc;
End;

Begin
End.